/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms.ui;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dragomordor.simpletms.SimpleTMs;
import dragomordor.simpletms.SimpleTMsItems;
import dragomordor.simpletms.api.MoveCaseHelper;
import dragomordor.simpletms.api.MoveCaseStorage;
import dragomordor.simpletms.item.custom.MoveCaseItem;
import dragomordor.simpletms.item.custom.MoveLearnItem;
import dragomordor.simpletms.ui.ClientFilterStorage;
import dragomordor.simpletms.ui.FilterMode;
import dragomordor.simpletms.ui.PokemonFilterData;
import dragomordor.simpletms.ui.SimpleTMsMenuTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b \u0018\u0000 \u008e\u00012\u00020\u0001:\u0002\u008e\u0001BW\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\t\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0014J\u001f\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\"\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b$\u0010%J\u0013\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0&\u00a2\u0006\u0004\b'\u0010(J\r\u0010*\u001a\u00020)\u00a2\u0006\u0004\b*\u0010+J\r\u0010,\u001a\u00020\u0012\u00a2\u0006\u0004\b,\u0010\u0014J\r\u0010-\u001a\u00020\u0006\u00a2\u0006\u0004\b-\u0010.J\r\u0010/\u001a\u00020\u0006\u00a2\u0006\u0004\b/\u0010.J\r\u00100\u001a\u00020\u0012\u00a2\u0006\u0004\b0\u0010\u0014J\u0015\u00102\u001a\u00020\u00122\u0006\u00101\u001a\u00020\r\u00a2\u0006\u0004\b2\u00103J\u0015\u00104\u001a\u00020\u00122\u0006\u00101\u001a\u00020\r\u00a2\u0006\u0004\b4\u00103J\u000f\u00105\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b5\u00106J\u000f\u00107\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b7\u0010\u001aJ\r\u00108\u001a\u00020\u0002\u00a2\u0006\u0004\b8\u00109J\r\u0010:\u001a\u00020\u0002\u00a2\u0006\u0004\b:\u00109J\r\u0010;\u001a\u00020\u0002\u00a2\u0006\u0004\b;\u00109J\u0015\u0010=\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u0002\u00a2\u0006\u0004\b=\u0010>J\u0015\u0010@\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u0002\u00a2\u0006\u0004\b@\u0010>J\u0017\u0010B\u001a\u0004\u0018\u00010\t2\u0006\u0010A\u001a\u00020\u0002\u00a2\u0006\u0004\bB\u0010CJ\u0015\u0010D\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\t\u00a2\u0006\u0004\bD\u0010EJ\u0015\u0010F\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\t\u00a2\u0006\u0004\bF\u0010GJ\u0015\u0010H\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\t\u00a2\u0006\u0004\bH\u0010EJ\r\u0010I\u001a\u00020\u0002\u00a2\u0006\u0004\bI\u00109J\r\u0010J\u001a\u00020\u0002\u00a2\u0006\u0004\bJ\u00109J\r\u0010K\u001a\u00020\u0002\u00a2\u0006\u0004\bK\u00109J!\u0010M\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\t2\b\b\u0002\u0010L\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\bM\u0010NJ!\u0010O\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\t2\b\b\u0002\u0010L\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\bO\u0010NJ\u0017\u0010R\u001a\u00020\u00062\u0006\u0010Q\u001a\u00020PH\u0016\u00a2\u0006\u0004\bR\u0010SJ\u001f\u0010V\u001a\u00020U2\u0006\u0010Q\u001a\u00020P2\u0006\u0010T\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bV\u0010WJ\u001d\u0010Y\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010X\u001a\u00020\u0006\u00a2\u0006\u0004\bY\u0010ZJ\u001d\u0010\\\u001a\u00020\u00062\u0006\u0010[\u001a\u00020\u00022\u0006\u0010X\u001a\u00020\u0006\u00a2\u0006\u0004\b\\\u0010]J+\u0010a\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010`2\u0006\u0010^\u001a\u00020\u00022\u0006\u0010_\u001a\u00020\u0002\u00a2\u0006\u0004\ba\u0010bR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010cR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010d\u001a\u0004\b\u0007\u0010.R\u0017\u0010Q\u001a\u00020P8\u0006\u00a2\u0006\f\n\u0004\bQ\u0010e\u001a\u0004\bf\u0010gR\u0014\u0010i\u001a\u00020h8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bi\u0010jR\u0016\u0010n\u001a\u0004\u0018\u00010k8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bl\u0010mR \u0010p\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020o8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bp\u0010qR\u001a\u0010r\u001a\b\u0012\u0004\u0012\u00020\t0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\br\u0010sR\u001c\u0010t\u001a\b\u0012\u0004\u0012\u00020\t0&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bt\u0010sR\u0016\u0010u\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bu\u0010vR\u0016\u0010w\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bw\u0010xR\u0016\u0010y\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\by\u0010dR\u0018\u0010z\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bz\u0010{R\u0016\u0010|\u001a\u0004\u0018\u00010\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b|\u0010}R\u0011\u0010\u007f\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b~\u00109R\u0013\u0010\u0081\u0001\u001a\u00020\u00028F\u00a2\u0006\u0007\u001a\u0005\b\u0080\u0001\u00109R\u0019\u0010\u0082\u0001\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0082\u0001\u0010\u0083\u0001R\u001b\u0010\u0084\u0001\u001a\u00020\u00028\u0006\u00a2\u0006\u000f\n\u0006\b\u0084\u0001\u0010\u0083\u0001\u001a\u0005\b\u0085\u0001\u00109R\u001b\u0010\u0086\u0001\u001a\u00020\u00028\u0006\u00a2\u0006\u000f\n\u0006\b\u0086\u0001\u0010\u0083\u0001\u001a\u0005\b\u0087\u0001\u00109R\u001b\u0010\u0088\u0001\u001a\u00020\u00028\u0006\u00a2\u0006\u000f\n\u0006\b\u0088\u0001\u0010\u0083\u0001\u001a\u0005\b\u0089\u0001\u00109R\u001b\u0010\u008a\u0001\u001a\u00020\u00028\u0006\u00a2\u0006\u000f\n\u0006\b\u008a\u0001\u0010\u0083\u0001\u001a\u0005\b\u008b\u0001\u00109R\u0013\u0010\u008d\u0001\u001a\u00020\u00028F\u00a2\u0006\u0007\u001a\u0005\b\u008c\u0001\u00109\u00a8\u0006\u008f\u0001"}, d2={"Ldragomordor/simpletms/ui/MoveCaseMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "", "containerId", "Lnet/minecraft/world/entity/player/Inventory;", "playerInventory", "", "isTR", "", "", "initialStoredMoves", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "serverPokemon", "Ldragomordor/simpletms/ui/PokemonFilterData;", "clientPokemonData", "autoEnableFilter", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;ZLjava/util/Map;Lcom/cobblemon/mod/common/pokemon/Pokemon;Ldragomordor/simpletms/ui/PokemonFilterData;Z)V", "", "loadFilterState", "()V", "saveFilterState", "query", "setSearchQuery", "(Ljava/lang/String;)V", "getSearchQuery", "()Ljava/lang/String;", "updateFilteredMoves", "moveName", "matchesSearch", "(Ljava/lang/String;Ljava/lang/String;)Z", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "moveTemplate", "tagQuery", "matchesTag", "(Lcom/cobblemon/mod/common/api/moves/MoveTemplate;Ljava/lang/String;)Z", "getDisplayNameForMove", "(Ljava/lang/String;)Ljava/lang/String;", "", "getFilteredMoves", "()Ljava/util/List;", "Ldragomordor/simpletms/ui/FilterMode;", "getFilterMode", "()Ldragomordor/simpletms/ui/FilterMode;", "cycleFilterMode", "hasPokemonFilter", "()Z", "isPokemonFilterEnabled", "togglePokemonFilter", "data", "setPokemonFilter", "(Ldragomordor/simpletms/ui/PokemonFilterData;)V", "updatePokemonFilterData", "getPokemonFilterData", "()Ldragomordor/simpletms/ui/PokemonFilterData;", "getPokemonDisplayName", "getPokemonLearnableCount", "()I", "getScrollRow", "getMaxScrollRow", "row", "setScrollRow", "(I)V", "delta", "scroll", "visibleSlotIndex", "getMoveNameForVisibleSlot", "(I)Ljava/lang/String;", "isMoveStored", "(Ljava/lang/String;)Z", "getMoveQuantity", "(Ljava/lang/String;)I", "canAddMore", "getStoredCount", "getTotalCount", "getTotalItemsStored", "amount", "addToStorage", "(Ljava/lang/String;I)I", "removeFromStorage", "Lnet/minecraft/world/entity/player/Player;", "player", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "slotIndex", "Lnet/minecraft/world/item/ItemStack;", "quickMoveStack", "(Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/item/ItemStack;", "isShiftClick", "handleCaseSlotClickByName", "(Ljava/lang/String;Z)Z", "visibleIndex", "handleCaseSlotClick", "(IZ)Z", "relativeX", "relativeY", "Lkotlin/Pair;", "getCaseSlotAt", "(II)Lkotlin/Pair;", "Lnet/minecraft/world/entity/player/Inventory;", "Z", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "Ljava/util/UUID;", "playerUUID", "Ljava/util/UUID;", "Ldragomordor/simpletms/api/MoveCaseStorage;", "getStorage", "()Ldragomordor/simpletms/api/MoveCaseStorage;", "storage", "", "clientStoredMoves", "Ljava/util/Map;", "allMoves", "Ljava/util/List;", "filteredMoves", "searchQuery", "Ljava/lang/String;", "filterMode", "Ldragomordor/simpletms/ui/FilterMode;", "pokemonFilterEnabled", "pokemonFilterData", "Ldragomordor/simpletms/ui/PokemonFilterData;", "serverPokemonRef", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getTotalMoveSlots", "totalMoveSlots", "getTotalRows", "totalRows", "scrollRow", "I", "playerInvStart", "getPlayerInvStart", "playerInvEnd", "getPlayerInvEnd", "hotbarStart", "getHotbarStart", "hotbarEnd", "getHotbarEnd", "getMaxStackSize", "maxStackSize", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nMoveCaseMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveCaseMenu.kt\ndragomordor/simpletms/ui/MoveCaseMenu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,508:1\n774#2:509\n865#2,2:510\n774#2:512\n865#2,2:513\n774#2:515\n865#2,2:516\n774#2:518\n865#2,2:519\n774#2:521\n865#2,2:522\n1869#2,2:524\n1740#2,3:526\n1740#2,3:529\n1788#2,4:533\n1#3:532\n*S KotlinDebug\n*F\n+ 1 MoveCaseMenu.kt\ndragomordor/simpletms/ui/MoveCaseMenu\n*L\n193#1:509\n193#1:510,2\n199#1:512\n199#1:513,2\n200#1:515\n200#1:516,2\n206#1:518\n206#1:519,2\n221#1:521\n221#1:522,2\n221#1:524,2\n235#1:526,3\n242#1:529,3\n360#1:533,4\n*E\n"})
public final class MoveCaseMenu
extends AbstractContainerMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Inventory playerInventory;
    private final boolean isTR;
    @NotNull
    private final Player player;
    @NotNull
    private final UUID playerUUID;
    @NotNull
    private final Map<String, Integer> clientStoredMoves;
    @NotNull
    private final List<String> allMoves;
    @NotNull
    private List<String> filteredMoves;
    @NotNull
    private String searchQuery;
    @NotNull
    private FilterMode filterMode;
    private boolean pokemonFilterEnabled;
    @Nullable
    private PokemonFilterData pokemonFilterData;
    @Nullable
    private final Pokemon serverPokemonRef;
    private int scrollRow;
    private final int playerInvStart;
    private final int playerInvEnd;
    private final int hotbarStart;
    private final int hotbarEnd;
    public static final int COLUMNS = 9;
    public static final int VISIBLE_ROWS = 6;
    public static final int SLOT_SIZE = 18;
    public static final int CASE_SLOTS_X = 8;
    public static final int CASE_SLOTS_Y = 18;
    public static final int PLAYER_INV_X = 8;
    public static final int PLAYER_INV_Y = 140;
    public static final int PLAYER_HOTBAR_Y = 198;

    public MoveCaseMenu(int containerId, @NotNull Inventory playerInventory, boolean isTR, @NotNull Map<String, Integer> initialStoredMoves, @Nullable Pokemon serverPokemon, @Nullable PokemonFilterData clientPokemonData, boolean autoEnableFilter) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter(initialStoredMoves, (String)"initialStoredMoves");
        super((MenuType)SimpleTMsMenuTypes.INSTANCE.getMOVE_CASE_MENU().get(), containerId);
        this.playerInventory = playerInventory;
        this.isTR = isTR;
        Player player = this.playerInventory.player;
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        this.player = player;
        UUID uUID = this.player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.playerUUID = uUID;
        this.clientStoredMoves = MapsKt.toMutableMap(initialStoredMoves);
        this.allMoves = MoveCaseHelper.INSTANCE.getSortedMoveNames(this.isTR);
        this.filteredMoves = this.allMoves;
        this.searchQuery = "";
        this.filterMode = FilterMode.ALL;
        this.serverPokemonRef = serverPokemon;
        this.playerInvStart = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = 140 + row * 18;
                this.addSlot(new Slot((Container)this.playerInventory, col + row * 9 + 9, x, y));
            }
        }
        this.hotbarStart = this.playerInvEnd = this.playerInvStart + 27;
        for (int col = 0; col < 9; ++col) {
            int x = 8 + col * 18;
            this.addSlot(new Slot((Container)this.playerInventory, col, x, 198));
        }
        this.hotbarEnd = this.hotbarStart + 9;
        if (this.player.level().isClientSide) {
            this.loadFilterState();
        }
        if (serverPokemon != null) {
            String string = serverPokemon.getSpecies().getResourceIdentifier().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = serverPokemon.getForm().getName();
            String string3 = serverPokemon.getSpecies().getTranslatedName().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            this.pokemonFilterData = new PokemonFilterData(string, string2, string3, MoveCaseItem.Companion.getLearnableMoves(serverPokemon, this.isTR));
            this.pokemonFilterEnabled = true;
            this.saveFilterState();
        } else if (clientPokemonData != null && autoEnableFilter) {
            this.pokemonFilterData = clientPokemonData;
            this.pokemonFilterEnabled = true;
            this.saveFilterState();
        } else if (clientPokemonData != null && this.pokemonFilterData == null) {
            this.pokemonFilterData = clientPokemonData;
            this.saveFilterState();
        }
        this.updateFilteredMoves();
    }

    public /* synthetic */ MoveCaseMenu(int n, Inventory inventory, boolean bl, Map map, Pokemon pokemon, PokemonFilterData pokemonFilterData, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n2 & 0x10) != 0) {
            pokemon = null;
        }
        if ((n2 & 0x20) != 0) {
            pokemonFilterData = null;
        }
        if ((n2 & 0x40) != 0) {
            bl2 = true;
        }
        this(n, inventory, bl, map, pokemon, pokemonFilterData, bl2);
    }

    public final boolean isTR() {
        return this.isTR;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    private final MoveCaseStorage getStorage() {
        return this.player instanceof ServerPlayer ? MoveCaseStorage.Companion.get((ServerPlayer)this.player) : null;
    }

    public final int getTotalMoveSlots() {
        return this.filteredMoves.size();
    }

    public final int getTotalRows() {
        return (this.getTotalMoveSlots() + 9 - 1) / 9;
    }

    public final int getPlayerInvStart() {
        return this.playerInvStart;
    }

    public final int getPlayerInvEnd() {
        return this.playerInvEnd;
    }

    public final int getHotbarStart() {
        return this.hotbarStart;
    }

    public final int getHotbarEnd() {
        return this.hotbarEnd;
    }

    public final int getMaxStackSize() {
        return this.isTR ? SimpleTMs.INSTANCE.getConfig().getTrStackSize() : 1;
    }

    private final void loadFilterState() {
        this.filterMode = ClientFilterStorage.INSTANCE.getCaseFilterMode(this.isTR);
        this.searchQuery = ClientFilterStorage.INSTANCE.getCaseSearchQuery(this.isTR);
        this.pokemonFilterData = ClientFilterStorage.INSTANCE.getCasePokemonFilter(this.isTR);
        this.pokemonFilterEnabled = ClientFilterStorage.INSTANCE.isCasePokemonFilterEnabled(this.isTR);
    }

    private final void saveFilterState() {
        if (this.player.level().isClientSide) {
            ClientFilterStorage.INSTANCE.setCaseFilterMode(this.isTR, this.filterMode);
            ClientFilterStorage.INSTANCE.setCaseSearchQuery(this.isTR, this.searchQuery);
            ClientFilterStorage.INSTANCE.setCasePokemonFilter(this.isTR, this.pokemonFilterData);
            ClientFilterStorage.INSTANCE.setCasePokemonFilterEnabled(this.isTR, this.pokemonFilterEnabled);
        }
    }

    public final void setSearchQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        String string = query.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String normalizedQuery = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (Intrinsics.areEqual((Object)normalizedQuery, (Object)this.searchQuery)) {
            return;
        }
        this.searchQuery = normalizedQuery;
        this.updateFilteredMoves();
        this.scrollRow = 0;
        this.saveFilterState();
    }

    @NotNull
    public final String getSearchQuery() {
        return this.searchQuery;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateFilteredMoves() {
        List result = this.allMoves;
        if (((CharSequence)this.searchQuery).length() > 0) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = result;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!this.matchesSearch(it, this.searchQuery)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            result = (List)destination$iv$iv;
        }
        result = switch (WhenMappings.$EnumSwitchMapping$0[this.filterMode.ordinal()]) {
            case 1 -> result;
            case 2 -> {
                String it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = result;
                boolean $i$f$filter = false;
                Iterable $i$f$filterTo = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean $i$a$-filter-MoveCaseMenu$updateFilteredMoves$2 = false;
                    if (!(this.getMoveQuantity(it) > 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 3 -> {
                String it;
                Iterable $this$filter$iv = result;
                boolean $i$f$filter2 = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean $i$a$-filter-MoveCaseMenu$updateFilteredMoves$3 = false;
                    if (!(this.getMoveQuantity(it) == 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        PokemonFilterData currentPokemonFilter = this.pokemonFilterData;
        if (this.pokemonFilterEnabled && currentPokemonFilter != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = result;
            boolean $i$f$filter = false;
            Iterable $i$f$filter2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!currentPokemonFilter.getLearnableMoves().contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            result = (List)destination$iv$iv;
        }
        this.filteredMoves = result;
        if (this.scrollRow > this.getMaxScrollRow()) {
            this.scrollRow = this.getMaxScrollRow();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean matchesSearch(String moveName, String query) {
        boolean bl;
        block15: {
            boolean nameMatch;
            MoveTemplate moveTemplate;
            List tagQueries;
            block14: {
                void $this$forEach$iv;
                Iterator $this$filterTo$iv$iv;
                tagQueries = new ArrayList();
                List nameQueries = new ArrayList();
                String[] stringArray = new String[]{" "};
                Iterable $this$filter$iv = StringsKt.split$default((CharSequence)query, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv = iterator.next();
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    boolean bl3 = ((CharSequence)it).length() > 0;
                    if (!bl3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    boolean bl4;
                    String part = (String)element$iv;
                    boolean bl5 = false;
                    if (StringsKt.startsWith$default((String)part, (String)"#", (boolean)false, (int)2, null) && part.length() > 1) {
                        String string = part.substring(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String string2 = string.toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        bl4 = tagQueries.add(string2);
                        continue;
                    }
                    String string = part.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    bl4 = nameQueries.add(string);
                }
                moveTemplate = Moves.getByName((String)moveName);
                if (nameQueries.isEmpty()) {
                    v5 = true;
                } else {
                    String string = moveName.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    String internalName = string;
                    String string3 = this.getDisplayNameForMove(moveName).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    String displayName = string3;
                    Iterable $this$all$iv = nameQueries;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl6 = false;
                            if (StringsKt.contains$default((CharSequence)internalName, (CharSequence)it, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)displayName, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            v5 = false;
                            break block14;
                        }
                        v5 = nameMatch = true;
                    }
                }
            }
            if (!nameMatch) {
                return false;
            }
            if (tagQueries.isEmpty()) {
                return true;
            }
            if (moveTemplate == null) {
                return false;
            }
            Iterable $this$all$iv = tagQueries;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl7 = false;
                    if (this.matchesTag(moveTemplate, it)) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean matchesTag(MoveTemplate moveTemplate, String tagQuery) {
        String string = moveTemplate.getElementalType().getName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)tagQuery, (boolean)false, (int)2, null)) {
            return true;
        }
        String string2 = moveTemplate.getDamageCategory().getName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)tagQuery, (boolean)false, (int)2, null);
    }

    private final String getDisplayNameForMove(String moveName) {
        String string;
        String prefix = this.isTR ? "tr_" : "tm_";
        ItemStack itemStack = SimpleTMsItems.INSTANCE.getItemStackFromName(prefix + moveName);
        if (!itemStack.isEmpty()) {
            String string2 = itemStack.getHoverName().getString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        } else {
            string = moveName;
        }
        return string;
    }

    @NotNull
    public final List<String> getFilteredMoves() {
        return this.filteredMoves;
    }

    @NotNull
    public final FilterMode getFilterMode() {
        return this.filterMode;
    }

    public final void cycleFilterMode() {
        this.filterMode = switch (WhenMappings.$EnumSwitchMapping$0[this.filterMode.ordinal()]) {
            case 1 -> FilterMode.OWNED_ONLY;
            case 2 -> FilterMode.MISSING_ONLY;
            case 3 -> FilterMode.ALL;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.updateFilteredMoves();
        this.scrollRow = 0;
        this.saveFilterState();
    }

    public final boolean hasPokemonFilter() {
        return this.pokemonFilterData != null;
    }

    public final boolean isPokemonFilterEnabled() {
        return this.pokemonFilterEnabled;
    }

    public final void togglePokemonFilter() {
        if (this.pokemonFilterData != null) {
            this.pokemonFilterEnabled = !this.pokemonFilterEnabled;
            this.updateFilteredMoves();
            this.scrollRow = 0;
            this.saveFilterState();
        }
    }

    public final void setPokemonFilter(@NotNull PokemonFilterData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.pokemonFilterData = data;
        this.pokemonFilterEnabled = true;
        this.updateFilteredMoves();
        this.scrollRow = 0;
        this.saveFilterState();
    }

    public final void updatePokemonFilterData(@NotNull PokemonFilterData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.pokemonFilterData = data;
        this.updateFilteredMoves();
        this.scrollRow = 0;
        this.saveFilterState();
    }

    @Nullable
    public final PokemonFilterData getPokemonFilterData() {
        return this.pokemonFilterData;
    }

    @Nullable
    public final String getPokemonDisplayName() {
        PokemonFilterData pokemonFilterData = this.pokemonFilterData;
        return pokemonFilterData != null ? pokemonFilterData.getDisplayName() : null;
    }

    public final int getPokemonLearnableCount() {
        Object object = this.pokemonFilterData;
        return object != null && (object = ((PokemonFilterData)object).getLearnableMoves()) != null ? object.size() : 0;
    }

    public final int getScrollRow() {
        return this.scrollRow;
    }

    public final int getMaxScrollRow() {
        return Math.max(0, this.getTotalRows() - 6);
    }

    public final void setScrollRow(int row) {
        this.scrollRow = RangesKt.coerceIn((int)row, (int)0, (int)this.getMaxScrollRow());
    }

    public final void scroll(int delta) {
        this.setScrollRow(this.scrollRow + delta);
    }

    @Nullable
    public final String getMoveNameForVisibleSlot(int visibleSlotIndex) {
        int actualIndex = this.scrollRow * 9 + visibleSlotIndex;
        return (0 <= actualIndex ? actualIndex < ((Collection)this.filteredMoves).size() : false) ? this.filteredMoves.get(actualIndex) : null;
    }

    public final boolean isMoveStored(@NotNull String moveName) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        return this.getMoveQuantity(moveName) > 0;
    }

    public final int getMoveQuantity(@NotNull String moveName) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        MoveCaseStorage moveCaseStorage = this.getStorage();
        if (moveCaseStorage != null) {
            MoveCaseStorage it = moveCaseStorage;
            boolean bl = false;
            return it.getMoveQuantity(this.playerUUID, moveName, this.isTR);
        }
        Integer n = this.clientStoredMoves.get(moveName);
        return n != null ? n : 0;
    }

    public final boolean canAddMore(@NotNull String moveName) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        return this.getMoveQuantity(moveName) < this.getMaxStackSize();
    }

    /*
     * WARNING - void declaration
     */
    public final int getStoredCount() {
        int n;
        Iterable $this$count$iv = this.allMoves;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!this.isMoveStored(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    public final int getTotalCount() {
        return this.allMoves.size();
    }

    /*
     * WARNING - void declaration
     */
    public final int getTotalItemsStored() {
        Iterable iterable = this.allMoves;
        int n = 0;
        for (Object t : iterable) {
            void it;
            String string = (String)t;
            int n2 = n;
            boolean bl = false;
            int n3 = this.getMoveQuantity((String)it);
            n = n2 + n3;
        }
        return n;
    }

    private final int addToStorage(String moveName, int amount) {
        int currentQty = this.getMoveQuantity(moveName);
        int canAdd = RangesKt.coerceAtLeast((int)(this.getMaxStackSize() - currentQty), (int)0);
        int toAdd = RangesKt.coerceAtMost((int)amount, (int)canAdd);
        if (toAdd > 0) {
            if (this.player instanceof ServerPlayer) {
                MoveCaseStorage moveCaseStorage = this.getStorage();
                if (moveCaseStorage != null) {
                    moveCaseStorage.addMove(this.playerUUID, moveName, this.isTR, toAdd);
                }
            }
            this.clientStoredMoves.put(moveName, currentQty + toAdd);
            if (this.filterMode != FilterMode.ALL) {
                this.updateFilteredMoves();
            }
        }
        return toAdd;
    }

    static /* synthetic */ int addToStorage$default(MoveCaseMenu moveCaseMenu, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return moveCaseMenu.addToStorage(string, n);
    }

    private final int removeFromStorage(String moveName, int amount) {
        int currentQty = this.getMoveQuantity(moveName);
        int toRemove = RangesKt.coerceAtMost((int)amount, (int)currentQty);
        if (toRemove > 0) {
            int newQty;
            if (this.player instanceof ServerPlayer) {
                MoveCaseStorage moveCaseStorage = this.getStorage();
                if (moveCaseStorage != null) {
                    moveCaseStorage.removeMove(this.playerUUID, moveName, this.isTR, toRemove);
                }
            }
            if ((newQty = currentQty - toRemove) <= 0) {
                this.clientStoredMoves.remove(moveName);
            } else {
                this.clientStoredMoves.put(moveName, newQty);
            }
            if (this.filterMode != FilterMode.ALL) {
                this.updateFilteredMoves();
            }
        }
        return toRemove;
    }

    static /* synthetic */ int removeFromStorage$default(MoveCaseMenu moveCaseMenu, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return moveCaseMenu.removeFromStorage(string, n);
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotIndex) {
        ItemStack itemStack;
        int added;
        String moveName;
        int moveIndex;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        NonNullList nonNullList = this.slots;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"slots");
        Slot slot = (Slot)CollectionsKt.getOrNull((List)((List)nonNullList), (int)slotIndex);
        if (slot == null) {
            ItemStack itemStack2 = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
            return itemStack2;
        }
        Slot slot2 = slot;
        if (!slot2.hasItem()) {
            ItemStack itemStack3 = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"EMPTY");
            return itemStack3;
        }
        ItemStack stack = slot2.getItem();
        ItemStack stackCopy = stack.copy();
        Item item = stack.getItem();
        if (item instanceof MoveLearnItem && ((MoveLearnItem)item).isTR$common() == this.isTR && (moveIndex = MoveCaseHelper.INSTANCE.getSlotIndexForMove(moveName = ((MoveLearnItem)item).getMoveName$common(), this.isTR)) >= 0 && this.canAddMore(moveName) && (added = this.addToStorage(moveName, stack.getCount())) > 0) {
            ItemStack itemStack4;
            stack.shrink(added);
            slot2.setChanged();
            ItemStack it = itemStack4 = stackCopy.copy();
            boolean bl = false;
            it.setCount(added);
            ItemStack itemStack5 = itemStack4;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack5, (String)"also(...)");
            return itemStack5;
        }
        int n = this.playerInvStart;
        boolean bl = slotIndex < this.playerInvEnd ? n <= slotIndex : false;
        if (bl) {
            if (!this.moveItemStackTo(stack, this.hotbarStart, this.hotbarEnd, false)) {
                ItemStack itemStack6 = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack6, (String)"EMPTY");
                return itemStack6;
            }
        } else {
            n = this.hotbarStart;
            boolean bl2 = slotIndex < this.hotbarEnd ? n <= slotIndex : false;
            if (bl2 && !this.moveItemStackTo(stack, this.playerInvStart, this.playerInvEnd, false)) {
                ItemStack itemStack7 = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack7, (String)"EMPTY");
                return itemStack7;
            }
        }
        if (stack.isEmpty()) {
            slot2.setByPlayer(ItemStack.EMPTY);
        } else {
            slot2.setChanged();
        }
        if (stack.getCount() == stackCopy.getCount()) {
            ItemStack itemStack8 = ItemStack.EMPTY;
            itemStack = itemStack8;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack8, (String)"EMPTY");
        } else {
            Intrinsics.checkNotNull((Object)stackCopy);
            itemStack = stackCopy;
        }
        return itemStack;
    }

    public final boolean handleCaseSlotClickByName(@NotNull String moveName, boolean isShiftClick) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        if (!this.allMoves.contains(moveName)) {
            return false;
        }
        int storedQty = this.getMoveQuantity(moveName);
        ItemStack carriedItem = this.getCarried();
        if (isShiftClick) {
            if (storedQty > 0) {
                String prefix = this.isTR ? "tr_" : "tm_";
                ItemStack itemToGive = SimpleTMsItems.INSTANCE.getItemStackFromName(prefix + moveName);
                itemToGive.setCount(storedQty);
                int originalCount = itemToGive.getCount();
                if (this.moveItemStackTo(itemToGive, this.playerInvStart, this.hotbarEnd, true)) {
                    int moreAdded;
                    int added = originalCount - itemToGive.getCount();
                    if (added > 0) {
                        this.removeFromStorage(moveName, added);
                    }
                    if (!itemToGive.isEmpty() && this.moveItemStackTo(itemToGive, this.playerInvStart, this.hotbarEnd, false) && (moreAdded = storedQty - added - itemToGive.getCount()) > 0) {
                        this.removeFromStorage(moveName, moreAdded);
                    }
                    return true;
                }
            }
        } else if (carriedItem.isEmpty()) {
            if (storedQty > 0) {
                int pickupAmount = RangesKt.coerceAtMost((int)storedQty, (int)64);
                this.removeFromStorage(moveName, pickupAmount);
                String prefix = this.isTR ? "tr_" : "tm_";
                ItemStack pickedUp = SimpleTMsItems.INSTANCE.getItemStackFromName(prefix + moveName);
                pickedUp.setCount(pickupAmount);
                this.setCarried(pickedUp);
                return true;
            }
        } else {
            int added;
            Item item = carriedItem.getItem();
            if (item instanceof MoveLearnItem && Intrinsics.areEqual((Object)((MoveLearnItem)item).getMoveName$common(), (Object)moveName) && ((MoveLearnItem)item).isTR$common() == this.isTR && this.canAddMore(moveName) && (added = this.addToStorage(moveName, carriedItem.getCount())) > 0) {
                carriedItem.shrink(added);
                return true;
            }
        }
        return false;
    }

    public final boolean handleCaseSlotClick(int visibleIndex, boolean isShiftClick) {
        String string = this.getMoveNameForVisibleSlot(visibleIndex);
        if (string == null) {
            return false;
        }
        String moveName = string;
        return this.handleCaseSlotClickByName(moveName, isShiftClick);
    }

    @Nullable
    public final Pair<Integer, Integer> getCaseSlotAt(int relativeX, int relativeY) {
        if (relativeX < 0 || relativeY < 0) {
            return null;
        }
        if (relativeX >= 162 || relativeY >= 108) {
            return null;
        }
        int row = relativeY / 18;
        int col = relativeX / 18;
        int moveIndex = (this.scrollRow + row) * 9 + col;
        if (moveIndex >= this.filteredMoves.size()) {
            return null;
        }
        return new Pair((Object)row, (Object)col);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006\u00a8\u0006\u000e"}, d2={"Ldragomordor/simpletms/ui/MoveCaseMenu$Companion;", "", "<init>", "()V", "", "COLUMNS", "I", "VISIBLE_ROWS", "SLOT_SIZE", "CASE_SLOTS_X", "CASE_SLOTS_Y", "PLAYER_INV_X", "PLAYER_INV_Y", "PLAYER_HOTBAR_Y", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilterMode.values().length];
            try {
                nArray[FilterMode.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterMode.OWNED_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterMode.MISSING_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

