/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms.ui;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import dragomordor.simpletms.SimpleTMsItems;
import dragomordor.simpletms.block.entity.TMMachineBlockEntity;
import dragomordor.simpletms.item.custom.MoveLearnItem;
import dragomordor.simpletms.ui.ClientFilterStorage;
import dragomordor.simpletms.ui.MoveTypeFilter;
import dragomordor.simpletms.ui.OwnershipFilter;
import dragomordor.simpletms.ui.PokemonFilterData;
import dragomordor.simpletms.ui.SimpleTMsMenuTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u001c\u0018\u0000 \u0087\u00012\u00020\u0001:\u0004\u0088\u0001\u0087\u0001BC\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u001d\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ!\u0010\u001f\u001a\u00020\u00102\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010\"\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010!\u001a\u00020\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010%\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\t\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020\t\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020\u0010\u00a2\u0006\u0004\b)\u0010\u0012J\r\u0010+\u001a\u00020*\u00a2\u0006\u0004\b+\u0010,J\r\u0010-\u001a\u00020\u0010\u00a2\u0006\u0004\b-\u0010\u0012J\r\u0010/\u001a\u00020.\u00a2\u0006\u0004\b/\u00100J\r\u00101\u001a\u00020\u001a\u00a2\u0006\u0004\b1\u00102J\r\u00103\u001a\u00020\u001a\u00a2\u0006\u0004\b3\u00102J\r\u00104\u001a\u00020\u0010\u00a2\u0006\u0004\b4\u0010\u0012J\u0015\u00106\u001a\u00020\u00102\u0006\u00105\u001a\u00020\f\u00a2\u0006\u0004\b6\u00107J\r\u00108\u001a\u00020\u0010\u00a2\u0006\u0004\b8\u0010\u0012J\u000f\u00109\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b9\u0010(J\r\u0010:\u001a\u00020\u0002\u00a2\u0006\u0004\b:\u0010;J\u000f\u0010<\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b<\u0010=J\r\u0010>\u001a\u00020\u0002\u00a2\u0006\u0004\b>\u0010;J\r\u0010?\u001a\u00020\u0002\u00a2\u0006\u0004\b?\u0010;J\u0015\u0010A\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\u0002\u00a2\u0006\u0004\bA\u0010BJ\u0015\u0010D\u001a\u00020\u00102\u0006\u0010C\u001a\u00020\u0002\u00a2\u0006\u0004\bD\u0010BJ\r\u0010E\u001a\u00020\u0002\u00a2\u0006\u0004\bE\u0010;J\u0013\u0010H\u001a\b\u0012\u0004\u0012\u00020G0F\u00a2\u0006\u0004\bH\u0010IJ\u001f\u0010J\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0002\u00a2\u0006\u0004\bJ\u0010KJ\u0015\u0010L\u001a\b\u0012\u0004\u0012\u00020G0FH\u0002\u00a2\u0006\u0004\bL\u0010IJ\r\u0010M\u001a\u00020\u0010\u00a2\u0006\u0004\bM\u0010\u0012J+\u0010Q\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010P2\u0006\u0010N\u001a\u00020\u00022\u0006\u0010O\u001a\u00020\u0002\u00a2\u0006\u0004\bQ\u0010RJ\u0017\u0010T\u001a\u0004\u0018\u00010\t2\u0006\u0010S\u001a\u00020\u0002\u00a2\u0006\u0004\bT\u0010UJ\u0017\u0010V\u001a\u0004\u0018\u00010G2\u0006\u0010S\u001a\u00020\u0002\u00a2\u0006\u0004\bV\u0010WJ%\u0010Z\u001a\u00020\u001a2\u0006\u0010X\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010Y\u001a\u00020\u001a\u00a2\u0006\u0004\bZ\u0010[J%\u0010\\\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010Y\u001a\u00020\u001a\u00a2\u0006\u0004\b\\\u0010]J\u0017\u0010`\u001a\u00020\u001a2\u0006\u0010_\u001a\u00020^H\u0016\u00a2\u0006\u0004\b`\u0010aJ\u001f\u0010d\u001a\u00020c2\u0006\u0010_\u001a\u00020^2\u0006\u0010b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\bd\u0010eR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010fR\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010g\u001a\u0004\bh\u0010iR\u0017\u0010_\u001a\u00020^8\u0006\u00a2\u0006\f\n\u0004\b_\u0010j\u001a\u0004\bk\u0010lR \u0010n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0m8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bn\u0010oR\u0016\u0010p\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bp\u0010qR\u0016\u0010r\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\br\u0010sR\u0016\u0010t\u001a\u00020.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bt\u0010uR\u0018\u0010v\u001a\u0004\u0018\u00010\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bv\u0010wR\u0016\u00103\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u0010xR\u0016\u0010y\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\by\u0010zR\u001c\u0010{\u001a\b\u0012\u0004\u0012\u00020G0F8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b{\u0010|R\u0016\u0010}\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b}\u0010xR\u001a\u0010~\u001a\b\u0012\u0004\u0012\u00020\t0F8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b~\u0010|R\u0018\u0010\u007f\u001a\u00020\u00028\u0006\u00a2\u0006\r\n\u0004\b\u007f\u0010z\u001a\u0005\b\u0080\u0001\u0010;R\u001a\u0010\u0081\u0001\u001a\u00020\u00028\u0006\u00a2\u0006\u000e\n\u0005\b\u0081\u0001\u0010z\u001a\u0005\b\u0082\u0001\u0010;R\u001a\u0010\u0083\u0001\u001a\u00020\u00028\u0006\u00a2\u0006\u000e\n\u0005\b\u0083\u0001\u0010z\u001a\u0005\b\u0084\u0001\u0010;R\u001a\u0010\u0085\u0001\u001a\u00020\u00028\u0006\u00a2\u0006\u000e\n\u0005\b\u0085\u0001\u0010z\u001a\u0005\b\u0086\u0001\u0010;\u00a8\u0006\u0089\u0001"}, d2={"Ldragomordor/simpletms/ui/TMMachineMenu;", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "", "containerId", "Lnet/minecraft/world/entity/player/Inventory;", "playerInventory", "Ldragomordor/simpletms/block/entity/TMMachineBlockEntity;", "blockEntity", "", "", "Ldragomordor/simpletms/block/entity/TMMachineBlockEntity$StoredMoveData;", "initialStoredMoves", "Ldragomordor/simpletms/ui/PokemonFilterData;", "initialPokemonFilter", "<init>", "(ILnet/minecraft/world/entity/player/Inventory;Ldragomordor/simpletms/block/entity/TMMachineBlockEntity;Ljava/util/Map;Ldragomordor/simpletms/ui/PokemonFilterData;)V", "", "loadFilterState", "()V", "saveFilterState", "moveName", "getMoveData", "(Ljava/lang/String;)Ldragomordor/simpletms/block/entity/TMMachineBlockEntity$StoredMoveData;", "getTMCount", "(Ljava/lang/String;)I", "getTRCount", "", "isTR", "hasMove", "(Ljava/lang/String;Z)Z", "moves", "updateClientCache", "(Ljava/util/Map;)V", "amount", "updateClientCacheForWithdrawal", "(Ljava/lang/String;ZI)V", "query", "setSearchQuery", "(Ljava/lang/String;)V", "getSearchQuery", "()Ljava/lang/String;", "cycleTypeFilter", "Ldragomordor/simpletms/ui/MoveTypeFilter;", "getTypeFilter", "()Ldragomordor/simpletms/ui/MoveTypeFilter;", "cycleOwnershipFilter", "Ldragomordor/simpletms/ui/OwnershipFilter;", "getOwnershipFilter", "()Ldragomordor/simpletms/ui/OwnershipFilter;", "hasPokemonFilter", "()Z", "isPokemonFilterEnabled", "togglePokemonFilter", "data", "setPokemonFilter", "(Ldragomordor/simpletms/ui/PokemonFilterData;)V", "clearPokemonFilter", "getPokemonDisplayName", "getPokemonLearnableCount", "()I", "getPokemonFilterData", "()Ldragomordor/simpletms/ui/PokemonFilterData;", "getScrollRow", "getMaxScrollRow", "row", "setScrollRow", "(I)V", "delta", "scroll", "getEffectiveColumns", "", "Ldragomordor/simpletms/ui/TMMachineMenu$FilteredMoveEntry;", "getFilteredMoves", "()Ljava/util/List;", "matchesSearch", "(Ljava/lang/String;Ljava/lang/String;)Z", "rebuildFilteredMoves", "markDirty", "relX", "relY", "Lkotlin/Pair;", "getCaseSlotAt", "(II)Lkotlin/Pair;", "visibleIndex", "getMoveNameForVisibleSlot", "(I)Ljava/lang/String;", "getEntryForVisibleSlot", "(I)Ldragomordor/simpletms/ui/TMMachineMenu$FilteredMoveEntry;", "index", "isShiftClick", "handleSlotClick", "(IZZ)Z", "handleSlotClickByName", "(Ljava/lang/String;ZZ)Z", "Lnet/minecraft/world/entity/player/Player;", "player", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "slotIndex", "Lnet/minecraft/world/item/ItemStack;", "quickMoveStack", "(Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/entity/player/Inventory;", "Ldragomordor/simpletms/block/entity/TMMachineBlockEntity;", "getBlockEntity", "()Ldragomordor/simpletms/block/entity/TMMachineBlockEntity;", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "", "clientStoredMoves", "Ljava/util/Map;", "searchQuery", "Ljava/lang/String;", "typeFilter", "Ldragomordor/simpletms/ui/MoveTypeFilter;", "ownershipFilter", "Ldragomordor/simpletms/ui/OwnershipFilter;", "pokemonFilterData", "Ldragomordor/simpletms/ui/PokemonFilterData;", "Z", "scrollRow", "I", "filteredMoves", "Ljava/util/List;", "isDirty", "allMoves", "playerInvStart", "getPlayerInvStart", "playerInvEnd", "getPlayerInvEnd", "hotbarStart", "getHotbarStart", "hotbarEnd", "getHotbarEnd", "Companion", "FilteredMoveEntry", "common"})
@SourceDebugExtension(value={"SMAP\nTMMachineMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TMMachineMenu.kt\ndragomordor/simpletms/ui/TMMachineMenu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,677:1\n774#2:678\n865#2,2:679\n1563#2:681\n1634#2,3:682\n774#2:685\n865#2,2:686\n1869#2,2:688\n1617#2,9:690\n1869#2:699\n1870#2:701\n1626#2:702\n1#3:700\n382#4,7:703\n*S KotlinDebug\n*F\n+ 1 TMMachineMenu.kt\ndragomordor/simpletms/ui/TMMachineMenu\n*L\n72#1:678\n72#1:679,2\n77#1:681\n77#1:682,3\n372#1:685\n372#1:686,2\n372#1:688,2\n403#1:690,9\n403#1:699\n403#1:701\n403#1:702\n403#1:700\n653#1:703,7\n*E\n"})
public final class TMMachineMenu
extends AbstractContainerMenu {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Inventory playerInventory;
    @Nullable
    private final TMMachineBlockEntity blockEntity;
    @NotNull
    private final Player player;
    @NotNull
    private final Map<String, TMMachineBlockEntity.StoredMoveData> clientStoredMoves;
    @NotNull
    private String searchQuery;
    @NotNull
    private MoveTypeFilter typeFilter;
    @NotNull
    private OwnershipFilter ownershipFilter;
    @Nullable
    private PokemonFilterData pokemonFilterData;
    private boolean isPokemonFilterEnabled;
    private int scrollRow;
    @NotNull
    private List<FilteredMoveEntry> filteredMoves;
    private boolean isDirty;
    @NotNull
    private final List<String> allMoves;
    private final int playerInvStart;
    private final int playerInvEnd;
    private final int hotbarStart;
    private final int hotbarEnd;
    public static final int COLUMNS = 9;
    public static final int VISIBLE_ROWS = 6;
    public static final int SLOT_SIZE = 18;
    public static final int CASE_SLOTS_X = 8;
    public static final int CASE_SLOTS_Y = 18;
    public static final int PLAYER_INV_X = 8;
    public static final int PLAYER_INV_Y = 140;
    public static final int PLAYER_HOTBAR_Y = 198;

    /*
     * WARNING - void declaration
     */
    public TMMachineMenu(int containerId, @NotNull Inventory playerInventory, @Nullable TMMachineBlockEntity blockEntity, @NotNull Map<String, TMMachineBlockEntity.StoredMoveData> initialStoredMoves, @Nullable PokemonFilterData initialPokemonFilter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        MoveTemplate move;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter(initialStoredMoves, (String)"initialStoredMoves");
        super((MenuType)SimpleTMsMenuTypes.INSTANCE.getTM_MACHINE_MENU().get(), containerId);
        this.playerInventory = playerInventory;
        this.blockEntity = blockEntity;
        Player player = this.playerInventory.player;
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
        this.player = player;
        this.clientStoredMoves = MapsKt.toMutableMap(initialStoredMoves);
        this.searchQuery = "";
        this.typeFilter = MoveTypeFilter.ALL;
        this.ownershipFilter = OwnershipFilter.ALL;
        this.filteredMoves = CollectionsKt.emptyList();
        this.isDirty = true;
        Iterable iterable = Moves.all();
        TMMachineMenu tMMachineMenu = this;
        boolean $i$f$filter = false;
        void var8_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String moveName;
            move = (MoveTemplate)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)move.getName().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (!(SimpleTMsItems.INSTANCE.getALL_MOVE_NAMES_WITH_TM_ITEMS().contains(moveName) || SimpleTMsItems.INSTANCE.getALL_MOVE_NAMES_WITH_TR_ITEMS().contains(moveName))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            move = (MoveTemplate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        tMMachineMenu.allMoves = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        this.playerInvStart = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = 140 + row * 18;
                this.addSlot(new Slot((Container)this.playerInventory, col + row * 9 + 9, x, y));
            }
        }
        this.hotbarStart = this.playerInvEnd = this.playerInvStart + 27;
        for (int col = 0; col < 9; ++col) {
            int x = 8 + col * 18;
            this.addSlot(new Slot((Container)this.playerInventory, col, x, 198));
        }
        this.hotbarEnd = this.hotbarStart + 9;
        if (this.player.level().isClientSide) {
            this.loadFilterState();
        }
        if (initialPokemonFilter != null) {
            this.pokemonFilterData = initialPokemonFilter;
            this.isPokemonFilterEnabled = true;
            if (this.player.level().isClientSide) {
                this.saveFilterState();
            }
        }
        this.rebuildFilteredMoves();
    }

    public /* synthetic */ TMMachineMenu(int n, Inventory inventory, TMMachineBlockEntity tMMachineBlockEntity, Map map, PokemonFilterData pokemonFilterData, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n2 & 0x10) != 0) {
            pokemonFilterData = null;
        }
        this(n, inventory, tMMachineBlockEntity, map, pokemonFilterData);
    }

    @Nullable
    public final TMMachineBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final int getPlayerInvStart() {
        return this.playerInvStart;
    }

    public final int getPlayerInvEnd() {
        return this.playerInvEnd;
    }

    public final int getHotbarStart() {
        return this.hotbarStart;
    }

    public final int getHotbarEnd() {
        return this.hotbarEnd;
    }

    private final void loadFilterState() {
        this.typeFilter = ClientFilterStorage.INSTANCE.getMachineTypeFilter();
        this.ownershipFilter = ClientFilterStorage.INSTANCE.getMachineOwnershipFilter();
        this.searchQuery = ClientFilterStorage.INSTANCE.getMachineSearchQuery();
        this.pokemonFilterData = ClientFilterStorage.INSTANCE.getMachinePokemonFilter();
        this.isPokemonFilterEnabled = ClientFilterStorage.INSTANCE.isMachinePokemonFilterEnabled();
    }

    private final void saveFilterState() {
        if (this.player.level().isClientSide) {
            ClientFilterStorage.INSTANCE.setMachineTypeFilter(this.typeFilter);
            ClientFilterStorage.INSTANCE.setMachineOwnershipFilter(this.ownershipFilter);
            ClientFilterStorage.INSTANCE.setMachineSearchQuery(this.searchQuery);
            ClientFilterStorage.INSTANCE.setMachinePokemonFilter(this.pokemonFilterData);
            ClientFilterStorage.INSTANCE.setMachinePokemonFilterEnabled(this.isPokemonFilterEnabled);
        }
    }

    private final TMMachineBlockEntity.StoredMoveData getMoveData(String moveName) {
        if (this.player.level().isClientSide) {
            return this.clientStoredMoves.get(moveName);
        }
        TMMachineBlockEntity tMMachineBlockEntity = this.blockEntity;
        if (tMMachineBlockEntity != null) {
            TMMachineBlockEntity it = tMMachineBlockEntity;
            boolean bl = false;
            return it.getStoredQuantities().get(moveName);
        }
        return this.clientStoredMoves.get(moveName);
    }

    public final int getTMCount(@NotNull String moveName) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        TMMachineBlockEntity.StoredMoveData storedMoveData = this.getMoveData(moveName);
        return storedMoveData != null ? storedMoveData.getTmCount() : 0;
    }

    public final int getTRCount(@NotNull String moveName) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        TMMachineBlockEntity.StoredMoveData storedMoveData = this.getMoveData(moveName);
        return storedMoveData != null ? storedMoveData.getTrCount() : 0;
    }

    public final boolean hasMove(@NotNull String moveName, boolean isTR) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        TMMachineBlockEntity.StoredMoveData storedMoveData = this.getMoveData(moveName);
        if (storedMoveData == null) {
            return false;
        }
        TMMachineBlockEntity.StoredMoveData data = storedMoveData;
        return isTR ? data.getTrCount() > 0 : data.getTmCount() > 0;
    }

    public final void updateClientCache(@NotNull Map<String, TMMachineBlockEntity.StoredMoveData> moves) {
        Intrinsics.checkNotNullParameter(moves, (String)"moves");
        this.clientStoredMoves.clear();
        this.clientStoredMoves.putAll(moves);
        this.isDirty = true;
    }

    public final void updateClientCacheForWithdrawal(@NotNull String moveName, boolean isTR, int amount) {
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        TMMachineBlockEntity.StoredMoveData storedMoveData = this.clientStoredMoves.get(moveName);
        if (storedMoveData == null) {
            return;
        }
        TMMachineBlockEntity.StoredMoveData data = storedMoveData;
        if (isTR) {
            data.setTrCount(RangesKt.coerceAtLeast((int)(data.getTrCount() - amount), (int)0));
        } else {
            data.setTmCount(RangesKt.coerceAtLeast((int)(data.getTmCount() - amount), (int)0));
        }
        if (data.isEmpty()) {
            this.clientStoredMoves.remove(moveName);
        }
        this.isDirty = true;
    }

    public static /* synthetic */ void updateClientCacheForWithdrawal$default(TMMachineMenu tMMachineMenu, String string, boolean bl, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 1;
        }
        tMMachineMenu.updateClientCacheForWithdrawal(string, bl, n);
    }

    public final void setSearchQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        String string = query.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String normalizedQuery = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (Intrinsics.areEqual((Object)normalizedQuery, (Object)this.searchQuery)) {
            return;
        }
        this.searchQuery = normalizedQuery;
        this.isDirty = true;
        this.scrollRow = 0;
        this.saveFilterState();
    }

    @NotNull
    public final String getSearchQuery() {
        return this.searchQuery;
    }

    public final void cycleTypeFilter() {
        this.typeFilter = switch (WhenMappings.$EnumSwitchMapping$0[this.typeFilter.ordinal()]) {
            case 1 -> MoveTypeFilter.TM_ONLY;
            case 2 -> MoveTypeFilter.TR_ONLY;
            case 3 -> MoveTypeFilter.ALL;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.isDirty = true;
        this.scrollRow = 0;
        this.saveFilterState();
    }

    @NotNull
    public final MoveTypeFilter getTypeFilter() {
        return this.typeFilter;
    }

    public final void cycleOwnershipFilter() {
        this.ownershipFilter = switch (WhenMappings.$EnumSwitchMapping$1[this.ownershipFilter.ordinal()]) {
            case 1 -> OwnershipFilter.OWNED_ONLY;
            case 2 -> OwnershipFilter.MISSING_ONLY;
            case 3 -> OwnershipFilter.ALL;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.isDirty = true;
        this.scrollRow = 0;
        this.saveFilterState();
    }

    @NotNull
    public final OwnershipFilter getOwnershipFilter() {
        return this.ownershipFilter;
    }

    public final boolean hasPokemonFilter() {
        return this.pokemonFilterData != null;
    }

    public final boolean isPokemonFilterEnabled() {
        return this.isPokemonFilterEnabled && this.pokemonFilterData != null;
    }

    public final void togglePokemonFilter() {
        if (this.pokemonFilterData != null) {
            this.isPokemonFilterEnabled = !this.isPokemonFilterEnabled;
            this.isDirty = true;
            this.scrollRow = 0;
            this.saveFilterState();
        }
    }

    public final void setPokemonFilter(@NotNull PokemonFilterData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.pokemonFilterData = data;
        this.isPokemonFilterEnabled = true;
        this.isDirty = true;
        this.scrollRow = 0;
        this.saveFilterState();
    }

    public final void clearPokemonFilter() {
        this.pokemonFilterData = null;
        this.isPokemonFilterEnabled = false;
        this.isDirty = true;
        this.scrollRow = 0;
        this.saveFilterState();
    }

    @Nullable
    public final String getPokemonDisplayName() {
        PokemonFilterData pokemonFilterData = this.pokemonFilterData;
        return pokemonFilterData != null ? pokemonFilterData.getDisplayName() : null;
    }

    public final int getPokemonLearnableCount() {
        Object object = this.pokemonFilterData;
        return object != null && (object = ((PokemonFilterData)object).getLearnableMoves()) != null ? object.size() : 0;
    }

    @Nullable
    public final PokemonFilterData getPokemonFilterData() {
        return this.pokemonFilterData;
    }

    public final int getScrollRow() {
        return this.scrollRow;
    }

    public final int getMaxScrollRow() {
        List<FilteredMoveEntry> filtered = this.getFilteredMoves();
        int effectiveColumns = this.getEffectiveColumns();
        int totalRows = (filtered.size() + effectiveColumns - 1) / effectiveColumns;
        return Math.max(0, totalRows - 6);
    }

    public final void setScrollRow(int row) {
        this.scrollRow = RangesKt.coerceIn((int)row, (int)0, (int)this.getMaxScrollRow());
    }

    public final void scroll(int delta) {
        this.setScrollRow(this.scrollRow + delta);
    }

    public final int getEffectiveColumns() {
        return this.typeFilter == MoveTypeFilter.ALL ? 4 : 9;
    }

    @NotNull
    public final List<FilteredMoveEntry> getFilteredMoves() {
        if (this.isDirty) {
            this.filteredMoves = this.rebuildFilteredMoves();
            this.isDirty = false;
        }
        return this.filteredMoves;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean matchesSearch(String moveName, String query) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        if (((CharSequence)query).length() == 0) {
            return true;
        }
        List tagQueries = new ArrayList();
        List nameQueries = new ArrayList();
        String[] stringArray = new String[]{" "};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)query, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            String part = (String)element$iv;
            boolean bl3 = false;
            if (StringsKt.startsWith$default((String)part, (String)"#", (boolean)false, (int)2, null) && part.length() > 1) {
                String string = part.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                bl = tagQueries.add(string2);
                continue;
            }
            String string = part.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            bl = nameQueries.add(string);
        }
        String displayName = StringsKt.replace$default((String)moveName, (String)"_", (String)" ", (boolean)false, (int)4, null);
        for (String nameQuery : nameQueries) {
            if (StringsKt.contains$default((CharSequence)displayName, (CharSequence)nameQuery, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)moveName, (CharSequence)nameQuery, (boolean)false, (int)2, null)) continue;
            return false;
        }
        if (!((Collection)tagQueries).isEmpty()) {
            MoveTemplate moveTemplate = Moves.getByName((String)moveName);
            if (moveTemplate == null) {
                return false;
            }
            MoveTemplate move = moveTemplate;
            String string = move.getElementalType().getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String moveType = string;
            for (String tagQuery : tagQueries) {
                if (StringsKt.startsWith$default((String)moveType, (String)tagQuery, (boolean)false, (int)2, null)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FilteredMoveEntry> rebuildFilteredMoves() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.allMoves;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FilteredMoveEntry filteredMoveEntry;
            block30: {
                boolean canLearn;
                boolean isValidTR;
                boolean isValidTM;
                String moveName;
                block31: {
                    block29: {
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        moveName = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (this.matchesSearch(moveName, this.searchQuery)) break block29;
                        filteredMoveEntry = null;
                        break block30;
                    }
                    isValidTM = SimpleTMsItems.INSTANCE.getALL_MOVE_NAMES_WITH_TM_ITEMS().contains(moveName);
                    isValidTR = SimpleTMsItems.INSTANCE.getALL_MOVE_NAMES_WITH_TR_ITEMS().contains(moveName);
                    switch (WhenMappings.$EnumSwitchMapping$0[this.typeFilter.ordinal()]) {
                        case 2: {
                            if (isValidTM) break;
                            filteredMoveEntry = null;
                            break block30;
                        }
                        case 3: {
                            if (isValidTR) break;
                            filteredMoveEntry = null;
                            break block30;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    if (this.isPokemonFilterEnabled && this.pokemonFilterData != null) {
                        PokemonFilterData pokemonFilterData = this.pokemonFilterData;
                        Intrinsics.checkNotNull((Object)pokemonFilterData);
                        v2 = pokemonFilterData.getLearnableMoves().contains(moveName);
                    } else {
                        v2 = canLearn = true;
                    }
                    if (!this.isPokemonFilterEnabled || this.pokemonFilterData == null || canLearn) break block31;
                    filteredMoveEntry = null;
                    break block30;
                }
                int tmCount = this.getTMCount(moveName);
                int trCount = this.getTRCount(moveName);
                switch (WhenMappings.$EnumSwitchMapping$1[this.ownershipFilter.ordinal()]) {
                    case 2: {
                        boolean hasOwned = switch (WhenMappings.$EnumSwitchMapping$0[this.typeFilter.ordinal()]) {
                            case 1 -> {
                                if (tmCount > 0 || trCount > 0) {
                                    yield true;
                                }
                                yield false;
                            }
                            case 2 -> {
                                if (tmCount > 0) {
                                    yield true;
                                }
                                yield false;
                            }
                            case 3 -> {
                                if (trCount > 0) {
                                    yield true;
                                }
                                yield false;
                            }
                            default -> throw new NoWhenBranchMatchedException();
                        };
                        if (hasOwned) break;
                        filteredMoveEntry = null;
                        break block30;
                    }
                    case 3: {
                        boolean isMissing = switch (WhenMappings.$EnumSwitchMapping$0[this.typeFilter.ordinal()]) {
                            case 1 -> {
                                if (tmCount == 0 && trCount == 0) {
                                    yield true;
                                }
                                yield false;
                            }
                            case 2 -> {
                                if (tmCount == 0) {
                                    yield true;
                                }
                                yield false;
                            }
                            case 3 -> {
                                if (trCount == 0) {
                                    yield true;
                                }
                                yield false;
                            }
                            default -> throw new NoWhenBranchMatchedException();
                        };
                        if (isMissing) break;
                        filteredMoveEntry = null;
                        break block30;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                filteredMoveEntry = new FilteredMoveEntry(moveName, tmCount, trCount, isValidTM, isValidTR, canLearn);
            }
            if (filteredMoveEntry == null) continue;
            FilteredMoveEntry it$iv$iv = filteredMoveEntry;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void markDirty() {
        this.isDirty = true;
    }

    @Nullable
    public final Pair<Integer, Integer> getCaseSlotAt(int relX, int relY) {
        if (relX < 0 || relY < 0) {
            return null;
        }
        int col = relX / 18;
        int row = relY / 18;
        if (col >= 9 || row >= 6) {
            return null;
        }
        return TuplesKt.to((Object)row, (Object)col);
    }

    @Nullable
    public final String getMoveNameForVisibleSlot(int visibleIndex) {
        int effectiveColumns = this.getEffectiveColumns();
        int absoluteIndex = this.scrollRow * effectiveColumns + visibleIndex;
        List<FilteredMoveEntry> filtered = this.getFilteredMoves();
        return (0 <= absoluteIndex ? absoluteIndex < ((Collection)filtered).size() : false) ? filtered.get(absoluteIndex).getMoveName() : null;
    }

    @Nullable
    public final FilteredMoveEntry getEntryForVisibleSlot(int visibleIndex) {
        int effectiveColumns = this.getEffectiveColumns();
        int absoluteIndex = this.scrollRow * effectiveColumns + visibleIndex;
        List<FilteredMoveEntry> filtered = this.getFilteredMoves();
        return (0 <= absoluteIndex ? absoluteIndex < ((Collection)filtered).size() : false) ? filtered.get(absoluteIndex) : null;
    }

    public final boolean handleSlotClick(int index, boolean isTR, boolean isShiftClick) {
        boolean hasItem;
        if (!(this.player instanceof ServerPlayer)) {
            return false;
        }
        TMMachineBlockEntity tMMachineBlockEntity = this.blockEntity;
        if (tMMachineBlockEntity == null) {
            return false;
        }
        TMMachineBlockEntity blockEntity = tMMachineBlockEntity;
        List<FilteredMoveEntry> filtered = this.getFilteredMoves();
        if (!(0 <= index ? index < ((Collection)filtered).size() : false)) {
            return false;
        }
        String moveName = filtered.get(index).getMoveName();
        boolean bl = isTR ? this.getTRCount(moveName) > 0 : (hasItem = this.getTMCount(moveName) > 0);
        if (!hasItem) {
            return false;
        }
        String prefix = isTR ? "tr_" : "tm_";
        ItemStack stack = SimpleTMsItems.INSTANCE.getItemStackFromName(prefix + moveName);
        if (stack.isEmpty()) {
            return false;
        }
        if (isShiftClick) {
            if (!((ServerPlayer)this.player).getInventory().add(stack)) {
                this.player.drop(stack, false);
            }
        } else {
            ItemStack currentCarried = this.getCarried();
            if (currentCarried.isEmpty()) {
                this.setCarried(stack);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)currentCarried, (ItemStack)stack) && currentCarried.getCount() < currentCarried.getMaxStackSize()) {
                currentCarried.grow(1);
                this.setCarried(currentCarried);
            } else {
                return false;
            }
        }
        blockEntity.removeMove(moveName, isTR, 1);
        this.isDirty = true;
        return true;
    }

    public final boolean handleSlotClickByName(@NotNull String moveName, boolean isTR, boolean isShiftClick) {
        int currentCount;
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        if (!(this.player instanceof ServerPlayer)) {
            return false;
        }
        TMMachineBlockEntity tMMachineBlockEntity = this.blockEntity;
        if (tMMachineBlockEntity == null) {
            return false;
        }
        TMMachineBlockEntity blockEntity = tMMachineBlockEntity;
        int n = currentCount = isTR ? this.getTRCount(moveName) : this.getTMCount(moveName);
        if (currentCount <= 0) {
            return false;
        }
        String prefix = isTR ? "tr_" : "tm_";
        ItemStack stack = SimpleTMsItems.INSTANCE.getItemStackFromName(prefix + moveName);
        if (stack.isEmpty()) {
            return false;
        }
        if (isShiftClick) {
            int withdrawAmount = RangesKt.coerceAtMost((int)currentCount, (int)stack.getMaxStackSize());
            stack.setCount(withdrawAmount);
            int countBefore = stack.getCount();
            if (!((ServerPlayer)this.player).getInventory().add(stack) && !stack.isEmpty() && stack.getCount() > 0) {
                this.player.drop(stack, false);
            }
            v2 = blockEntity.removeMove(moveName, isTR, withdrawAmount);
        } else {
            ItemStack currentCarried = this.getCarried();
            if (currentCarried.isEmpty()) {
                this.setCarried(stack);
                v2 = blockEntity.removeMove(moveName, isTR, 1);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)currentCarried, (ItemStack)stack) && currentCarried.getCount() < currentCarried.getMaxStackSize()) {
                currentCarried.grow(1);
                this.setCarried(currentCarried);
                v2 = blockEntity.removeMove(moveName, isTR, 1);
            } else {
                return false;
            }
        }
        this.isDirty = true;
        return true;
    }

    public boolean stillValid(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        TMMachineBlockEntity tMMachineBlockEntity = this.blockEntity;
        if (tMMachineBlockEntity != null) {
            TMMachineBlockEntity be = tMMachineBlockEntity;
            boolean bl = false;
            Level level = be.getLevel();
            if (level == null) {
                return false;
            }
            Level level2 = level;
            BlockPos pos = be.getBlockPos();
            return player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slotIndex) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        NonNullList nonNullList = this.slots;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"slots");
        Slot slot = (Slot)CollectionsKt.getOrNull((List)((List)nonNullList), (int)slotIndex);
        if (slot == null) {
            ItemStack itemStack2 = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
            return itemStack2;
        }
        Slot slot2 = slot;
        if (!slot2.hasItem()) {
            ItemStack itemStack3 = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"EMPTY");
            return itemStack3;
        }
        ItemStack stack = slot2.getItem();
        ItemStack originalStack = stack.copy();
        Item item = stack.getItem();
        if (item instanceof MoveLearnItem && this.blockEntity != null) {
            String moveName = ((MoveLearnItem)item).getMoveName$common();
            boolean isTR = ((MoveLearnItem)item).isTR$common();
            TMMachineBlockEntity.StoredMoveData storedMoveData = this.clientStoredMoves.get(moveName);
            if (storedMoveData == null) {
                storedMoveData = new TMMachineBlockEntity.StoredMoveData(0, 0, 3, null);
            }
            TMMachineBlockEntity.StoredMoveData currentData = storedMoveData;
            int currentCount = isTR ? currentData.getTrCount() : currentData.getTmCount();
            int maxCount = isTR ? this.blockEntity.getMaxTRStackSize() : 1;
            int canAdd = RangesKt.coerceAtLeast((int)(maxCount - currentCount), (int)0);
            int toAdd = RangesKt.coerceAtMost((int)stack.getCount(), (int)canAdd);
            if (toAdd > 0) {
                Object object;
                void $this$getOrPut$iv;
                if (!player.level().isClientSide) {
                    ItemStack itemStack4 = stack.copyWithCount(toAdd);
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"copyWithCount(...)");
                    this.blockEntity.tryInsert(itemStack4);
                }
                Map<String, TMMachineBlockEntity.StoredMoveData> map = this.clientStoredMoves;
                String key$iv = moveName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    TMMachineBlockEntity.StoredMoveData answer$iv = new TMMachineBlockEntity.StoredMoveData(0, 0, 3, null);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                TMMachineBlockEntity.StoredMoveData newData = (TMMachineBlockEntity.StoredMoveData)object;
                if (isTR) {
                    newData.setTrCount(newData.getTrCount() + toAdd);
                } else {
                    newData.setTmCount(newData.getTmCount() + toAdd);
                }
                stack.shrink(toAdd);
                slot2.setChanged();
                this.isDirty = true;
                Intrinsics.checkNotNull((Object)originalStack);
                return originalStack;
            }
        }
        int n = this.playerInvStart;
        boolean bl = slotIndex < this.playerInvEnd ? n <= slotIndex : false;
        if (bl) {
            if (!this.moveItemStackTo(stack, this.hotbarStart, this.hotbarEnd, false)) {
                ItemStack itemStack5 = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack5, (String)"EMPTY");
                return itemStack5;
            }
        } else {
            n = this.hotbarStart;
            boolean bl2 = slotIndex < this.hotbarEnd ? n <= slotIndex : false;
            if (bl2 && !this.moveItemStackTo(stack, this.playerInvStart, this.playerInvEnd, false)) {
                ItemStack itemStack6 = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack6, (String)"EMPTY");
                return itemStack6;
            }
        }
        if (stack.isEmpty()) {
            slot2.setByPlayer(ItemStack.EMPTY);
        } else {
            slot2.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            ItemStack itemStack7 = ItemStack.EMPTY;
            itemStack = itemStack7;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack7, (String)"EMPTY");
        } else {
            Intrinsics.checkNotNull((Object)originalStack);
            itemStack = originalStack;
        }
        return itemStack;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006\u00a8\u0006\u000e"}, d2={"Ldragomordor/simpletms/ui/TMMachineMenu$Companion;", "", "<init>", "()V", "", "COLUMNS", "I", "VISIBLE_ROWS", "SLOT_SIZE", "CASE_SLOTS_X", "CASE_SLOTS_Y", "PLAYER_INV_X", "PLAYER_INV_Y", "PLAYER_HOTBAR_Y", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\r\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u000eJ\u0010\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u000eJ\u0010\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u000eJL\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001a\u0010 \u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\"\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010\u0018J\u0010\u0010#\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b#\u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010\u0016R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010&\u001a\u0004\b'\u0010\u0018R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010&\u001a\u0004\b(\u0010\u0018R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010)\u001a\u0004\b\b\u0010\u000eR\u0017\u0010\t\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010)\u001a\u0004\b\t\u0010\u000eR\u0017\u0010\n\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\n\u0010)\u001a\u0004\b*\u0010\u000e\u00a8\u0006+"}, d2={"Ldragomordor/simpletms/ui/TMMachineMenu$FilteredMoveEntry;", "", "", "moveName", "", "tmCount", "trCount", "", "isValidTM", "isValidTR", "canPokemonLearn", "<init>", "(Ljava/lang/String;IIZZZ)V", "hasAny", "()Z", "hasTM", "hasTR", "Ldragomordor/simpletms/ui/MoveTypeFilter;", "typeFilter", "getDisplayCount", "(Ldragomordor/simpletms/ui/MoveTypeFilter;)I", "component1", "()Ljava/lang/String;", "component2", "()I", "component3", "component4", "component5", "component6", "copy", "(Ljava/lang/String;IIZZZ)Ldragomordor/simpletms/ui/TMMachineMenu$FilteredMoveEntry;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getMoveName", "I", "getTmCount", "getTrCount", "Z", "getCanPokemonLearn", "common"})
    public static final class FilteredMoveEntry {
        @NotNull
        private final String moveName;
        private final int tmCount;
        private final int trCount;
        private final boolean isValidTM;
        private final boolean isValidTR;
        private final boolean canPokemonLearn;

        public FilteredMoveEntry(@NotNull String moveName, int tmCount, int trCount, boolean isValidTM, boolean isValidTR, boolean canPokemonLearn) {
            Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
            this.moveName = moveName;
            this.tmCount = tmCount;
            this.trCount = trCount;
            this.isValidTM = isValidTM;
            this.isValidTR = isValidTR;
            this.canPokemonLearn = canPokemonLearn;
        }

        @NotNull
        public final String getMoveName() {
            return this.moveName;
        }

        public final int getTmCount() {
            return this.tmCount;
        }

        public final int getTrCount() {
            return this.trCount;
        }

        public final boolean isValidTM() {
            return this.isValidTM;
        }

        public final boolean isValidTR() {
            return this.isValidTR;
        }

        public final boolean getCanPokemonLearn() {
            return this.canPokemonLearn;
        }

        public final boolean hasAny() {
            return this.tmCount > 0 || this.trCount > 0;
        }

        public final boolean hasTM() {
            return this.tmCount > 0;
        }

        public final boolean hasTR() {
            return this.trCount > 0;
        }

        public final int getDisplayCount(@NotNull MoveTypeFilter typeFilter) {
            Intrinsics.checkNotNullParameter((Object)((Object)typeFilter), (String)"typeFilter");
            return switch (WhenMappings.$EnumSwitchMapping$0[typeFilter.ordinal()]) {
                case 1 -> this.tmCount + this.trCount;
                case 2 -> this.tmCount;
                case 3 -> this.trCount;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public final String component1() {
            return this.moveName;
        }

        public final int component2() {
            return this.tmCount;
        }

        public final int component3() {
            return this.trCount;
        }

        public final boolean component4() {
            return this.isValidTM;
        }

        public final boolean component5() {
            return this.isValidTR;
        }

        public final boolean component6() {
            return this.canPokemonLearn;
        }

        @NotNull
        public final FilteredMoveEntry copy(@NotNull String moveName, int tmCount, int trCount, boolean isValidTM, boolean isValidTR, boolean canPokemonLearn) {
            Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
            return new FilteredMoveEntry(moveName, tmCount, trCount, isValidTM, isValidTR, canPokemonLearn);
        }

        public static /* synthetic */ FilteredMoveEntry copy$default(FilteredMoveEntry filteredMoveEntry, String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = filteredMoveEntry.moveName;
            }
            if ((n3 & 2) != 0) {
                n = filteredMoveEntry.tmCount;
            }
            if ((n3 & 4) != 0) {
                n2 = filteredMoveEntry.trCount;
            }
            if ((n3 & 8) != 0) {
                bl = filteredMoveEntry.isValidTM;
            }
            if ((n3 & 0x10) != 0) {
                bl2 = filteredMoveEntry.isValidTR;
            }
            if ((n3 & 0x20) != 0) {
                bl3 = filteredMoveEntry.canPokemonLearn;
            }
            return filteredMoveEntry.copy(string, n, n2, bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "FilteredMoveEntry(moveName=" + this.moveName + ", tmCount=" + this.tmCount + ", trCount=" + this.trCount + ", isValidTM=" + this.isValidTM + ", isValidTR=" + this.isValidTR + ", canPokemonLearn=" + this.canPokemonLearn + ")";
        }

        public int hashCode() {
            int result = this.moveName.hashCode();
            result = result * 31 + Integer.hashCode(this.tmCount);
            result = result * 31 + Integer.hashCode(this.trCount);
            result = result * 31 + Boolean.hashCode(this.isValidTM);
            result = result * 31 + Boolean.hashCode(this.isValidTR);
            result = result * 31 + Boolean.hashCode(this.canPokemonLearn);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FilteredMoveEntry)) {
                return false;
            }
            FilteredMoveEntry filteredMoveEntry = (FilteredMoveEntry)other;
            if (!Intrinsics.areEqual((Object)this.moveName, (Object)filteredMoveEntry.moveName)) {
                return false;
            }
            if (this.tmCount != filteredMoveEntry.tmCount) {
                return false;
            }
            if (this.trCount != filteredMoveEntry.trCount) {
                return false;
            }
            if (this.isValidTM != filteredMoveEntry.isValidTM) {
                return false;
            }
            if (this.isValidTR != filteredMoveEntry.isValidTR) {
                return false;
            }
            return this.canPokemonLearn == filteredMoveEntry.canPokemonLearn;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MoveTypeFilter.values().length];
                try {
                    nArray[MoveTypeFilter.ALL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MoveTypeFilter.TM_ONLY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MoveTypeFilter.TR_ONLY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MoveTypeFilter.values().length];
            try {
                nArray[MoveTypeFilter.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MoveTypeFilter.TM_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MoveTypeFilter.TR_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OwnershipFilter.values().length];
            try {
                nArray[OwnershipFilter.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OwnershipFilter.OWNED_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OwnershipFilter.MISSING_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

