/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import dragomordor.simpletms.SimpleTMsItems;
import dragomordor.simpletms.network.SimpleTMsNetwork;
import dragomordor.simpletms.ui.MoveTypeFilter;
import dragomordor.simpletms.ui.OwnershipFilter;
import dragomordor.simpletms.ui.PokemonFilterData;
import dragomordor.simpletms.ui.TMMachineMenu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 p2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002pqB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001dJ'\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001dJ\u001f\u0010\"\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020 H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010$\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020 H\u0002\u00a2\u0006\u0004\b$\u0010#J\u001f\u0010%\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020 H\u0002\u00a2\u0006\u0004\b%\u0010#J'\u0010(\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b(\u0010\u001dJ!\u0010,\u001a\u0004\u0018\u00010+2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b,\u0010-J7\u00101\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010/\u001a\u00020.2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u00100\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b1\u00102J+\u00108\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u000f072\u0006\u00104\u001a\u0002032\u0006\u00106\u001a\u000205H\u0002\u00a2\u0006\u0004\b8\u00109J/\u0010:\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010/\u001a\u00020.2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b:\u0010;J7\u0010<\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b<\u0010=J'\u0010>\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b>\u0010\u001dJ'\u0010?\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b?\u0010\u001dJ/\u0010@\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b@\u0010AJ'\u0010B\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\bB\u0010\u001dJ'\u0010F\u001a\u00020!2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\bF\u0010GJ\u001f\u0010J\u001a\u00020!2\u0006\u0010I\u001a\u00020H2\u0006\u0010E\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\bJ\u0010KJ'\u0010M\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010L\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\bM\u0010NJ3\u0010U\u001a\u00020\n2\u0006\u0010P\u001a\u00020O2\u0006\u0010Q\u001a\u00020O2\u0006\u0010R\u001a\u00020O2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020O0S\u00a2\u0006\u0004\bU\u0010VJ/\u0010Y\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010W\u001a\u00020 2\u0006\u0010X\u001a\u00020 H\u0016\u00a2\u0006\u0004\bY\u0010ZJ'\u0010[\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010L\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b[\u0010NJ7\u0010^\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010L\u001a\u00020\u000f2\u0006\u0010\\\u001a\u00020 2\u0006\u0010]\u001a\u00020 H\u0016\u00a2\u0006\u0004\b^\u0010_J\u001f\u0010`\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020 H\u0002\u00a2\u0006\u0004\b`\u0010#J\u0017\u0010a\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020 H\u0002\u00a2\u0006\u0004\ba\u0010bR\u0016\u0010d\u001a\u00020c8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bd\u0010eR\u0016\u0010f\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bf\u0010gR\u0016\u0010h\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bh\u0010gR\u0016\u0010i\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bi\u0010gR\u0016\u0010j\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bj\u0010gR\u0016\u0010k\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bk\u0010gR\u0016\u0010l\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bl\u0010gR\u0016\u0010m\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bm\u0010nR\u0016\u0010o\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bo\u0010n\u00a8\u0006r"}, d2={"Ldragomordor/simpletms/ui/TMMachineScreen;", "Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;", "Ldragomordor/simpletms/ui/TMMachineMenu;", "menu", "Lnet/minecraft/world/entity/player/Inventory;", "playerInventory", "Lnet/minecraft/network/chat/Component;", "title", "<init>", "(Ldragomordor/simpletms/ui/TMMachineMenu;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/chat/Component;)V", "", "init", "()V", "Lnet/minecraft/client/Minecraft;", "minecraft", "", "width", "height", "resize", "(Lnet/minecraft/client/Minecraft;II)V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "", "partialTick", "mouseX", "mouseY", "renderBg", "(Lnet/minecraft/client/gui/GuiGraphics;FII)V", "renderTypeFilterButton", "(Lnet/minecraft/client/gui/GuiGraphics;II)V", "renderOwnershipFilterButton", "renderPokemonFilterButton", "", "", "isOverTypeFilterButton", "(DD)Z", "isOverOwnershipFilterButton", "isOverPokemonFilterButton", "x", "y", "renderCaseSlotItems", "row", "col", "Ldragomordor/simpletms/ui/TMMachineScreen$DisplayItem;", "getDisplayItemAtSlot", "(II)Ldragomordor/simpletms/ui/TMMachineScreen$DisplayItem;", "Lnet/minecraft/world/item/ItemStack;", "stack", "count", "renderItemWithCount", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/item/ItemStack;III)V", "Ldragomordor/simpletms/ui/TMMachineMenu$FilteredMoveEntry;", "entry", "Ldragomordor/simpletms/ui/MoveTypeFilter;", "typeFilter", "Lkotlin/Pair;", "getDisplayItemForEntry", "(Ldragomordor/simpletms/ui/TMMachineMenu$FilteredMoveEntry;Ldragomordor/simpletms/ui/MoveTypeFilter;)Lkotlin/Pair;", "renderGhostItem", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/item/ItemStack;II)V", "renderCaseSlotHighlight", "(Lnet/minecraft/client/gui/GuiGraphics;IIII)V", "renderScrollbar", "renderLabels", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "renderMoveTooltip", "keyCode", "scanCode", "modifiers", "keyPressed", "(III)Z", "", "codePoint", "charTyped", "(CI)Z", "button", "mouseClicked", "(DDI)Z", "", "speciesId", "formName", "displayName", "", "learnableMoves", "onPokemonSelected", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "scrollX", "scrollY", "mouseScrolled", "(DDDD)Z", "mouseReleased", "dragX", "dragY", "mouseDragged", "(DDIDD)Z", "isOverScrollbar", "updateScrollFromMouse", "(D)V", "Lnet/minecraft/client/gui/components/EditBox;", "searchBox", "Lnet/minecraft/client/gui/components/EditBox;", "typeFilterButtonX", "I", "typeFilterButtonY", "ownershipFilterButtonX", "ownershipFilterButtonY", "pokemonFilterButtonX", "pokemonFilterButtonY", "scrolling", "Z", "awaitingPartySelection", "Companion", "DisplayItem", "common"})
public final class TMMachineScreen
extends AbstractContainerScreen<TMMachineMenu> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private EditBox searchBox;
    private int typeFilterButtonX;
    private int typeFilterButtonY;
    private int ownershipFilterButtonX;
    private int ownershipFilterButtonY;
    private int pokemonFilterButtonX;
    private int pokemonFilterButtonY;
    private boolean scrolling;
    private boolean awaitingPartySelection;
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    private static final float GHOST_ALPHA = 0.35f;
    private static final int SCROLLBAR_X = 174;
    private static final int SCROLLBAR_Y = 18;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int SCROLLBAR_HEIGHT = 108;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int CASE_SLOTS_X = 8;
    private static final int CASE_SLOTS_Y = 18;
    private static final int SLOT_SIZE = 18;
    private static final int VISIBLE_ROWS = 6;
    private static final int COLUMNS = 9;
    private static final int SEARCH_BOX_WIDTH = 60;
    private static final int SEARCH_BOX_HEIGHT = 10;
    private static final int BUTTON_SIZE = 10;
    private static final int BUTTON_SPACING = 2;

    public TMMachineScreen(@NotNull TMMachineMenu menu, @NotNull Inventory playerInventory, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 222;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        this.titleLabelX = 8;
        this.titleLabelY = 6;
        PokemonFilterData pendingFilter = SimpleTMsNetwork.INSTANCE.consumePendingPokemonFilter();
        if (pendingFilter != null) {
            ((TMMachineMenu)this.menu).setPokemonFilter(pendingFilter);
        }
        int buttonY = this.topPos + 4;
        int searchX = this.leftPos + this.imageWidth - 60 - 6;
        this.typeFilterButtonX = this.leftPos + 71;
        this.typeFilterButtonY = buttonY;
        this.ownershipFilterButtonX = this.typeFilterButtonX + 10 + 2;
        this.ownershipFilterButtonY = buttonY;
        this.pokemonFilterButtonX = this.ownershipFilterButtonX + 10 + 2;
        this.pokemonFilterButtonY = buttonY;
        this.searchBox = new EditBox(this.font, searchX, buttonY, 60, 10, (Component)Component.translatable((String)"gui.simpletms.search"));
        EditBox editBox = this.searchBox;
        if (editBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox = null;
        }
        editBox.setMaxLength(50);
        EditBox editBox2 = this.searchBox;
        if (editBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox2 = null;
        }
        editBox2.setBordered(true);
        EditBox editBox3 = this.searchBox;
        if (editBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox3 = null;
        }
        editBox3.setVisible(true);
        EditBox editBox4 = this.searchBox;
        if (editBox4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox4 = null;
        }
        editBox4.setTextColor(0xFFFFFF);
        EditBox editBox5 = this.searchBox;
        if (editBox5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox5 = null;
        }
        editBox5.setHint((Component)Component.translatable((String)"gui.simpletms.search.hint"));
        EditBox editBox6 = this.searchBox;
        if (editBox6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox6 = null;
        }
        editBox6.setResponder(arg_0 -> TMMachineScreen.init$lambda$0(this, arg_0));
        EditBox editBox7 = this.searchBox;
        if (editBox7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox7 = null;
        }
        editBox7.setValue(((TMMachineMenu)this.menu).getSearchQuery());
        EditBox editBox8 = this.searchBox;
        if (editBox8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox8 = null;
        }
        this.addRenderableWidget((GuiEventListener)editBox8);
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        EditBox editBox = this.searchBox;
        if (editBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox = null;
        }
        String previousSearch = editBox.getValue();
        super.resize(minecraft, width, height);
        EditBox editBox2 = this.searchBox;
        if (editBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox2 = null;
        }
        editBox2.setValue(previousSearch);
        TMMachineMenu tMMachineMenu = (TMMachineMenu)this.menu;
        Intrinsics.checkNotNull((Object)previousSearch);
        tMMachineMenu.setSearchQuery(previousSearch);
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, 127);
        guiGraphics.blit(TEXTURE, x, y + 108 + 18 + 1, 0, 126, this.imageWidth, 96);
        this.renderTypeFilterButton(guiGraphics, mouseX, mouseY);
        this.renderOwnershipFilterButton(guiGraphics, mouseX, mouseY);
        this.renderPokemonFilterButton(guiGraphics, mouseX, mouseY);
        this.renderCaseSlotItems(guiGraphics, x, y);
        this.renderScrollbar(guiGraphics, x, y);
        this.renderCaseSlotHighlight(guiGraphics, x, y, mouseX, mouseY);
    }

    private final void renderTypeFilterButton(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        MoveTypeFilter filter = ((TMMachineMenu)this.menu).getTypeFilter();
        boolean isHovered = this.isOverTypeFilterButton(mouseX, mouseY);
        int bgColor = isHovered ? -11184811 : -13421773;
        guiGraphics.fill(this.typeFilterButtonX, this.typeFilterButtonY, this.typeFilterButtonX + 10, this.typeFilterButtonY + 10, bgColor);
        guiGraphics.renderOutline(this.typeFilterButtonX, this.typeFilterButtonY, 10, 10, -7829368);
        int innerMargin = 2;
        switch (WhenMappings.$EnumSwitchMapping$0[filter.ordinal()]) {
            case 1: {
                guiGraphics.fill(this.typeFilterButtonX + innerMargin, this.typeFilterButtonY + innerMargin, this.typeFilterButtonX + 5, this.typeFilterButtonY + 10 - innerMargin, -11184641);
                guiGraphics.fill(this.typeFilterButtonX + 5, this.typeFilterButtonY + innerMargin, this.typeFilterButtonX + 10 - innerMargin, this.typeFilterButtonY + 10 - innerMargin, -43691);
                break;
            }
            case 2: {
                guiGraphics.fill(this.typeFilterButtonX + innerMargin, this.typeFilterButtonY + innerMargin, this.typeFilterButtonX + 10 - innerMargin, this.typeFilterButtonY + 10 - innerMargin, -11184641);
                break;
            }
            case 3: {
                guiGraphics.fill(this.typeFilterButtonX + innerMargin, this.typeFilterButtonY + innerMargin, this.typeFilterButtonX + 10 - innerMargin, this.typeFilterButtonY + 10 - innerMargin, -43691);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void renderOwnershipFilterButton(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        OwnershipFilter filter = ((TMMachineMenu)this.menu).getOwnershipFilter();
        boolean isHovered = this.isOverOwnershipFilterButton(mouseX, mouseY);
        int bgColor = isHovered ? -11184811 : -13421773;
        guiGraphics.fill(this.ownershipFilterButtonX, this.ownershipFilterButtonY, this.ownershipFilterButtonX + 10, this.ownershipFilterButtonY + 10, bgColor);
        guiGraphics.renderOutline(this.ownershipFilterButtonX, this.ownershipFilterButtonY, 10, 10, -7829368);
        int innerMargin = 2;
        switch (WhenMappings.$EnumSwitchMapping$1[filter.ordinal()]) {
            case 1: {
                guiGraphics.renderOutline(this.ownershipFilterButtonX + innerMargin, this.ownershipFilterButtonY + innerMargin, 10 - innerMargin * 2, 10 - innerMargin * 2, -1);
                break;
            }
            case 2: {
                guiGraphics.fill(this.ownershipFilterButtonX + innerMargin, this.ownershipFilterButtonY + innerMargin, this.ownershipFilterButtonX + 10 - innerMargin, this.ownershipFilterButtonY + 10 - innerMargin, -11141291);
                break;
            }
            case 3: {
                guiGraphics.fill(this.ownershipFilterButtonX + innerMargin, this.ownershipFilterButtonY + innerMargin, this.ownershipFilterButtonX + 10 - innerMargin, this.ownershipFilterButtonY + 10 - innerMargin, -10066330);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void renderPokemonFilterButton(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        boolean hasFilter = ((TMMachineMenu)this.menu).getPokemonFilterData() != null;
        boolean isEnabled = ((TMMachineMenu)this.menu).isPokemonFilterEnabled();
        boolean isHovered = this.isOverPokemonFilterButton(mouseX, mouseY);
        int bgColor = isHovered ? -11184811 : -13421773;
        guiGraphics.fill(this.pokemonFilterButtonX, this.pokemonFilterButtonY, this.pokemonFilterButtonX + 10, this.pokemonFilterButtonY + 10, bgColor);
        guiGraphics.renderOutline(this.pokemonFilterButtonX, this.pokemonFilterButtonY, 10, 10, -7829368);
        int innerMargin = 2;
        if (hasFilter) {
            int indicatorColor = isEnabled ? -11141291 : -7829368;
            guiGraphics.fill(this.pokemonFilterButtonX + innerMargin, this.pokemonFilterButtonY + innerMargin, this.pokemonFilterButtonX + 10 - innerMargin, this.pokemonFilterButtonY + 10 - innerMargin, indicatorColor);
        } else {
            guiGraphics.renderOutline(this.pokemonFilterButtonX + innerMargin, this.pokemonFilterButtonY + innerMargin, 10 - innerMargin * 2, 10 - innerMargin * 2, -5592406);
        }
    }

    private final boolean isOverTypeFilterButton(double mouseX, double mouseY) {
        return mouseX >= (double)this.typeFilterButtonX && mouseX < (double)(this.typeFilterButtonX + 10) && mouseY >= (double)this.typeFilterButtonY && mouseY < (double)(this.typeFilterButtonY + 10);
    }

    private final boolean isOverOwnershipFilterButton(double mouseX, double mouseY) {
        return mouseX >= (double)this.ownershipFilterButtonX && mouseX < (double)(this.ownershipFilterButtonX + 10) && mouseY >= (double)this.ownershipFilterButtonY && mouseY < (double)(this.ownershipFilterButtonY + 10);
    }

    private final boolean isOverPokemonFilterButton(double mouseX, double mouseY) {
        return mouseX >= (double)this.pokemonFilterButtonX && mouseX < (double)(this.pokemonFilterButtonX + 10) && mouseY >= (double)this.pokemonFilterButtonY && mouseY < (double)(this.pokemonFilterButtonY + 10);
    }

    private final void renderCaseSlotItems(GuiGraphics guiGraphics, int x, int y) {
        boolean showGhosts;
        int scrollRow = ((TMMachineMenu)this.menu).getScrollRow();
        List<TMMachineMenu.FilteredMoveEntry> filteredMoves = ((TMMachineMenu)this.menu).getFilteredMoves();
        MoveTypeFilter typeFilter = ((TMMachineMenu)this.menu).getTypeFilter();
        OwnershipFilter ownershipFilter = ((TMMachineMenu)this.menu).getOwnershipFilter();
        boolean bl = showGhosts = ownershipFilter == OwnershipFilter.ALL || ownershipFilter == OwnershipFilter.MISSING_ONLY;
        if (typeFilter == MoveTypeFilter.ALL) {
            int itemIndex;
            List displayItems = new ArrayList();
            for (TMMachineMenu.FilteredMoveEntry entry : filteredMoves) {
                if (entry.isValidTM() && (entry.getTmCount() > 0 || showGhosts)) {
                    displayItems.add(new DisplayItem(entry.getMoveName(), false, entry.getTmCount()));
                }
                if (!entry.isValidTR() || entry.getTrCount() <= 0 && !showGhosts) continue;
                displayItems.add(new DisplayItem(entry.getMoveName(), true, entry.getTrCount()));
            }
            int startIndex = scrollRow * 9;
            for (int i = 0; i < 54 && (itemIndex = startIndex + i) < displayItems.size(); ++i) {
                DisplayItem item = (DisplayItem)displayItems.get(itemIndex);
                int col = i % 9;
                int row = i / 9;
                int slotX = x + 8 + col * 18 + 1;
                int slotY = y + 18 + row * 18 + 1;
                String prefix = item.isTR() ? "tr_" : "tm_";
                ItemStack itemStack = SimpleTMsItems.INSTANCE.getItemStackFromName(prefix + item.getMoveName());
                if (item.getCount() > 0) {
                    this.renderItemWithCount(guiGraphics, itemStack, slotX, slotY, item.getCount());
                    continue;
                }
                this.renderGhostItem(guiGraphics, itemStack, slotX, slotY);
            }
        } else {
            int moveIndex;
            int startIndex = scrollRow * 9;
            for (int i = 0; i < 54 && (moveIndex = startIndex + i) < filteredMoves.size(); ++i) {
                TMMachineMenu.FilteredMoveEntry entry = filteredMoves.get(moveIndex);
                int col = i % 9;
                int row = i / 9;
                int slotX = x + 8 + col * 18 + 1;
                int slotY = y + 18 + row * 18 + 1;
                Pair<ItemStack, Integer> pair = this.getDisplayItemForEntry(entry, typeFilter);
                ItemStack itemStack = (ItemStack)pair.component1();
                int count = ((Number)pair.component2()).intValue();
                if (count > 0) {
                    this.renderItemWithCount(guiGraphics, itemStack, slotX, slotY, count);
                    continue;
                }
                if (!showGhosts) continue;
                this.renderGhostItem(guiGraphics, itemStack, slotX, slotY);
            }
        }
    }

    private final DisplayItem getDisplayItemAtSlot(int row, int col) {
        List<TMMachineMenu.FilteredMoveEntry> filteredMoves = ((TMMachineMenu)this.menu).getFilteredMoves();
        OwnershipFilter ownershipFilter = ((TMMachineMenu)this.menu).getOwnershipFilter();
        boolean showGhosts = ownershipFilter == OwnershipFilter.ALL || ownershipFilter == OwnershipFilter.MISSING_ONLY;
        List displayItems = new ArrayList();
        for (TMMachineMenu.FilteredMoveEntry entry : filteredMoves) {
            if (entry.isValidTM() && (entry.getTmCount() > 0 || showGhosts)) {
                displayItems.add(new DisplayItem(entry.getMoveName(), false, entry.getTmCount()));
            }
            if (!entry.isValidTR() || entry.getTrCount() <= 0 && !showGhosts) continue;
            displayItems.add(new DisplayItem(entry.getMoveName(), true, entry.getTrCount()));
        }
        int scrollRow = ((TMMachineMenu)this.menu).getScrollRow();
        int slotIndex = (scrollRow + row) * 9 + col;
        return (DisplayItem)CollectionsKt.getOrNull((List)displayItems, (int)slotIndex);
    }

    private final void renderItemWithCount(GuiGraphics guiGraphics, ItemStack stack, int x, int y, int count) {
        if (stack.isEmpty()) {
            return;
        }
        guiGraphics.renderItem(stack, x, y);
        if (count > 1) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            String countStr = count > 99 ? "99+" : String.valueOf(count);
            int textX = x + 17 - this.font.width(countStr);
            int textY = y + 9;
            guiGraphics.drawString(this.font, countStr, textX, textY, 0xFFFFFF, true);
            guiGraphics.pose().popPose();
        }
    }

    private final Pair<ItemStack, Integer> getDisplayItemForEntry(TMMachineMenu.FilteredMoveEntry entry, MoveTypeFilter typeFilter) {
        return switch (WhenMappings.$EnumSwitchMapping$0[typeFilter.ordinal()]) {
            case 2 -> {
                ItemStack stack = SimpleTMsItems.INSTANCE.getItemStackFromName("tm_" + entry.getMoveName());
                yield TuplesKt.to((Object)stack, (Object)entry.getTmCount());
            }
            case 3 -> {
                ItemStack stack = SimpleTMsItems.INSTANCE.getItemStackFromName("tr_" + entry.getMoveName());
                yield TuplesKt.to((Object)stack, (Object)entry.getTrCount());
            }
            case 1 -> {
                String prefix = entry.isValidTM() ? "tm_" : "tr_";
                ItemStack stack = SimpleTMsItems.INSTANCE.getItemStackFromName(prefix + entry.getMoveName());
                int count = entry.getTmCount() + entry.getTrCount();
                yield TuplesKt.to((Object)stack, (Object)count);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void renderGhostItem(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        if (stack.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.35f);
        guiGraphics.renderItem(stack, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private final void renderCaseSlotHighlight(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        Pair<Integer, Integer> pair = ((TMMachineMenu)this.menu).getCaseSlotAt(mouseX - x - 8, mouseY - y - 18);
        if (pair == null) {
            return;
        }
        Pair<Integer, Integer> slotPos = pair;
        int row = ((Number)slotPos.component1()).intValue();
        int col = ((Number)slotPos.component2()).intValue();
        int slotX = x + 8 + col * 18;
        int slotY = y + 18 + row * 18;
        guiGraphics.fillGradient(slotX + 1, slotY + 1, slotX + 17, slotY + 17, -2130706433, -2130706433);
    }

    private final void renderScrollbar(GuiGraphics guiGraphics, int x, int y) {
        int maxScroll = ((TMMachineMenu)this.menu).getMaxScrollRow();
        if (maxScroll <= 0) {
            guiGraphics.fill(x + 174, y + 18, x + 174 + 6, y + 18 + 108, -13158601);
            return;
        }
        guiGraphics.fill(x + 174, y + 18, x + 174 + 6, y + 18 + 108, -16777216);
        float scrollProgress = (float)((TMMachineMenu)this.menu).getScrollRow() / (float)maxScroll;
        float scrollerY = (float)93 * scrollProgress;
        guiGraphics.fill(x + 174, y + 18 + (int)scrollerY, x + 174 + 6, y + 18 + (int)scrollerY + 15, -3750202);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isOverTypeFilterButton(mouseX, mouseY)) {
            String tooltipKey = switch (WhenMappings.$EnumSwitchMapping$0[((TMMachineMenu)this.menu).getTypeFilter().ordinal()]) {
                case 1 -> "gui.simpletms.machine.filter.all";
                case 2 -> "gui.simpletms.machine.filter.tm";
                case 3 -> "gui.simpletms.machine.filter.tr";
                default -> throw new NoWhenBranchMatchedException();
            };
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)tooltipKey), mouseX, mouseY);
        } else if (this.isOverOwnershipFilterButton(mouseX, mouseY)) {
            String tooltipKey = switch (WhenMappings.$EnumSwitchMapping$1[((TMMachineMenu)this.menu).getOwnershipFilter().ordinal()]) {
                case 1 -> "gui.simpletms.machine.ownership.all";
                case 2 -> "gui.simpletms.machine.ownership.owned";
                case 3 -> "gui.simpletms.machine.ownership.missing";
                default -> throw new NoWhenBranchMatchedException();
            };
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)tooltipKey), mouseX, mouseY);
        } else if (this.isOverPokemonFilterButton(mouseX, mouseY)) {
            List tooltipLines = new ArrayList();
            if (((TMMachineMenu)this.menu).hasPokemonFilter()) {
                String string = ((TMMachineMenu)this.menu).getPokemonDisplayName();
                if (string == null) {
                    string = "Unknown";
                }
                String pokemonName = string;
                int learnableCount = ((TMMachineMenu)this.menu).getPokemonLearnableCount();
                boolean isEnabled = ((TMMachineMenu)this.menu).isPokemonFilterEnabled();
                Object[] objectArray = new Object[]{pokemonName};
                MutableComponent mutableComponent = Component.translatable((String)"gui.simpletms.filter.pokemon", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                tooltipLines.add(mutableComponent);
                objectArray = new Object[]{learnableCount};
                MutableComponent mutableComponent2 = Component.translatable((String)"gui.simpletms.filter.pokemon.learnable", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
                tooltipLines.add(mutableComponent2);
                if (isEnabled) {
                    MutableComponent mutableComponent3 = Component.translatable((String)"gui.simpletms.filter.pokemon.enabled");
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
                    v6 = tooltipLines.add(mutableComponent3);
                } else {
                    MutableComponent mutableComponent4 = Component.translatable((String)"gui.simpletms.filter.pokemon.disabled");
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"translatable(...)");
                    v6 = tooltipLines.add(mutableComponent4);
                }
            } else {
                MutableComponent mutableComponent = Component.translatable((String)"gui.simpletms.filter.pokemon.none");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                v6 = tooltipLines.add(mutableComponent);
            }
            MutableComponent mutableComponent = Component.translatable((String)"gui.simpletms.filter.pokemon.shift_hint");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            tooltipLines.add(mutableComponent);
            guiGraphics.renderComponentTooltip(this.font, tooltipLines, mouseX, mouseY);
        } else {
            EditBox editBox = this.searchBox;
            if (editBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                editBox = null;
            }
            if (!editBox.isMouseOver((double)mouseX, (double)mouseY)) {
                this.renderMoveTooltip(guiGraphics, mouseX, mouseY);
            }
        }
    }

    private final void renderMoveTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Pair<Integer, Integer> pair = ((TMMachineMenu)this.menu).getCaseSlotAt(mouseX - this.leftPos - 8, mouseY - this.topPos - 18);
        if (pair == null) {
            return;
        }
        Pair<Integer, Integer> slotPos = pair;
        int row = ((Number)slotPos.component1()).intValue();
        int col = ((Number)slotPos.component2()).intValue();
        MoveTypeFilter typeFilter = ((TMMachineMenu)this.menu).getTypeFilter();
        if (typeFilter == MoveTypeFilter.ALL) {
            DisplayItem displayItem = this.getDisplayItemAtSlot(row, col);
            if (displayItem == null) {
                return;
            }
            DisplayItem displayItem2 = displayItem;
            String prefix = displayItem2.isTR() ? "tr_" : "tm_";
            ItemStack itemStack = SimpleTMsItems.INSTANCE.getItemStackFromName(prefix + displayItem2.getMoveName());
            if (itemStack.isEmpty()) {
                return;
            }
            Minecraft minecraft = this.minecraft;
            Intrinsics.checkNotNull((Object)minecraft);
            guiGraphics.renderTooltip(this.font, AbstractContainerScreen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)itemStack), Optional.empty(), mouseX, mouseY);
        } else {
            int slotIndex = row * 9 + col;
            int moveIndex = ((TMMachineMenu)this.menu).getScrollRow() * 9 + slotIndex;
            List<TMMachineMenu.FilteredMoveEntry> filteredMoves = ((TMMachineMenu)this.menu).getFilteredMoves();
            if (!(0 <= moveIndex ? moveIndex < ((Collection)filteredMoves).size() : false)) {
                return;
            }
            TMMachineMenu.FilteredMoveEntry entry = filteredMoves.get(moveIndex);
            ItemStack itemStack = (ItemStack)this.getDisplayItemForEntry(entry, typeFilter).component1();
            if (itemStack.isEmpty()) {
                return;
            }
            Minecraft minecraft = this.minecraft;
            Intrinsics.checkNotNull((Object)minecraft);
            guiGraphics.renderTooltip(this.font, AbstractContainerScreen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)itemStack), Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        EditBox editBox = this.searchBox;
        if (editBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox = null;
        }
        if (editBox.isFocused()) {
            if (keyCode == 256) {
                EditBox editBox2 = this.searchBox;
                if (editBox2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                    editBox2 = null;
                }
                editBox2.setFocused(false);
                return true;
            }
            EditBox editBox3 = this.searchBox;
            if (editBox3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                editBox3 = null;
            }
            return editBox3.keyPressed(keyCode, scanCode, modifiers);
        }
        EditBox editBox4 = this.searchBox;
        if (editBox4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox4 = null;
        }
        if (editBox4.canConsumeInput()) {
            EditBox editBox5 = this.searchBox;
            if (editBox5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                editBox5 = null;
            }
            return editBox5.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        block10: {
            EditBox editBox;
            block9: {
                EditBox editBox2 = this.searchBox;
                if (editBox2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                    editBox2 = null;
                }
                if (editBox2.isFocused()) break block9;
                EditBox editBox3 = this.searchBox;
                if (editBox3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                    editBox3 = null;
                }
                if (!editBox3.canConsumeInput()) break block10;
            }
            if ((editBox = this.searchBox) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                editBox = null;
            }
            return editBox.charTyped(codePoint, modifiers);
        }
        if (Character.isLetterOrDigit(codePoint) || codePoint == '#') {
            EditBox editBox = this.searchBox;
            if (editBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                editBox = null;
            }
            editBox.setFocused(true);
            EditBox editBox4 = this.searchBox;
            if (editBox4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                editBox4 = null;
            }
            return editBox4.charTyped(codePoint, modifiers);
        }
        return super.charTyped(codePoint, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isOverTypeFilterButton(mouseX, mouseY)) {
            ((TMMachineMenu)this.menu).cycleTypeFilter();
            return true;
        }
        if (button == 0 && this.isOverOwnershipFilterButton(mouseX, mouseY)) {
            ((TMMachineMenu)this.menu).cycleOwnershipFilter();
            return true;
        }
        if (button == 0 && this.isOverPokemonFilterButton(mouseX, mouseY)) {
            if (AbstractContainerScreen.hasShiftDown()) {
                this.awaitingPartySelection = true;
                SimpleTMsNetwork.INSTANCE.sendMachinePartySelectRequest();
            } else {
                ((TMMachineMenu)this.menu).togglePokemonFilter();
            }
            return true;
        }
        EditBox editBox = this.searchBox;
        if (editBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox = null;
        }
        if (editBox.mouseClicked(mouseX, mouseY, button)) {
            EditBox editBox2 = this.searchBox;
            if (editBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                editBox2 = null;
            }
            this.setFocused((GuiEventListener)editBox2);
            return true;
        }
        EditBox editBox3 = this.searchBox;
        if (editBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox3 = null;
        }
        if (editBox3.isFocused()) {
            EditBox editBox4 = this.searchBox;
            if (editBox4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                editBox4 = null;
            }
            if (!editBox4.isMouseOver(mouseX, mouseY)) {
                EditBox editBox5 = this.searchBox;
                if (editBox5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
                    editBox5 = null;
                }
                editBox5.setFocused(false);
            }
        }
        if (button == 0 && this.isOverScrollbar(mouseX, mouseY)) {
            this.scrolling = true;
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        switch (button) {
            case 0: 
            case 1: {
                int currentCount;
                TMMachineMenu.FilteredMoveEntry entry;
                int relX = (int)mouseX - this.leftPos - 8;
                int relY = (int)mouseY - this.topPos - 18;
                Pair<Integer, Integer> slotPos = ((TMMachineMenu)this.menu).getCaseSlotAt(relX, relY);
                if (slotPos == null) break;
                int row = ((Number)slotPos.component1()).intValue();
                int col = ((Number)slotPos.component2()).intValue();
                MoveTypeFilter typeFilter = ((TMMachineMenu)this.menu).getTypeFilter();
                boolean isShiftClick = AbstractContainerScreen.hasShiftDown();
                if (typeFilter == MoveTypeFilter.ALL) {
                    DisplayItem displayItem = this.getDisplayItemAtSlot(row, col);
                    if (displayItem == null || displayItem.getCount() <= 0) break;
                    SimpleTMsNetwork.INSTANCE.sendMachineSlotClick(displayItem.getMoveName(), displayItem.isTR(), isShiftClick);
                    int withdrawAmount = isShiftClick ? displayItem.getCount() : 1;
                    ((TMMachineMenu)this.menu).updateClientCacheForWithdrawal(displayItem.getMoveName(), displayItem.isTR(), withdrawAmount);
                    return true;
                }
                int slotIndex = row * 9 + col;
                int moveIndex = ((TMMachineMenu)this.menu).getScrollRow() * 9 + slotIndex;
                List<TMMachineMenu.FilteredMoveEntry> filteredMoves = ((TMMachineMenu)this.menu).getFilteredMoves();
                boolean bl = 0 <= moveIndex ? moveIndex < ((Collection)filteredMoves).size() : false;
                if (!bl || !(entry = filteredMoves.get(moveIndex)).hasAny()) break;
                boolean clickTR = typeFilter == MoveTypeFilter.TM_ONLY ? false : (typeFilter == MoveTypeFilter.TR_ONLY ? true : (button == 1 ? true : entry.getTmCount() <= 0));
                int n = currentCount = clickTR ? entry.getTrCount() : entry.getTmCount();
                if (currentCount <= 0) break;
                SimpleTMsNetwork.INSTANCE.sendMachineSlotClick(entry.getMoveName(), clickTR, isShiftClick);
                int withdrawAmount = isShiftClick ? currentCount : 1;
                ((TMMachineMenu)this.menu).updateClientCacheForWithdrawal(entry.getMoveName(), clickTR, withdrawAmount);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public final void onPokemonSelected(@NotNull String speciesId, @NotNull String formName, @NotNull String displayName, @NotNull Set<String> learnableMoves) {
        Intrinsics.checkNotNullParameter((Object)speciesId, (String)"speciesId");
        Intrinsics.checkNotNullParameter((Object)formName, (String)"formName");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter(learnableMoves, (String)"learnableMoves");
        PokemonFilterData filterData = new PokemonFilterData(speciesId, formName, displayName, learnableMoves);
        ((TMMachineMenu)this.menu).setPokemonFilter(filterData);
        this.awaitingPartySelection = false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        EditBox editBox = this.searchBox;
        if (editBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchBox");
            editBox = null;
        }
        if (editBox.isMouseOver(mouseX, mouseY)) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        if (((TMMachineMenu)this.menu).getMaxScrollRow() > 0) {
            ((TMMachineMenu)this.menu).scroll(-RangesKt.coerceIn((int)((int)scrollY), (int)-1, (int)1));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling) {
            this.updateScrollFromMouse(mouseY);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private final boolean isOverScrollbar(double mouseX, double mouseY) {
        int x = this.leftPos + 174;
        int y = this.topPos + 18;
        return mouseX >= (double)x && mouseX < (double)(x + 6) && mouseY >= (double)y && mouseY < (double)(y + 108);
    }

    private final void updateScrollFromMouse(double mouseY) {
        int scrollAreaTop = this.topPos + 18;
        int scrollAreaHeight = 93;
        double relativeY = RangesKt.coerceIn((double)(mouseY - (double)scrollAreaTop - (double)7), (double)0.0, (double)scrollAreaHeight);
        double scrollProgress = relativeY / (double)scrollAreaHeight;
        ((TMMachineMenu)this.menu).setScrollRow((int)(scrollProgress * (double)((TMMachineMenu)this.menu).getMaxScrollRow()));
    }

    private static final void init$lambda$0(TMMachineScreen this$0, String it) {
        TMMachineMenu tMMachineMenu = (TMMachineMenu)this$0.menu;
        Intrinsics.checkNotNull((Object)it);
        tMMachineMenu.setSearchQuery(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\rR\u0014\u0010\u0013\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\rR\u0014\u0010\u0015\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\rR\u0014\u0010\u0017\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\rR\u0014\u0010\u0019\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\rR\u0014\u0010\u001a\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\r\u00a8\u0006\u001b"}, d2={"Ldragomordor/simpletms/ui/TMMachineScreen$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "", "GHOST_ALPHA", "F", "", "SCROLLBAR_X", "I", "SCROLLBAR_Y", "SCROLLBAR_WIDTH", "SCROLLBAR_HEIGHT", "SCROLLER_HEIGHT", "CASE_SLOTS_X", "CASE_SLOTS_Y", "SLOT_SIZE", "VISIBLE_ROWS", "COLUMNS", "SEARCH_BOX_WIDTH", "SEARCH_BOX_HEIGHT", "BUTTON_SIZE", "BUTTON_SPACING", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ.\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0013\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u000fJ\u0010\u0010\u0016\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u0005\u0010\rR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001a\u001a\u0004\b\u001b\u0010\u000f\u00a8\u0006\u001c"}, d2={"Ldragomordor/simpletms/ui/TMMachineScreen$DisplayItem;", "", "", "moveName", "", "isTR", "", "count", "<init>", "(Ljava/lang/String;ZI)V", "component1", "()Ljava/lang/String;", "component2", "()Z", "component3", "()I", "copy", "(Ljava/lang/String;ZI)Ldragomordor/simpletms/ui/TMMachineScreen$DisplayItem;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getMoveName", "Z", "I", "getCount", "common"})
    private static final class DisplayItem {
        @NotNull
        private final String moveName;
        private final boolean isTR;
        private final int count;

        public DisplayItem(@NotNull String moveName, boolean isTR, int count) {
            Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
            this.moveName = moveName;
            this.isTR = isTR;
            this.count = count;
        }

        @NotNull
        public final String getMoveName() {
            return this.moveName;
        }

        public final boolean isTR() {
            return this.isTR;
        }

        public final int getCount() {
            return this.count;
        }

        @NotNull
        public final String component1() {
            return this.moveName;
        }

        public final boolean component2() {
            return this.isTR;
        }

        public final int component3() {
            return this.count;
        }

        @NotNull
        public final DisplayItem copy(@NotNull String moveName, boolean isTR, int count) {
            Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
            return new DisplayItem(moveName, isTR, count);
        }

        public static /* synthetic */ DisplayItem copy$default(DisplayItem displayItem, String string, boolean bl, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = displayItem.moveName;
            }
            if ((n2 & 2) != 0) {
                bl = displayItem.isTR;
            }
            if ((n2 & 4) != 0) {
                n = displayItem.count;
            }
            return displayItem.copy(string, bl, n);
        }

        @NotNull
        public String toString() {
            return "DisplayItem(moveName=" + this.moveName + ", isTR=" + this.isTR + ", count=" + this.count + ")";
        }

        public int hashCode() {
            int result = this.moveName.hashCode();
            result = result * 31 + Boolean.hashCode(this.isTR);
            result = result * 31 + Integer.hashCode(this.count);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DisplayItem)) {
                return false;
            }
            DisplayItem displayItem = (DisplayItem)other;
            if (!Intrinsics.areEqual((Object)this.moveName, (Object)displayItem.moveName)) {
                return false;
            }
            if (this.isTR != displayItem.isTR) {
                return false;
            }
            return this.count == displayItem.count;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MoveTypeFilter.values().length];
            try {
                nArray[MoveTypeFilter.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MoveTypeFilter.TM_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MoveTypeFilter.TR_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OwnershipFilter.values().length];
            try {
                nArray[OwnershipFilter.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OwnershipFilter.OWNED_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OwnershipFilter.MISSING_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

