/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms.util;

import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.moves.Learnset;
import com.cobblemon.mod.common.api.pokemon.moves.LearnsetQuery;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dragomordor.simpletms.SimpleTMs;
import dragomordor.simpletms.SimpleTMsItems;
import dragomordor.simpletms.config.SimpleTMsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\tJ\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\tJ\u001d\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u001d\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0011\u0010\u000fJ%\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Ldragomordor/simpletms/util/MoveHelper;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "", "", "getLearnableTMMoves", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Ljava/util/Set;", "getLearnableTRMoves", "getAllLearnableMoves", "moveName", "", "canLearnTM", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Ljava/lang/String;)Z", "canLearnTR", "canLearnMove", "isTR", "getLearnableMoves", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Z)Ljava/util/Set;", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "moveTemplate", "Ldragomordor/simpletms/config/SimpleTMsConfig;", "cfg", "canPokemonLearnMoveTemplate", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/api/moves/MoveTemplate;Ldragomordor/simpletms/config/SimpleTMsConfig;)Z", "Lcom/cobblemon/mod/common/api/pokemon/moves/Learnset;", "learnset", "canLearnFromLearnset", "(Lcom/cobblemon/mod/common/api/moves/MoveTemplate;Lcom/cobblemon/mod/common/api/pokemon/moves/Learnset;Ldragomordor/simpletms/config/SimpleTMsConfig;)Z", "common"})
@SourceDebugExtension(value={"SMAP\nMoveHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveHelper.kt\ndragomordor/simpletms/util/MoveHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n1563#2:218\n1634#2,3:219\n*S KotlinDebug\n*F\n+ 1 MoveHelper.kt\ndragomordor/simpletms/util/MoveHelper\n*L\n108#1:218\n108#1:219,3\n*E\n"})
public final class MoveHelper {
    @NotNull
    public static final MoveHelper INSTANCE = new MoveHelper();

    private MoveHelper() {
    }

    @NotNull
    public final Set<String> getLearnableTMMoves(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return this.getLearnableMoves(pokemon, false);
    }

    @NotNull
    public final Set<String> getLearnableTRMoves(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return this.getLearnableMoves(pokemon, true);
    }

    @NotNull
    public final Set<String> getAllLearnableMoves(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Set moves = new LinkedHashSet();
        moves.addAll((Collection)this.getLearnableTMMoves(pokemon));
        moves.addAll((Collection)this.getLearnableTRMoves(pokemon));
        return moves;
    }

    public final boolean canLearnTM(@NotNull Pokemon pokemon, @NotNull String moveName) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        Set<String> set = this.getLearnableTMMoves(pokemon);
        String string = moveName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return set.contains(string);
    }

    public final boolean canLearnTR(@NotNull Pokemon pokemon, @NotNull String moveName) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        Set<String> set = this.getLearnableTRMoves(pokemon);
        String string = moveName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return set.contains(string);
    }

    public final boolean canLearnMove(@NotNull Pokemon pokemon, @NotNull String moveName) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        Intrinsics.checkNotNullParameter((Object)moveName, (String)"moveName");
        return this.canLearnTM(pokemon, moveName) || this.canLearnTR(pokemon, moveName);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getLearnableMoves(Pokemon pokemon, boolean isTR) {
        List<String> validMoves;
        SimpleTMsConfig cfg = SimpleTMs.INSTANCE.getConfig();
        Set learnableMoves = new LinkedHashSet();
        if (!isTR && !cfg.getTmsUsable()) {
            return SetsKt.emptySet();
        }
        if (isTR && !cfg.getTrsUsable()) {
            return SetsKt.emptySet();
        }
        List<String> list = validMoves = isTR ? SimpleTMsItems.INSTANCE.getALL_MOVE_NAMES_WITH_TR_ITEMS() : SimpleTMsItems.INSTANCE.getALL_MOVE_NAMES_WITH_TM_ITEMS();
        if (!isTR && cfg.getAnyMovesLearnableTMs() || isTR && cfg.getAnyMovesLearnableTRs()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = validMoves;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                collection.add(string2);
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        List<String> excludedMoves = SimpleTMsItems.INSTANCE.getALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING();
        for (String moveName : validMoves) {
            MoveTemplate moveTemplate;
            if (Moves.getByName((String)moveName) == null || excludedMoves.contains(moveTemplate.getName()) || !this.canPokemonLearnMoveTemplate(pokemon, moveTemplate, cfg)) continue;
            String string = moveName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            learnableMoves.add(string);
        }
        return learnableMoves;
    }

    private final boolean canPokemonLearnMoveTemplate(Pokemon pokemon, MoveTemplate moveTemplate, SimpleTMsConfig cfg) {
        if (this.canLearnFromLearnset(moveTemplate, pokemon.getForm().getMoves(), cfg)) {
            return true;
        }
        for (FormData form : pokemon.getSpecies().getForms()) {
            if (Intrinsics.areEqual((Object)form, (Object)pokemon.getForm()) || !this.canLearnFromLearnset(moveTemplate, form.getMoves(), cfg)) continue;
            return true;
        }
        if (cfg.getPrimaryTypeMovesLearnable() || cfg.getSecondaryTypeMovesLearnable()) {
            ElementalType primary = pokemon.getPrimaryType();
            ElementalType secondary = pokemon.getSecondaryType();
            if (cfg.getPrimaryTypeMovesLearnable() && Intrinsics.areEqual((Object)moveTemplate.getElementalType(), (Object)primary)) {
                return true;
            }
            if (cfg.getSecondaryTypeMovesLearnable() && secondary != null && Intrinsics.areEqual((Object)moveTemplate.getElementalType(), (Object)secondary)) {
                return true;
            }
        }
        return false;
    }

    private final boolean canLearnFromLearnset(MoveTemplate moveTemplate, Learnset learnset, SimpleTMsConfig cfg) {
        if (!LearnsetQuery.Companion.getANY().canLearn(moveTemplate, learnset)) {
            return false;
        }
        if (cfg.getTmMovesLearnable() && LearnsetQuery.Companion.getTM_MOVE().canLearn(moveTemplate, learnset)) {
            return true;
        }
        if (cfg.getTutorMovesLearnable() && LearnsetQuery.Companion.getTUTOR_MOVES().canLearn(moveTemplate, learnset)) {
            return true;
        }
        if (cfg.getEggMovesLearnable() && LearnsetQuery.Companion.getEGG_MOVE().canLearn(moveTemplate, learnset)) {
            return true;
        }
        if (cfg.getLevelMovesLearnable() && LearnsetQuery.Companion.getANY_LEVEL().canLearn(moveTemplate, learnset)) {
            return true;
        }
        if (cfg.getLegacyMovesLearnable() && LearnsetQuery.Companion.getLEGACY_MOVES().canLearn(moveTemplate, learnset)) {
            return true;
        }
        return cfg.getSpecialMovesLearnable() && LearnsetQuery.Companion.getSPECIAL_MOVES().canLearn(moveTemplate, learnset);
    }
}

