/*
 * Decompiled with CFR 0.152.
 */
package dragomordor.simpletms;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dragomordor.simpletms.SimpleTMs;
import dragomordor.simpletms.item.custom.BlankTmItem;
import dragomordor.simpletms.item.custom.MoveLearnItem;
import dragomordor.simpletms.util.MiscUtilsKt;
import dragomordor.simpletms.util.MoveLearnItemDefinition;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b+\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0015J%\u0010\"\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040 H\u0002\u00a2\u0006\u0004\b\"\u0010#J\r\u0010$\u001a\u00020\u0013\u00a2\u0006\u0004\b$\u0010\u0003J\u0017\u0010&\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b)\u0010'J\u0015\u0010+\u001a\u00020*2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010.\u001a\u00020-2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b.\u0010/J\u001d\u00102\u001a\u00020-2\u0006\u00101\u001a\u0002002\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b2\u00103J\u001d\u00105\u001a\u00020\u00062\u0006\u00101\u001a\u0002042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b5\u00106R\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020-078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b<\u0010;R\u0014\u0010=\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b=\u0010;R\u0014\u0010>\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010?R\u0014\u0010A\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010?R\u0014\u0010B\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010?R\u0014\u0010C\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010?R\u001d\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00040 8\u0006\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010GR\u001d\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00040 8\u0006\u00a2\u0006\f\n\u0004\bH\u0010E\u001a\u0004\bI\u0010GR\u001d\u0010J\u001a\b\u0012\u0004\u0012\u0002040\u00198\u0006\u00a2\u0006\f\n\u0004\bJ\u0010E\u001a\u0004\bK\u0010GR\u001d\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00040\u00198\u0006\u00a2\u0006\f\n\u0004\bL\u0010E\u001a\u0004\bM\u0010GR\u001d\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00040 8\u0006\u00a2\u0006\f\n\u0004\bN\u0010E\u001a\u0004\bO\u0010GR\u001d\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00040 8\u0006\u00a2\u0006\f\n\u0004\bP\u0010E\u001a\u0004\bQ\u0010GR\u001d\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00040 8\u0006\u00a2\u0006\f\n\u0004\bR\u0010E\u001a\u0004\bS\u0010GR#\u0010T\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\b0 8\u0006\u00a2\u0006\f\n\u0004\bT\u0010E\u001a\u0004\bU\u0010GR#\u0010V\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\b0 8\u0006\u00a2\u0006\f\n\u0004\bV\u0010E\u001a\u0004\bW\u0010GR#\u0010X\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\b0 8\u0006\u00a2\u0006\f\n\u0004\bX\u0010E\u001a\u0004\bY\u0010GR#\u0010Z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\b0 8\u0006\u00a2\u0006\f\n\u0004\bZ\u0010E\u001a\u0004\b[\u0010GR\u001d\u0010\\\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\b\\\u0010]\u001a\u0004\b^\u0010_R\u001d\u0010`\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006\u00a2\u0006\f\n\u0004\b`\u0010]\u001a\u0004\ba\u0010_\u00a8\u0006b"}, d2={"Ldragomordor/simpletms/SimpleTMsItems;", "", "<init>", "()V", "", "name", "", "isTR", "Ldev/architectury/registry/registries/RegistrySupplier;", "Ldragomordor/simpletms/item/custom/BlankTmItem;", "registerBlankTmItem", "(Ljava/lang/String;Z)Ldev/architectury/registry/registries/RegistrySupplier;", "moveName", "isCustom", "Ldragomordor/simpletms/item/custom/MoveLearnItem;", "registerMoveLearnItem", "(Ljava/lang/String;ZZ)Ldev/architectury/registry/registries/RegistrySupplier;", "Ljava/io/File;", "moveFile", "", "registerMoveLearnItemsFromConfig", "(Ljava/io/File;Z)V", "jsonFilePath", "registerMoveLearnItemsFromResourceJSON", "(Ljava/lang/String;Z)V", "", "Ldragomordor/simpletms/util/MoveLearnItemDefinition;", "loadMoveLearnItemsFromJson", "(Ljava/lang/String;)Ljava/util/List;", "moveConfigFile", "loadDefaultMoveConfig", "excludedMovesFile", "", "excludedMoveList", "loadExcludedMovesFromConfig", "(Ljava/io/File;Ljava/util/List;)V", "registerModItems", "gebJsonFilePath", "loadGEBCustomMoves", "(Ljava/lang/String;)V", "customJsonFilePath", "loadCustomMoves", "Lnet/minecraft/world/item/ItemStack;", "getItemStackFromName", "(Ljava/lang/String;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/item/Item;", "getItemFromName", "(Ljava/lang/String;)Lnet/minecraft/world/item/Item;", "Lcom/cobblemon/mod/common/api/moves/Move;", "move", "getTMorTRItemFromMove", "(Lcom/cobblemon/mod/common/api/moves/Move;Z)Lnet/minecraft/world/item/Item;", "Lcom/cobblemon/mod/common/api/moves/MoveTemplate;", "hasItemForMove", "(Lcom/cobblemon/mod/common/api/moves/MoveTemplate;Z)Z", "Ldev/architectury/registry/registries/DeferredRegister;", "ITEMS", "Ldev/architectury/registry/registries/DeferredRegister;", "DEFAULT_MOVE_JSON_PATH", "Ljava/lang/String;", "CUSTOM_MOVE_JSON_PATH", "GEB_CUSTOM_MOVE_JSON_PATH", "defaultTMMoveConfigFile", "Ljava/io/File;", "defaultTRMoveConfigFile", "movesExcludedFromPokemonDropsFile", "moveExcludedFromBlankLearningFile", "movesExcludedFromTMTRLearningFile", "ALL_MOVE_NAMES_WITH_TM_ITEMS", "Ljava/util/List;", "getALL_MOVE_NAMES_WITH_TM_ITEMS", "()Ljava/util/List;", "ALL_MOVE_NAMES_WITH_TR_ITEMS", "getALL_MOVE_NAMES_WITH_TR_ITEMS", "ALL_MOVE_TEMPLATES_WITH_ITEMS", "getALL_MOVE_TEMPLATES_WITH_ITEMS", "ALL_REMOVED_DEFAULT_MOVES", "getALL_REMOVED_DEFAULT_MOVES", "ALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS", "getALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS", "ALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING", "getALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING", "ALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING", "getALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING", "TM_ITEMS", "getTM_ITEMS", "TR_ITEMS", "getTR_ITEMS", "CUSTOM_TR_ITEMS", "getCUSTOM_TR_ITEMS", "CUSTOM_TM_ITEMS", "getCUSTOM_TM_ITEMS", "BLANK_TM", "Ldev/architectury/registry/registries/RegistrySupplier;", "getBLANK_TM", "()Ldev/architectury/registry/registries/RegistrySupplier;", "BLANK_TR", "getBLANK_TR", "common"})
@SourceDebugExtension(value={"SMAP\nSimpleTMsItems.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTMsItems.kt\ndragomordor/simpletms/SimpleTMsItems\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,322:1\n1#2:323\n96#3:324\n96#3:325\n96#3:326\n*S KotlinDebug\n*F\n+ 1 SimpleTMsItems.kt\ndragomordor/simpletms/SimpleTMsItems\n*L\n116#1:324\n167#1:325\n211#1:326\n*E\n"})
public final class SimpleTMsItems {
    @NotNull
    public static final SimpleTMsItems INSTANCE = new SimpleTMsItems();
    @NotNull
    private static final DeferredRegister<Item> ITEMS;
    @NotNull
    private static final String DEFAULT_MOVE_JSON_PATH = "simpletms/movelearnitems/default.json";
    @NotNull
    private static final String CUSTOM_MOVE_JSON_PATH = "config/simpletms/custom/custom_moves.json";
    @NotNull
    private static final String GEB_CUSTOM_MOVE_JSON_PATH = "config/simpletms/custom/geb_custom_moves.json";
    @NotNull
    private static final File defaultTMMoveConfigFile;
    @NotNull
    private static final File defaultTRMoveConfigFile;
    @NotNull
    private static final File movesExcludedFromPokemonDropsFile;
    @NotNull
    private static final File moveExcludedFromBlankLearningFile;
    @NotNull
    private static final File movesExcludedFromTMTRLearningFile;
    @NotNull
    private static final List<String> ALL_MOVE_NAMES_WITH_TM_ITEMS;
    @NotNull
    private static final List<String> ALL_MOVE_NAMES_WITH_TR_ITEMS;
    @NotNull
    private static final List<MoveTemplate> ALL_MOVE_TEMPLATES_WITH_ITEMS;
    @NotNull
    private static final List<String> ALL_REMOVED_DEFAULT_MOVES;
    @NotNull
    private static final List<String> ALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS;
    @NotNull
    private static final List<String> ALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING;
    @NotNull
    private static final List<String> ALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING;
    @NotNull
    private static final List<RegistrySupplier<MoveLearnItem>> TM_ITEMS;
    @NotNull
    private static final List<RegistrySupplier<MoveLearnItem>> TR_ITEMS;
    @NotNull
    private static final List<RegistrySupplier<MoveLearnItem>> CUSTOM_TR_ITEMS;
    @NotNull
    private static final List<RegistrySupplier<MoveLearnItem>> CUSTOM_TM_ITEMS;
    @NotNull
    private static final RegistrySupplier<BlankTmItem> BLANK_TM;
    @NotNull
    private static final RegistrySupplier<BlankTmItem> BLANK_TR;

    private SimpleTMsItems() {
    }

    @NotNull
    public final List<String> getALL_MOVE_NAMES_WITH_TM_ITEMS() {
        return ALL_MOVE_NAMES_WITH_TM_ITEMS;
    }

    @NotNull
    public final List<String> getALL_MOVE_NAMES_WITH_TR_ITEMS() {
        return ALL_MOVE_NAMES_WITH_TR_ITEMS;
    }

    @NotNull
    public final List<MoveTemplate> getALL_MOVE_TEMPLATES_WITH_ITEMS() {
        return ALL_MOVE_TEMPLATES_WITH_ITEMS;
    }

    @NotNull
    public final List<String> getALL_REMOVED_DEFAULT_MOVES() {
        return ALL_REMOVED_DEFAULT_MOVES;
    }

    @NotNull
    public final List<String> getALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS() {
        return ALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS;
    }

    @NotNull
    public final List<String> getALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING() {
        return ALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING;
    }

    @NotNull
    public final List<String> getALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING() {
        return ALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING;
    }

    @NotNull
    public final List<RegistrySupplier<MoveLearnItem>> getTM_ITEMS() {
        return TM_ITEMS;
    }

    @NotNull
    public final List<RegistrySupplier<MoveLearnItem>> getTR_ITEMS() {
        return TR_ITEMS;
    }

    @NotNull
    public final List<RegistrySupplier<MoveLearnItem>> getCUSTOM_TR_ITEMS() {
        return CUSTOM_TR_ITEMS;
    }

    @NotNull
    public final List<RegistrySupplier<MoveLearnItem>> getCUSTOM_TM_ITEMS() {
        return CUSTOM_TM_ITEMS;
    }

    @NotNull
    public final RegistrySupplier<BlankTmItem> getBLANK_TM() {
        return BLANK_TM;
    }

    @NotNull
    public final RegistrySupplier<BlankTmItem> getBLANK_TR() {
        return BLANK_TR;
    }

    private final RegistrySupplier<BlankTmItem> registerBlankTmItem(String name, boolean isTR) {
        RegistrySupplier item = null;
        if (isTR) {
            Item.Properties properties = new Item.Properties().stacksTo(SimpleTMs.INSTANCE.getConfig().getTrStackSize());
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
            Item.Properties settings = properties;
            item = ITEMS.register(name, () -> SimpleTMsItems.registerBlankTmItem$lambda$0(isTR, settings));
        } else {
            Item.Properties properties = new Item.Properties().durability(SimpleTMs.INSTANCE.getConfig().getBlankTMBaseDurability() > 0 ? SimpleTMs.INSTANCE.getConfig().getBlankTMBaseDurability() : 1);
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"durability(...)");
            Item.Properties settings = properties;
            item = ITEMS.register(name, () -> SimpleTMsItems.registerBlankTmItem$lambda$1(isTR, settings));
        }
        return item;
    }

    private final RegistrySupplier<MoveLearnItem> registerMoveLearnItem(String moveName, boolean isTR, boolean isCustom) {
        String itemKey = isTR ? "tr_" + moveName : "tm_" + moveName;
        RegistrySupplier item = null;
        if (isTR) {
            Item.Properties properties = new Item.Properties().stacksTo(SimpleTMs.INSTANCE.getConfig().getTrStackSize());
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
            settings = properties;
            item = ITEMS.register(itemKey, () -> SimpleTMsItems.registerMoveLearnItem$lambda$2(moveName, isTR, isCustom, settings));
        } else {
            Item.Properties properties = new Item.Properties().durability(SimpleTMs.INSTANCE.getConfig().getTmBaseDurability() > 0 ? SimpleTMs.INSTANCE.getConfig().getTmBaseDurability() : 1);
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"durability(...)");
            settings = properties;
            item = ITEMS.register(itemKey, () -> SimpleTMsItems.registerMoveLearnItem$lambda$3(moveName, isTR, isCustom, settings));
        }
        Triple triple = isTR ? new Triple(TR_ITEMS, CUSTOM_TR_ITEMS, ALL_MOVE_NAMES_WITH_TR_ITEMS) : new Triple(TM_ITEMS, CUSTOM_TM_ITEMS, ALL_MOVE_NAMES_WITH_TM_ITEMS);
        List itemList = (List)triple.component1();
        List customItemList = (List)triple.component2();
        List moveList = (List)triple.component3();
        (isCustom ? customItemList : itemList).add(item);
        moveList.add(moveName);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void registerMoveLearnItemsFromConfig(File moveFile, boolean isCustom) {
        Closeable closeable = new FileReader(moveFile);
        Object object = null;
        try {
            Object it = (FileReader)closeable;
            boolean bl = false;
            it = TextStreamsKt.readText((Reader)((Reader)it));
        }
        catch (Throwable it) {
            object = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        Object jsonContent = it;
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List itemDefinitions = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(MoveLearnItemDefinition.Companion.serializer()), (String)jsonContent);
        for (MoveLearnItemDefinition itemDefinition : itemDefinitions) {
            this.registerMoveLearnItem(itemDefinition.getMoveName(), true, isCustom);
            this.registerMoveLearnItem(itemDefinition.getMoveName(), false, isCustom);
        }
    }

    private final void registerMoveLearnItemsFromResourceJSON(String jsonFilePath, boolean isCustom) {
        List<MoveLearnItemDefinition> itemDefinitions = this.loadMoveLearnItemsFromJson(jsonFilePath);
        for (MoveLearnItemDefinition itemDefinition : itemDefinitions) {
            this.registerMoveLearnItem(itemDefinition.getMoveName(), false, isCustom);
            this.registerMoveLearnItem(itemDefinition.getMoveName(), true, isCustom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<MoveLearnItemDefinition> loadMoveLearnItemsFromJson(String jsonFilePath) {
        InputStream inputStream = SimpleTMs.class.getResourceAsStream("/" + jsonFilePath);
        if (inputStream == null) {
            throw new IllegalArgumentException("Resource not found: " + jsonFilePath);
        }
        InputStream resourceStream = inputStream;
        Closeable closeable = new InputStreamReader(resourceStream);
        Throwable throwable = null;
        try {
            Object it = (InputStreamReader)closeable;
            boolean bl = false;
            it = TextStreamsKt.readText((Reader)((Reader)it));
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object jsonContent = it;
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        List itemDefinitions = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(MoveLearnItemDefinition.Companion.serializer()), (String)jsonContent);
        return itemDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadDefaultMoveConfig(File moveConfigFile, boolean isTR) {
        String nameString;
        moveConfigFile.getParentFile().mkdirs();
        String string = nameString = isTR ? "TR" : "TM";
        if (moveConfigFile.exists()) {
            SimpleTMs.LOGGER.info("Found default moves config file for SimpleTMs for " + nameString + " moves");
        } else {
            String string2;
            SimpleTMs.LOGGER.info("Default moves config file not found. Creating default moves config file");
            InputStream inputStream = SimpleTMs.class.getResourceAsStream("/simpletms/movelearnitems/default.json");
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found: simpletms/movelearnitems/default.json");
            }
            InputStream resourceStream = inputStream;
            Closeable closeable = new InputStreamReader(resourceStream);
            Throwable throwable = null;
            try {
                InputStreamReader it = (InputStreamReader)closeable;
                boolean bl = false;
                string2 = TextStreamsKt.readText((Reader)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String jsonContent = string2;
            try {
                FileWriter fileWriter = new FileWriter(moveConfigFile);
                fileWriter.write(jsonContent);
                fileWriter.close();
            }
            catch (Exception exception) {
                SimpleTMs.LOGGER.error("Failed to save config file for simpletms. Reason:");
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadExcludedMovesFromConfig(File excludedMovesFile, List<String> excludedMoveList) {
        excludedMovesFile.getParentFile().mkdirs();
        if (excludedMovesFile.exists()) {
            SimpleTMs.LOGGER.info("Found excluded moves config file for SimpleTMs");
            Closeable closeable = new FileReader(excludedMovesFile);
            Object object = null;
            try {
                Object it = (FileReader)closeable;
                boolean bl = false;
                it = TextStreamsKt.readText((Reader)((Reader)it));
            }
            catch (Throwable it) {
                object = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            Object jsonContent = it;
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            List moveDefinitions = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(MoveLearnItemDefinition.Companion.serializer()), (String)jsonContent);
            excludedMoveList.clear();
            for (MoveLearnItemDefinition moveDefinition : moveDefinitions) {
                excludedMoveList.add(moveDefinition.getMoveName());
            }
        } else {
            SimpleTMs.LOGGER.info("Excluded moves config file not found. Creating empty excluded moves config file");
            try {
                FileWriter fileWriter = new FileWriter(excludedMovesFile);
                fileWriter.write("[]");
                fileWriter.close();
            }
            catch (Exception exception) {
                SimpleTMs.LOGGER.error("Failed to save config file for simpletms. Reason:");
                exception.printStackTrace();
            }
        }
    }

    public final void registerModItems() {
        SimpleTMs.LOGGER.info("Register Mod Items for simpletms");
        SimpleTMs.LOGGER.info("Loading default move configs for TMs and TRs");
        this.loadDefaultMoveConfig(defaultTMMoveConfigFile, false);
        this.loadDefaultMoveConfig(defaultTRMoveConfigFile, true);
        SimpleTMs.LOGGER.info("Registering default move TMs and TRs");
        if (SimpleTMs.INSTANCE.getConfig().getAllowCustomMovesAndEditing()) {
            this.registerMoveLearnItemsFromConfig(defaultTMMoveConfigFile, false);
        } else {
            this.registerMoveLearnItemsFromResourceJSON(DEFAULT_MOVE_JSON_PATH, false);
        }
        SimpleTMs.LOGGER.info("Registering custom TMs and TRs if present");
        this.loadGEBCustomMoves(GEB_CUSTOM_MOVE_JSON_PATH);
        this.loadCustomMoves(CUSTOM_MOVE_JSON_PATH);
        ITEMS.register();
        SimpleTMs.LOGGER.info("Loading excluded moves from config");
        this.loadExcludedMovesFromConfig(movesExcludedFromPokemonDropsFile, ALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS);
        this.loadExcludedMovesFromConfig(moveExcludedFromBlankLearningFile, ALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING);
        this.loadExcludedMovesFromConfig(movesExcludedFromTMTRLearningFile, ALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING);
    }

    private final void loadGEBCustomMoves(String gebJsonFilePath) {
        if (new File(gebJsonFilePath).exists()) {
            this.registerMoveLearnItemsFromConfig(new File(gebJsonFilePath), true);
        }
    }

    private final void loadCustomMoves(String customJsonFilePath) {
        if (SimpleTMs.INSTANCE.getConfig().getAllowCustomMovesAndEditing()) {
            this.registerMoveLearnItemsFromConfig(new File(customJsonFilePath), true);
        }
    }

    @NotNull
    public final ItemStack getItemStackFromName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ResourceLocation identifier = MiscUtilsKt.simpletmsResource(name);
        Object object = BuiltInRegistries.ITEM.get(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Item item = (Item)object;
        ItemStack itemStack = new ItemStack((ItemLike)item);
        return itemStack;
    }

    private final Item getItemFromName(String name) {
        ResourceLocation identifier = MiscUtilsKt.simpletmsResource(name);
        Object object = BuiltInRegistries.ITEM.get(identifier);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Item item = (Item)object;
        return item;
    }

    @NotNull
    public final Item getTMorTRItemFromMove(@NotNull Move move, boolean isTR) {
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        String prefix = isTR ? "tr_" : "tm_";
        String moveName = move.getName();
        Item newMoveLearnItem = this.getItemFromName(prefix + moveName);
        return newMoveLearnItem;
    }

    public final boolean hasItemForMove(@NotNull MoveTemplate move, boolean isTR) {
        Intrinsics.checkNotNullParameter((Object)move, (String)"move");
        return isTR ? ALL_MOVE_NAMES_WITH_TR_ITEMS.contains(move.getName()) : ALL_MOVE_NAMES_WITH_TM_ITEMS.contains(move.getName());
    }

    private static final BlankTmItem registerBlankTmItem$lambda$0(boolean $isTR, Item.Properties $settings) {
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        return new BlankTmItem($isTR, $settings);
    }

    private static final BlankTmItem registerBlankTmItem$lambda$1(boolean $isTR, Item.Properties $settings) {
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        return new BlankTmItem($isTR, $settings);
    }

    private static final MoveLearnItem registerMoveLearnItem$lambda$2(String $moveName, boolean $isTR, boolean $isCustom, Item.Properties $settings) {
        Intrinsics.checkNotNullParameter((Object)$moveName, (String)"$moveName");
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        return new MoveLearnItem($moveName, $isTR, $isCustom, $settings);
    }

    private static final MoveLearnItem registerMoveLearnItem$lambda$3(String $moveName, boolean $isTR, boolean $isCustom, Item.Properties $settings) {
        Intrinsics.checkNotNullParameter((Object)$moveName, (String)"$moveName");
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        return new MoveLearnItem($moveName, $isTR, $isCustom, $settings);
    }

    static {
        DeferredRegister deferredRegister = DeferredRegister.create((String)"simpletms", (ResourceKey)Registries.ITEM);
        Intrinsics.checkNotNullExpressionValue((Object)deferredRegister, (String)"create(...)");
        ITEMS = deferredRegister;
        defaultTMMoveConfigFile = new File("config/simpletms/moves/default_tm_moves.json");
        defaultTRMoveConfigFile = new File("config/simpletms/moves/default_tr_moves.json");
        movesExcludedFromPokemonDropsFile = new File("config/simpletms/moves/excluded_moves_from_pokemon_drops.json");
        moveExcludedFromBlankLearningFile = new File("config/simpletms/moves/excluded_moves_from_blank_learning.json");
        movesExcludedFromTMTRLearningFile = new File("config/simpletms/moves/excluded_moves_from_tmtr_learning.json");
        ALL_MOVE_NAMES_WITH_TM_ITEMS = new ArrayList();
        ALL_MOVE_NAMES_WITH_TR_ITEMS = new ArrayList();
        ALL_MOVE_TEMPLATES_WITH_ITEMS = new ArrayList();
        ALL_REMOVED_DEFAULT_MOVES = new ArrayList();
        ALL_MOVES_EXCLUDED_FROM_POKEMON_DROPS = new ArrayList();
        ALL_MOVES_EXCLUDED_FROM_BLANK_LEARNING = new ArrayList();
        ALL_MOVES_EXCLUDED_FROM_TMTR_LEARNING = new ArrayList();
        TM_ITEMS = new ArrayList();
        TR_ITEMS = new ArrayList();
        CUSTOM_TR_ITEMS = new ArrayList();
        CUSTOM_TM_ITEMS = new ArrayList();
        BLANK_TM = INSTANCE.registerBlankTmItem("tm_blank", false);
        BLANK_TR = INSTANCE.registerBlankTmItem("tr_blank", true);
    }
}

