/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.builder;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.nolij.toomanyrecipeviewers.TooManyRecipeViewers;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.builder.TMRVIngredientCollector;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.drawable.OffsetDrawable;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.ingredient.ITMRVRecipeSlotDrawable;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.ingredient.ITMRVSlotWidget;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.ingredient.TMRVSlotWidget;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.ingredient.TMRVTankWidget;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.runtime.IngredientManager;
import dev.nolij.toomanyrecipeviewers.util.FluidRendererParameters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.library.gui.recipes.layout.builder.LegacyTooltipCallbackAdapter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeSlotBuilder
implements IRecipeSlotBuilder {
    private final IngredientManager ingredientManager;
    public final RecipeIngredientRole role;
    private final TMRVIngredientCollector ingredientCollector;
    private boolean visible = true;
    @Nullable
    private String name;
    private final List<IRecipeSlotRichTooltipCallback> tooltipCallbacks = new ArrayList<IRecipeSlotRichTooltipCallback>();
    private boolean outputSlotBackground = false;
    @Nullable
    private OffsetDrawable background = null;
    @Nullable
    private OffsetDrawable overlay = null;
    private final Map<IIngredientType<?>, IIngredientRenderer<?>> rendererOverrides = new HashMap();
    @Nullable
    private FluidRendererParameters fluidRendererParameters = null;
    private ImmutableRect2i rect = new ImmutableRect2i(0, 0, 16, 16);

    RecipeSlotBuilder(IngredientManager ingredientManager, RecipeIngredientRole role) {
        this.ingredientManager = ingredientManager;
        this.role = role;
        this.ingredientCollector = new TMRVIngredientCollector(ingredientManager);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public List<ITypedIngredient<?>> getCollectedIngredients() {
        return this.ingredientCollector.getCollectedIngredients();
    }

    public List<EmiStack> getEMIStacks() {
        return this.ingredientCollector.getEMIStacks();
    }

    public EmiIngredient getEMIIngredient() {
        return this.ingredientCollector.getEMIIngredient();
    }

    @NotNull
    private ITMRVSlotWidget getWidget() {
        ITMRVRecipeSlotDrawable widget;
        if (this.fluidRendererParameters == null) {
            widget = new TMRVSlotWidget(this.ingredientManager, this.role, this.rect, this.rendererOverrides);
        } else {
            for (ITypedIngredient<?> ingredient : this.getCollectedIngredients()) {
                if (ingredient.getType() == TooManyRecipeViewers.fluidHelper.getFluidIngredientType()) continue;
                throw new IllegalStateException("Mixed fluids and non-fluids");
            }
            if (!this.rendererOverrides.isEmpty()) {
                throw new IllegalStateException("Renderer override on fluid slot");
            }
            widget = new TMRVTankWidget(this.ingredientManager, this.role, this.fluidRendererParameters, this.rect);
        }
        return widget;
    }

    public SlotWidget build() {
        if (!this.visible) {
            throw new UnsupportedOperationException();
        }
        ITMRVSlotWidget widget = this.getWidget();
        widget.drawBack(false);
        widget.large(this.outputSlotBackground);
        widget.setName(this.name);
        widget.addTooltipCallbacks(this.tooltipCallbacks);
        widget.setBackground(this.background);
        widget.setOverlay(this.overlay);
        widget.getIngredientCollector().copy(this.ingredientCollector);
        return (SlotWidget)widget;
    }

    public RecipeSlotBuilder setInvisible() {
        this.visible = false;
        return this;
    }

    @Override
    public IRecipeSlotBuilder addRichTooltipCallback(IRecipeSlotRichTooltipCallback tooltipCallback) {
        this.tooltipCallbacks.add(tooltipCallback);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addTooltipCallback(IRecipeSlotTooltipCallback tooltipCallback) {
        return this.addRichTooltipCallback(new LegacyTooltipCallbackAdapter(tooltipCallback));
    }

    @Override
    public IRecipeSlotBuilder setSlotName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public IRecipeSlotBuilder setStandardSlotBackground() {
        this.outputSlotBackground = false;
        return this;
    }

    @Override
    public IRecipeSlotBuilder setOutputSlotBackground() {
        this.outputSlotBackground = true;
        return this;
    }

    @Override
    public IRecipeSlotBuilder setBackground(IDrawable background, int xOffset, int yOffset) {
        this.background = new OffsetDrawable(background, xOffset, yOffset);
        return this;
    }

    @Override
    public IRecipeSlotBuilder setOverlay(IDrawable overlay, int xOffset, int yOffset) {
        this.overlay = new OffsetDrawable(overlay, xOffset, yOffset);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> IRecipeSlotBuilder setCustomRenderer(IIngredientType<T> type, IIngredientRenderer<T> renderer) {
        Map<IIngredientType<?>, IIngredientRenderer<?>> map = this.rendererOverrides;
        synchronized (map) {
            if (this.rendererOverrides.isEmpty()) {
                this.rect = new ImmutableRect2i(this.rect.x(), this.rect.y(), renderer.getWidth(), renderer.getHeight());
            } else if (renderer.getWidth() != this.rect.width() || renderer.getHeight() != this.rect.height()) {
                throw new IllegalStateException("Size mismatch");
            }
            this.rendererOverrides.put(type, renderer);
            return this;
        }
    }

    @Override
    public IRecipeSlotBuilder setFluidRenderer(long capacity, boolean showCapacity, int width, int height) {
        this.fluidRendererParameters = new FluidRendererParameters(capacity, showCapacity, width, height);
        this.rect = new ImmutableRect2i(this.rect.x(), this.rect.y(), width, height);
        return this;
    }

    @Override
    public IRecipeSlotBuilder setPosition(int x, int y) {
        this.rect = this.rect.setPosition(x, y);
        return this;
    }

    @Override
    public int getWidth() {
        return this.rect.width();
    }

    @Override
    public int getHeight() {
        return this.rect.height();
    }

    @Override
    public <I> IRecipeSlotBuilder addIngredients(IIngredientType<I> type, List<@Nullable I> ingredients) {
        this.ingredientCollector.addIngredients((IIngredientType)type, (List)ingredients);
        return this;
    }

    @Override
    public <I> IRecipeSlotBuilder addIngredient(IIngredientType<I> type, I ingredient) {
        this.ingredientCollector.addIngredient((IIngredientType)type, (Object)ingredient);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addIngredientsUnsafe(List<?> ingredients) {
        this.ingredientCollector.addIngredientsUnsafe((List)ingredients);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addTypedIngredients(List<ITypedIngredient<?>> ingredients) {
        this.ingredientCollector.addTypedIngredients((List)ingredients);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addOptionalTypedIngredients(List<Optional<ITypedIngredient<?>>> ingredients) {
        this.ingredientCollector.addOptionalTypedIngredients((List)ingredients);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addFluidStack(Fluid fluid) {
        this.ingredientCollector.addFluidStack(fluid);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addFluidStack(Fluid fluid, long amount) {
        this.ingredientCollector.addFluidStack(fluid, amount);
        return this;
    }

    @Override
    public IRecipeSlotBuilder addFluidStack(Fluid fluid, long amount, @Nullable CompoundTag dataComponentPatch) {
        this.ingredientCollector.addFluidStack(fluid, amount, dataComponentPatch);
        return this;
    }
}

