/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.libnolij.util;

import org.jetbrains.annotations.Contract;

public final class EasingUtil {
    private EasingUtil() {
    }

    @Contract(pure=true)
    public static double linear(double start, double end, double progress) {
        return start + (end - start) * progress;
    }

    @Contract(pure=true)
    public static double inverseLinear(double start, double end, double value) {
        return (value - start) / (end - start);
    }

    @Contract(pure=true)
    public static double out(double progress, double exponent) {
        return Math.pow(progress, exponent);
    }

    @Contract(pure=true)
    public static double inverseOut(double progress, double exponent) {
        return Math.pow(progress, 1.0 / exponent);
    }

    @Contract(pure=true)
    public static double out(double start, double end, double progress, double exponent) {
        return EasingUtil.linear(start, end, EasingUtil.out(progress, exponent));
    }

    @Contract(pure=true)
    public static double inverseOut(double start, double end, double value, double exponent) {
        return EasingUtil.inverseOut(EasingUtil.inverseLinear(start, end, value), exponent);
    }

    @Contract(pure=true)
    public static double in(double progress, double exponent) {
        return 1.0 - Math.pow(1.0 - progress, exponent);
    }

    @Contract(pure=true)
    public static double inverseIn(double progress, double exponent) {
        return 1.0 - Math.pow(1.0 - progress, 1.0 / exponent);
    }

    @Contract(pure=true)
    public static double in(double start, double end, double progress, double exponent) {
        return EasingUtil.linear(start, end, EasingUtil.in(progress, exponent));
    }

    @Contract(pure=true)
    public static double inverseIn(double start, double end, double value, double exponent) {
        return EasingUtil.inverseIn(EasingUtil.inverseLinear(start, end, value), exponent);
    }

    @Contract(pure=true)
    public static double inOut(double progress, double exponent) {
        return (progress < 0.5 ? EasingUtil.out(progress, exponent) : EasingUtil.in(progress, exponent)) * Math.pow(2.0, exponent - 1.0);
    }

    @Contract(pure=true)
    public static double inverseInOut(double progress, double exponent) {
        return progress < 0.5 ? Math.pow(progress / Math.pow(2.0, exponent - 1.0), 1.0 / exponent) : -Math.pow((1.0 - progress) / Math.pow(2.0, exponent - 1.0), 1.0 / exponent) + 1.0;
    }

    @Contract(pure=true)
    public static double inOut(double start, double end, double progress, double exponent) {
        return EasingUtil.linear(start, end, EasingUtil.inOut(progress, exponent));
    }

    @Contract(pure=true)
    public static double inverseInOut(double start, double end, double value, double exponent) {
        return EasingUtil.inverseInOut(EasingUtil.inverseLinear(start, end, value), exponent);
    }
}

