/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.config;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IEditModeConfig;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.ingredients.IngredientVisibility;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EditModeConfig
implements IEditModeConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<String> blacklist = new HashSet<String>();
    private final ISerializer serializer;
    private final IIngredientManager ingredientManager;
    private WeakReference<IngredientVisibility> ingredientVisibilityRef = new WeakReference<Object>(null);

    public EditModeConfig(ISerializer serializer, IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
        this.serializer = serializer;
        this.serializer.initialize(this);
        this.serializer.load(this);
    }

    public <V> void addIngredientToConfigBlacklist(ITypedIngredient<V> typedIngredient, IEditModeConfig.HideMode blacklistType, IIngredientHelper<V> ingredientHelper) {
        if (this.addIngredientToConfigBlacklistInternal(typedIngredient, blacklistType, ingredientHelper)) {
            this.serializer.save(this);
            this.notifyListenersOfVisibilityChange(typedIngredient, false);
        }
    }

    private <V> boolean addIngredientToConfigBlacklistInternal(ITypedIngredient<V> typedIngredient, IEditModeConfig.HideMode blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = EditModeConfig.getIngredientUid(typedIngredient, IEditModeConfig.HideMode.SINGLE, ingredientHelper);
        String wildcardUid = EditModeConfig.getIngredientUid(typedIngredient, IEditModeConfig.HideMode.WILDCARD, ingredientHelper);
        if (wildcardUid.equals(uid)) {
            blacklistType = IEditModeConfig.HideMode.WILDCARD;
        }
        if (blacklistType == IEditModeConfig.HideMode.SINGLE) {
            return this.blacklist.add(uid);
        }
        if (blacklistType == IEditModeConfig.HideMode.WILDCARD) {
            return this.blacklist.add(wildcardUid);
        }
        return false;
    }

    public <V> boolean isIngredientOnConfigBlacklist(ITypedIngredient<V> typedIngredient, IIngredientHelper<V> ingredientHelper) {
        for (IEditModeConfig.HideMode hideMode : IEditModeConfig.HideMode.values()) {
            if (!this.isIngredientOnConfigBlacklist(typedIngredient, hideMode, ingredientHelper)) continue;
            return true;
        }
        return false;
    }

    private <V> Set<IEditModeConfig.HideMode> getIngredientOnConfigBlacklist(ITypedIngredient<V> ingredient, IIngredientHelper<V> ingredientHelper) {
        String wildcardUid;
        String singleUid = EditModeConfig.getIngredientUid(ingredient, IEditModeConfig.HideMode.SINGLE, ingredientHelper);
        if (singleUid.equals(wildcardUid = EditModeConfig.getIngredientUid(ingredient, IEditModeConfig.HideMode.WILDCARD, ingredientHelper))) {
            if (this.blacklist.contains(singleUid)) {
                return Set.of(IEditModeConfig.HideMode.SINGLE, IEditModeConfig.HideMode.WILDCARD);
            }
            return Set.of();
        }
        HashSet<IEditModeConfig.HideMode> set = new HashSet<IEditModeConfig.HideMode>();
        if (this.blacklist.contains(singleUid)) {
            set.add(IEditModeConfig.HideMode.SINGLE);
        }
        if (this.blacklist.contains(wildcardUid)) {
            set.add(IEditModeConfig.HideMode.WILDCARD);
        }
        return Collections.unmodifiableSet(set);
    }

    public <V> boolean isIngredientOnConfigBlacklist(ITypedIngredient<V> typedIngredient, IEditModeConfig.HideMode blacklistType, IIngredientHelper<V> ingredientHelper) {
        String uid = EditModeConfig.getIngredientUid(typedIngredient, blacklistType, ingredientHelper);
        return this.blacklist.contains(uid);
    }

    private static <V> String getIngredientUid(ITypedIngredient<V> typedIngredient, IEditModeConfig.HideMode blacklistType, IIngredientHelper<V> ingredientHelper) {
        V ingredient = typedIngredient.getIngredient();
        return switch (blacklistType) {
            default -> throw new IncompatibleClassChangeError();
            case IEditModeConfig.HideMode.SINGLE -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient);
            case IEditModeConfig.HideMode.WILDCARD -> ingredientHelper.getWildcardId(ingredient);
        };
    }

    @Override
    public <V> boolean isIngredientHiddenUsingConfigFile(ITypedIngredient<V> ingredient) {
        IIngredientType<V> type = ingredient.getType();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        return this.isIngredientOnConfigBlacklist(ingredient, ingredientHelper);
    }

    @Override
    public <V> Set<IEditModeConfig.HideMode> getIngredientHiddenUsingConfigFile(ITypedIngredient<V> ingredient) {
        IIngredientType<V> type = ingredient.getType();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        return this.getIngredientOnConfigBlacklist(ingredient, ingredientHelper);
    }

    @Override
    public <V> void hideIngredientUsingConfigFile(ITypedIngredient<V> ingredient, IEditModeConfig.HideMode hideMode) {
        IIngredientType<V> type = ingredient.getType();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        this.addIngredientToConfigBlacklist(ingredient, hideMode, ingredientHelper);
    }

    @Override
    public <V> void showIngredientUsingConfigFile(ITypedIngredient<V> ingredient, IEditModeConfig.HideMode hideMode) {
        IIngredientType<V> type = ingredient.getType();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        String blacklistUid = EditModeConfig.getIngredientUid(ingredient, hideMode, ingredientHelper);
        if (this.blacklist.remove(blacklistUid)) {
            this.serializer.save(this);
            this.notifyListenersOfVisibilityChange(ingredient, true);
        }
    }

    public void registerListener(IngredientVisibility ingredientVisibility) {
        this.ingredientVisibilityRef = new WeakReference<IngredientVisibility>(ingredientVisibility);
    }

    private <T> void notifyListenersOfVisibilityChange(ITypedIngredient<T> ingredient, boolean visible) {
        IngredientVisibility ingredientVisibility = (IngredientVisibility)this.ingredientVisibilityRef.get();
        if (ingredientVisibility != null) {
            ingredientVisibility.notifyListeners(ingredient, visible);
        }
    }

    public static interface ISerializer {
        public void initialize(EditModeConfig var1);

        public void save(EditModeConfig var1);

        public void load(EditModeConfig var1);
    }

    public static class FileSerializer
    implements ISerializer {
        private final Path path;

        public FileSerializer(Path path) {
            this.path = path;
        }

        @Override
        public void initialize(EditModeConfig config) {
            if (!Files.exists(this.path, new LinkOption[0])) {
                this.save(config);
            }
        }

        @Override
        public void save(EditModeConfig config) {
            try {
                Files.write(this.path, config.blacklist, new OpenOption[0]);
                LOGGER.debug("Saved blacklist config to file: {}", (Object)this.path);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save blacklist config to file {}", (Object)this.path, (Object)e);
            }
        }

        @Override
        public void load(EditModeConfig config) {
            if (!Files.exists(this.path, new LinkOption[0])) {
                return;
            }
            try {
                List<String> strings = Files.readAllLines(this.path);
                config.blacklist.clear();
                config.blacklist.addAll(strings);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load blacklist from file {}", (Object)this.path, (Object)e);
            }
        }
    }
}

