/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.builder;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.jemi.JemiStack;
import dev.nolij.toomanyrecipeviewers.impl.ingredient.ErrorIngredient;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.runtime.IngredientManager;
import dev.nolij.toomanyrecipeviewers.util.IStackish;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IIngredientConsumer;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.library.ingredients.TypedIngredient;
import mezz.jei.library.ingredients.itemStacks.TypedItemStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class TMRVIngredientCollector
implements IIngredientAcceptor<TMRVIngredientCollector> {
    private final IngredientManager ingredientManager;
    private final ArrayList<ITypedIngredient<?>> collectedIngredients = new ArrayList();

    public TMRVIngredientCollector(IngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public Stream<ITypedIngredient<?>> stream() {
        return this.collectedIngredients.stream();
    }

    public List<ITypedIngredient<?>> getCollectedIngredients() {
        return this.stream().toList();
    }

    public boolean isEmpty() {
        return this.collectedIngredients.isEmpty();
    }

    public List<EmiStack> getEMIStacks() {
        return this.collectedIngredients.stream().map(this.ingredientManager::getEMIStack).toList();
    }

    public EmiIngredient getEMIIngredient() {
        return EmiIngredient.of(this.getEMIStacks());
    }

    public EmiIngredient getEMIIngredient(Map<IIngredientType<?>, IIngredientRenderer<?>> rendererOverrides) {
        return EmiIngredient.of(this.collectedIngredients.stream().map(typedIngredient -> {
            IIngredientType type = typedIngredient.getType();
            if (!rendererOverrides.containsKey(type)) {
                return this.ingredientManager.getEMIStack(typedIngredient);
            }
            return new JemiStack(type, this.ingredientManager.getIngredientHelper(type), (IIngredientRenderer)rendererOverrides.get(type), typedIngredient.getIngredient());
        }).toList());
    }

    public void copy(TMRVIngredientCollector other) {
        this.collectedIngredients.addAll(other.collectedIngredients);
    }

    @Override
    public <I> TMRVIngredientCollector addIngredient(IIngredientType<I> type, I ingredient) {
        if (type == VanillaTypes.ITEM_STACK) {
            if (ingredient instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)ingredient;
                this.collectedIngredients.add(TypedItemStack.create(itemStack));
            } else {
                this.collectedIngredients.add(ErrorIngredient.TYPED_INSTANCE);
            }
        } else {
            ITypedIngredient<ErrorIngredient> typedIngredient = TypedIngredient.createAndFilterInvalid(this.ingredientManager, type, ingredient, false).orElse(null);
            this.collectedIngredients.add(typedIngredient != null ? typedIngredient : ErrorIngredient.TYPED_INSTANCE);
        }
        return this;
    }

    @Override
    public <I> TMRVIngredientCollector addIngredients(IIngredientType<I> type, List<@Nullable I> ingredients) {
        for (I ingredient : ingredients) {
            this.addIngredient((IIngredientType)type, (Object)ingredient);
        }
        return this;
    }

    @Override
    public TMRVIngredientCollector addIngredientsUnsafe(List<?> ingredients) {
        for (Object ingredient : ingredients) {
            IIngredientType<?> type = this.ingredientManager.getIngredientType(ingredient);
            if (type != null) {
                this.collectedIngredients.add(TypedIngredient.createUnvalidated(type, ingredient));
                continue;
            }
            this.collectedIngredients.add(ErrorIngredient.TYPED_INSTANCE);
        }
        return this;
    }

    @Override
    public <I> TMRVIngredientCollector addTypedIngredient(ITypedIngredient<I> typedIngredient) {
        if (typedIngredient instanceof IStackish) {
            this.collectedIngredients.add(typedIngredient);
        } else {
            ITypedIngredient<ErrorIngredient> copy = TypedIngredient.deepCopy(this.ingredientManager, typedIngredient).orElse(null);
            this.collectedIngredients.add(copy != null ? copy : ErrorIngredient.TYPED_INSTANCE);
        }
        return this;
    }

    @Override
    public TMRVIngredientCollector addTypedIngredients(List<ITypedIngredient<?>> typedIngredients) {
        for (ITypedIngredient<?> typedIngredient : typedIngredients) {
            this.addTypedIngredient(typedIngredient);
        }
        return this;
    }

    @Override
    public TMRVIngredientCollector addOptionalTypedIngredients(List<Optional<ITypedIngredient<?>>> typedIngredients) {
        typedIngredients.stream().map(x -> x.orElse(null)).forEach(iTypedIngredient -> this.addTypedIngredient((ITypedIngredient)iTypedIngredient));
        return this;
    }

    @Override
    public IIngredientConsumer addItemLike(ItemLike itemLike) {
        return this.addTypedIngredient((ITypedIngredient)ItemEmiStack.of((ItemLike)itemLike));
    }

    @Override
    public TMRVIngredientCollector addFluidStack(Fluid fluid) {
        return this.addTypedIngredient((ITypedIngredient)FluidEmiStack.of((Fluid)fluid));
    }

    @Override
    public TMRVIngredientCollector addFluidStack(Fluid fluid, long amount) {
        return this.addTypedIngredient((ITypedIngredient)FluidEmiStack.of((Fluid)fluid, (long)amount));
    }

    @Override
    public TMRVIngredientCollector addFluidStack(Fluid fluid, long amount, @Nullable CompoundTag dataComponentPatch) {
        return this.addTypedIngredient((ITypedIngredient)FluidEmiStack.of((Fluid)fluid, (CompoundTag)dataComponentPatch, (long)amount));
    }
}

