/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.jei.common.network;

import com.google.common.collect.ImmutableMap;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.network.EmiNetwork;
import dev.emi.emi.network.EmiPacket;
import dev.emi.emi.network.FillRecipeC2SPacket;
import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.registry.EmiRecipeFiller;
import dev.nolij.toomanyrecipeviewers.mixin.PacketRecipeTransferAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.common.Constants;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.common.network.packets.PacketRecipeTransfer;
import mezz.jei.common.transfer.TransferOperation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.network.ConnectionData;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ConnectionToServer
implements IConnectionToServer {
    private final boolean serverHasJEI;

    public ConnectionToServer() {
        ClientPacketListener clientPacketListener = Minecraft.m_91087_().m_91403_();
        if (clientPacketListener == null || clientPacketListener.m_104910_().m_129531_()) {
            this.serverHasJEI = false;
        } else {
            Connection connection = clientPacketListener.m_104910_();
            ConnectionData connectionData = NetworkHooks.getConnectionData((Connection)connection);
            if (connectionData == null) {
                this.serverHasJEI = false;
            } else {
                ImmutableMap channels = connectionData.getChannels();
                this.serverHasJEI = channels.containsKey((Object)Constants.NETWORK_CHANNEL_ID);
            }
        }
    }

    @Override
    public boolean isJeiOnServer() {
        return true;
    }

    @Override
    public void sendPacketToServer(PacketJei packet) {
        if (!(packet instanceof PacketRecipeTransfer)) {
            return;
        }
        PacketRecipeTransfer recipeTransferPacket = (PacketRecipeTransfer)packet;
        if (this.serverHasJEI) {
            Pair<FriendlyByteBuf, Integer> packetData = packet.getPacketData();
            ICustomPacket payload = NetworkDirection.PLAY_TO_SERVER.buildPacket(packetData, Constants.NETWORK_CHANNEL_ID);
            PacketDistributor.SERVER.noArg().send(payload.getThis());
            return;
        }
        ConnectionToServer.handle(recipeTransferPacket);
    }

    public static void handle(PacketRecipeTransfer recipeTransferPacket) {
        AbstractContainerScreen containerScreen = EmiApi.getHandledScreen();
        if (containerScreen == null) {
            return;
        }
        AbstractContainerMenu containerMenu = containerScreen.m_6262_();
        final List<Slot> inventorySlots = recipeTransferPacket.inventorySlots.stream().map(x -> x.f_40219_).map(arg_0 -> ((AbstractContainerMenu)containerMenu).m_38853_(arg_0)).toList();
        final List<Slot> craftingSlots = recipeTransferPacket.craftingSlots.stream().map(x -> x.f_40219_).map(arg_0 -> ((AbstractContainerMenu)containerMenu).m_38853_(arg_0)).toList();
        int[] craftingSlotIndex = craftingSlots.stream().mapToInt(s -> s.f_40219_).toArray();
        ArrayList<Optional<TransferOperation>> transferOperationIndex = new ArrayList<Optional<TransferOperation>>(craftingSlots.size());
        for (int craftingSlotId : craftingSlotIndex) {
            transferOperationIndex.add(recipeTransferPacket.transferOperations.stream().filter(x -> x.craftingSlotId() == craftingSlotId).findFirst());
        }
        StandardRecipeHandler fakeRecipeHandler = new StandardRecipeHandler(){

            public List<Slot> getInputSources(AbstractContainerMenu handler) {
                return inventorySlots;
            }

            public List<Slot> getCraftingSlots(AbstractContainerMenu handler) {
                return craftingSlots;
            }

            public boolean supportsRecipe(EmiRecipe recipe) {
                return true;
            }
        };
        final List<EmiIngredient> fakeIngredients = transferOperationIndex.stream().map(o -> o.map(t -> containerMenu.m_38853_(t.inventorySlotId()))).map(o -> o.map(s -> s.m_7993_().m_255036_(1))).map(o -> o.map(EmiStack::of).orElse(EmiStack.EMPTY)).map(EmiIngredient.class::cast).toList();
        EmiRecipe fakeRecipe = new EmiRecipe(){

            public EmiRecipeCategory getCategory() {
                throw new UnsupportedOperationException();
            }

            @Nullable
            public ResourceLocation getId() {
                throw new UnsupportedOperationException();
            }

            public List<EmiIngredient> getInputs() {
                return fakeIngredients;
            }

            public List<EmiStack> getOutputs() {
                return List.of();
            }

            public int getDisplayWidth() {
                throw new UnsupportedOperationException();
            }

            public int getDisplayHeight() {
                throw new UnsupportedOperationException();
            }

            public void addWidgets(WidgetHolder widgets) {
                throw new UnsupportedOperationException();
            }
        };
        List stacks = EmiRecipeFiller.getStacks((StandardRecipeHandler)fakeRecipeHandler, (EmiRecipe)fakeRecipe, (AbstractContainerScreen)containerScreen, (int)(((PacketRecipeTransferAccessor)((Object)recipeTransferPacket)).tmrv$isMaxTransfer() ? Integer.MAX_VALUE : 1));
        if (EmiClient.onServer) {
            EmiNetwork.sendToServer((EmiPacket)new FillRecipeC2SPacket(containerMenu, 0, inventorySlots, craftingSlots, null, stacks));
        } else {
            EmiRecipeFiller.clientFill((StandardRecipeHandler)fakeRecipeHandler, null, (AbstractContainerScreen)containerScreen, (List)stacks, (EmiCraftContext.Destination)EmiCraftContext.Destination.NONE);
        }
    }
}

