/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.libnolij.util;

public final class ColourUtil {
    private ColourUtil() {
    }

    public static int getRGBA(double alpha, double red, double green, double blue) {
        return (int)(alpha * 255.0) << 24 | (int)(red * 255.0) << 16 | (int)(green * 255.0) << 8 | (int)(blue * 255.0);
    }

    @Deprecated(forRemoval=true)
    public static int getColour(double alpha, double red, double green, double blue) {
        return ColourUtil.getRGBA(alpha, red, green, blue);
    }

    public static double getAlpha(int colour) {
        return (double)(colour >> 24 & 0xFF) / 255.0;
    }

    public static double getRed(int colour) {
        return (double)(colour >> 16 & 0xFF) / 255.0;
    }

    public static double getGreen(int colour) {
        return (double)(colour >> 8 & 0xFF) / 255.0;
    }

    public static double getBlue(int colour) {
        return (double)(colour & 0xFF) / 255.0;
    }

    private static double chromaInternal(double speed, double shift, int offset) {
        return (1.0 + Math.sin(speed * shift + (double)offset)) * 0.5;
    }

    public static double chromaRed(double timestamp, double speed, int index) {
        return ColourUtil.chromaInternal(speed, (double)index + timestamp, 0);
    }

    public static double chromaGreen(double timestamp, double speed, int index) {
        return ColourUtil.chromaInternal(speed, (double)index + timestamp, 2);
    }

    public static double chromaBlue(double timestamp, double speed, int index) {
        return ColourUtil.chromaInternal(speed, (double)index + timestamp, 4);
    }

    public static int chroma(double timestamp, double speed, int index) {
        return ColourUtil.getRGBA(1.0, ColourUtil.chromaRed(timestamp, speed, index), ColourUtil.chromaGreen(timestamp, speed, index), ColourUtil.chromaBlue(timestamp, speed, index));
    }

    public static int chroma(double timestamp, double speed, int index, double factor) {
        return ColourUtil.getRGBA(1.0, ColourUtil.chromaRed(timestamp, speed, index) * factor, ColourUtil.chromaGreen(timestamp, speed, index) * factor, ColourUtil.chromaBlue(timestamp, speed, index) * factor);
    }
}

