/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.ingredient;

import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ErrorEmiStack
extends EmiStack {
    private static final Font FONT = Minecraft.getInstance().font;
    private static final int Y_OFFSET;
    private static final int BACKGROUND_COLOR = -5636096;
    private static final int TEXT_COLOUR = -2237133;
    public static final ErrorEmiStack INSTANCE;

    static void render(GuiGraphics draw) {
        draw.fill(0, 0, 16, 16, -5636096);
        draw.drawCenteredString(FONT, (Component)Component.literal((String)"!?!").withStyle(ChatFormatting.OBFUSCATED), 8, Y_OFFSET, -2237133);
    }

    private ErrorEmiStack() {
    }

    public EmiStack copy() {
        return this;
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)draw);
        context.push();
        context.matrices().translate((float)x, (float)y, 0.0f);
        ErrorEmiStack.render(context.raw());
        context.pop();
    }

    public boolean isEmpty() {
        return false;
    }

    public DataComponentPatch getComponentChanges() {
        return DataComponentPatch.EMPTY;
    }

    public Object getKey() {
        return ErrorEmiStack.class;
    }

    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"toomanyrecipeviewers", (String)"error");
    }

    public List<Component> getTooltipText() {
        return List.of(Component.literal((String)"ERROR").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD), Component.literal((String)"This shouldn't be here. It only shows when TooManyRecipeViewers has encountered an error. Please report this via a GitHub issue.\n").withStyle(ChatFormatting.DARK_RED), Component.literal((String)"PLEASE INCLUDE WITH YOUR REPORT:").withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE), Component.literal((String)"- Screenshots (WITHOUT this tooltip; it might cover useful information!)\n- What recipe you were trying to view\n- Which mod adds it (including version)\n- TooManyRecipeViewers version\n- Any other potentially useful information"));
    }

    public List<ClientTooltipComponent> getTooltip() {
        return this.getTooltipText().stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList();
    }

    public Component getName() {
        return Component.literal((String)"ERROR");
    }

    static {
        Objects.requireNonNull(FONT);
        Y_OFFSET = 8 - 9 / 2;
        INSTANCE = new ErrorEmiStack();
    }
}

