/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.ingredient;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.nolij.toomanyrecipeviewers.TooManyRecipeViewersMod;
import dev.nolij.toomanyrecipeviewers.impl.ingredient.ErrorEmiStack;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.builder.TMRVIngredientCollector;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.builder.TMRVTooltipBuilder;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.drawable.OffsetDrawable;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.ingredient.ITMRVRecipeSlotDrawable;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.ingredient.ITMRVSlotWidget;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.runtime.IngredientManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.gui.builder.IIngredientConsumer;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.common.util.ImmutableRect2i;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.Rect2i;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class TMRVSlotWidget
extends SlotWidget
implements ITMRVRecipeSlotDrawable,
ITMRVSlotWidget {
    private final IngredientManager ingredientManager;
    private final RecipeIngredientRole role;
    private ImmutableRect2i rect;
    private boolean visible = true;
    private final TMRVIngredientCollector ingredientCollector;
    @Nullable
    private TMRVIngredientCollector overrideIngredientCollector = null;
    @Nullable
    private String name = null;
    @Nullable
    private OffsetDrawable background = null;
    @Nullable
    private OffsetDrawable overlay = null;
    private final List<IRecipeSlotRichTooltipCallback> tooltipCallbacks = new ArrayList<IRecipeSlotRichTooltipCallback>();

    static void drawJEIBackground(@Nullable OffsetDrawable background, GuiGraphics draw, int x, int y) {
        if (background == null) {
            return;
        }
        background.draw(draw, x, y);
    }

    static void drawJEIOverlay(@Nullable OffsetDrawable overlay, GuiGraphics draw, int x, int y) {
        if (overlay == null) {
            return;
        }
        EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)draw);
        RenderSystem.enableBlend();
        context.push();
        context.matrices().translate(0.0f, 0.0f, 200.0f);
        overlay.draw(context.raw(), x, y);
        context.pop();
    }

    static void applyTooltipCallbacks(List<ClientTooltipComponent> list, List<IRecipeSlotRichTooltipCallback> tooltipCallbacks, IRecipeSlotView slotView) {
        TMRVTooltipBuilder builder = new TMRVTooltipBuilder(list);
        for (IRecipeSlotRichTooltipCallback tooltipCallback : tooltipCallbacks) {
            try {
                tooltipCallback.onRichTooltip(slotView, builder);
            }
            catch (Throwable t) {
                TooManyRecipeViewersMod.LOGGER.error("Error invoking JEI tooltip callback: ", t);
            }
        }
        list.clear();
        list.addAll(builder.getClientTooltipComponents());
    }

    public TMRVSlotWidget(IngredientManager ingredientManager, RecipeIngredientRole role, ImmutableRect2i rect, Map<IIngredientType<?>, IIngredientRenderer<?>> rendererOverrides) {
        super((EmiIngredient)ErrorEmiStack.INSTANCE, rect.x(), rect.y());
        this.ingredientManager = ingredientManager;
        this.role = role;
        this.rect = rect;
        this.ingredientCollector = new TMRVIngredientCollector(ingredientManager);
    }

    public TMRVSlotWidget(IngredientManager ingredientManager, RecipeIngredientRole role, ImmutableRect2i rect) {
        this(ingredientManager, role, rect, Map.of());
    }

    private TMRVIngredientCollector getActiveIngredientCollector() {
        return this.overrideIngredientCollector == null ? this.ingredientCollector : this.overrideIngredientCollector;
    }

    @Override
    public TMRVIngredientCollector getIngredientCollector() {
        return this.ingredientCollector;
    }

    @Override
    public void setName(@Nullable String name) {
        this.name = name;
    }

    @Override
    public void setBackground(@Nullable OffsetDrawable background) {
        this.background = background;
    }

    @Override
    public void setOverlay(@Nullable OffsetDrawable overlay) {
        this.overlay = overlay;
    }

    @Override
    public void addTooltipCallbacks(List<IRecipeSlotRichTooltipCallback> tooltipCallbacks) {
        this.tooltipCallbacks.addAll(tooltipCallbacks);
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void render(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        if (!this.visible) {
            return;
        }
        super.render(draw, mouseX, mouseY, delta);
    }

    public Bounds getBounds() {
        if (!this.visible) {
            return Bounds.EMPTY;
        }
        ImmutableRect2i rect = this.rect.expandBy(this.output ? 6 : 1);
        return new Bounds(rect.x(), rect.y(), rect.width(), rect.height());
    }

    public void drawBackground(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        TMRVSlotWidget.drawJEIBackground(this.background, draw, this.rect.x(), this.rect.y());
        super.drawBackground(draw, mouseX, mouseY, delta);
    }

    public void drawOverlay(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        TMRVSlotWidget.drawJEIOverlay(this.overlay, draw, this.rect.x(), this.rect.y());
        super.drawOverlay(draw, mouseX, mouseY, delta);
    }

    public EmiIngredient getStack() {
        return this.getActiveIngredientCollector().getEMIIngredient();
    }

    protected void addSlotTooltip(List<ClientTooltipComponent> list) {
        TMRVSlotWidget.applyTooltipCallbacks(list, this.tooltipCallbacks, this);
        super.addSlotTooltip(list);
    }

    @Override
    public IIngredientConsumer createDisplayOverrides() {
        if (this.overrideIngredientCollector == null) {
            this.overrideIngredientCollector = new TMRVIngredientCollector(this.ingredientManager);
        }
        return this.overrideIngredientCollector;
    }

    @Override
    public void clearDisplayOverrides() {
        this.overrideIngredientCollector = null;
    }

    @Override
    public Rect2i getRect() {
        return this.rect.toMutable();
    }

    @Override
    public void setPosition(int x, int y) {
        this.rect = new ImmutableRect2i(x, y, this.rect.width(), this.rect.height());
    }

    @Override
    public Stream<ITypedIngredient<?>> getAllIngredients() {
        return this.getActiveIngredientCollector().stream();
    }

    @Override
    public @Unmodifiable List<@Nullable ITypedIngredient<?>> getAllIngredientsList() {
        return this.getActiveIngredientCollector().getCollectedIngredients();
    }

    @Override
    public Optional<ITypedIngredient<?>> getDisplayedIngredient() {
        return this.getAllIngredients().findFirst();
    }

    @Override
    public RecipeIngredientRole getRole() {
        return this.role;
    }

    @Override
    public boolean isEmpty() {
        return this.getActiveIngredientCollector().isEmpty();
    }

    @Override
    public Optional<String> getSlotName() {
        return Optional.ofNullable(this.name);
    }
}

