/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.config.looTables;

import com.cozary.nameless_trinkets.NamelessTrinkets;
import com.cozary.nameless_trinkets.config.ConfigUtils;
import com.cozary.nameless_trinkets.config.TrinketConfigs;
import com.cozary.nameless_trinkets.config.looTables.TrinketDataProvider;
import com.cozary.nameless_trinkets.config.looTables.TrinketLootConfig;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class TrinketLootConfigsManager {
    private static final Path CONFIG_PATH = Path.of("config", "nameless_trinkets", "trinket_loot_configs");
    private static List<TrinketLootConfig> configs = new ArrayList<TrinketLootConfig>();

    public static List<TrinketLootConfig> getConfigs() {
        return configs;
    }

    public static void loadConfigs() {
        try {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
            configs.clear();
            HashSet<String> loadedItemIds = new HashSet<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(CONFIG_PATH, "*.json");){
                for (Path path : stream) {
                    TrinketLootConfig config = (TrinketLootConfig)ConfigUtils.readConfig(path, TrinketLootConfig.class);
                    configs.add(config);
                    loadedItemIds.add(config.getItemId());
                }
            }
            List<ResourceLocation> defaultLootTables = TrinketDataProvider.LOOT_TABLES.stream().map(ResourceKey::location).toList();
            boolean missingConfigs = false;
            for (List<Object> entry : TrinketDataProvider.getTrinketList()) {
                double chance = (Double)entry.get(0);
                Item item = (Item)entry.get(1);
                String itemName = TrinketConfigs.getItemName((TrinketItem)item);
                if (loadedItemIds.contains(itemName)) continue;
                TrinketLootConfig newConfig = new TrinketLootConfig(itemName, chance, defaultLootTables);
                configs.add(newConfig);
                missingConfigs = true;
            }
            if (missingConfigs) {
                TrinketLootConfigsManager.saveConfigs();
            }
        }
        catch (Exception e) {
            NamelessTrinkets.LOG.error("Failed to load TrinketLootConfigs, generating defaults.", (Throwable)e);
            TrinketLootConfigsManager.backupCorruptedConfigs();
            TrinketLootConfigsManager.generateDefaultConfigs();
            TrinketLootConfigsManager.saveConfigs();
        }
    }

    public static void saveConfigs() {
        try {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
            for (TrinketLootConfig config : configs) {
                String fileName = config.getItemId().replace(":", "_") + ".json";
                Path filePath = CONFIG_PATH.resolve(fileName);
                ConfigUtils.writeConfig(filePath, config);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save TrinketLootConfigs", e);
        }
    }

    private static void generateDefaultConfigs() {
        configs.clear();
        List<ResourceLocation> defaultLootTables = TrinketDataProvider.LOOT_TABLES.stream().map(ResourceKey::location).toList();
        TrinketDataProvider.getTrinketList().forEach(entry -> {
            double chance = (Double)entry.get(0);
            Item item = (Item)entry.get(1);
            String itemName = TrinketConfigs.getItemName((TrinketItem)item);
            configs.add(new TrinketLootConfig(itemName, chance, defaultLootTables));
        });
    }

    private static void backupCorruptedConfigs() {
        block9: {
            try {
                if (!Files.exists(CONFIG_PATH, new LinkOption[0])) break block9;
                String timestamp = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss").format(new Date());
                Path backupDir = CONFIG_PATH.getParent().resolve("backups").resolve(timestamp);
                Files.createDirectories(backupDir, new FileAttribute[0]);
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(CONFIG_PATH, "*.json");){
                    for (Path path : stream) {
                        Files.move(path, backupDir.resolve(path.getFileName()), new CopyOption[0]);
                    }
                }
            }
            catch (IOException e) {
                NamelessTrinkets.LOG.error("Failed to backup corrupted config files.", (Throwable)e);
            }
        }
    }
}

