/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.events.BlazeNucleusHandler;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.util.TrinketUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class BlazeNucleusEvents {
    @SubscribeEvent
    public static void setFireEntity(LivingDamageEvent.Pre event) {
        Entity src = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        if (!(src instanceof Player)) {
            return;
        }
        Player player = (Player)src;
        ItemStack stack = TrinketUtils.getEquippedTrinket(player, ModItems.BLAZE_NUCLEUS.get());
        if (stack.isEmpty()) {
            return;
        }
        float modified = BlazeNucleusHandler.onAttackerHit(src, (Entity)target, event.getOriginalDamage());
        event.setNewDamage(modified);
    }

    @SubscribeEvent
    public static void blazeNucleusImmune(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = TrinketUtils.getEquippedTrinket(player, ModItems.BLAZE_NUCLEUS.get());
            if (stack.isEmpty()) {
                return;
            }
            float modified = BlazeNucleusHandler.onPlayerHurt(player, event.getSource(), event.getOriginalDamage());
            event.setNewDamage(modified);
        }
    }
}

