/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.items.trinkets.BlazeNucleusBase;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class BlazeNucleusHandler {
    public static float onAttackerHit(Entity attacker, Entity target, float originalAmount) {
        BlazeNucleusBase.Stats config = (BlazeNucleusBase.Stats)BlazeNucleusBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable || !(attacker instanceof Player)) {
            return originalAmount;
        }
        Player player = (Player)attacker;
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            livingTarget.setRemainingFireTicks(config.setEnemyInFireTicks);
        }
        player.clearFire();
        return originalAmount;
    }

    public static float onPlayerHurt(Player player, DamageSource source, float originalAmount) {
        BlazeNucleusBase.Stats config = (BlazeNucleusBase.Stats)BlazeNucleusBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable || player.isSpectator()) {
            return originalAmount;
        }
        if (config.fireDamageReductionPercentage < 100.0f) {
            boolean isFireDamage;
            boolean bl = isFireDamage = source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypes.LAVA) || source.is(DamageTypes.ON_FIRE) || source.is(DamageTypes.IN_FIRE) || source.is(DamageTypes.HOT_FLOOR);
            if (isFireDamage) {
                return originalAmount * (1.0f - config.fireDamageReductionPercentage / 100.0f);
            }
        }
        return originalAmount;
    }
}

