/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.events.BrokenAnkhHandler;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.util.TrinketUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class BrokenAnkhEvents {
    @SubscribeEvent
    public static void stopDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = TrinketUtils.getEquippedTrinket(player, ModItems.BROKEN_ANKH.get());
            if (stack.isEmpty()) {
                return;
            }
            if (BrokenAnkhHandler.tryPreventDeath(player, stack.getItem())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack stack = TrinketUtils.getEquippedTrinket((Player)player2, ModItems.BROKEN_ANKH.get());
            if (stack.isEmpty()) {
                return;
            }
            BrokenAnkhHandler.restoreCooldownOnLogin(player2, stack.getItem());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemStack stack = TrinketUtils.getEquippedTrinket((Player)player2, ModItems.BROKEN_ANKH.get());
            if (stack.isEmpty()) {
                return;
            }
            BrokenAnkhHandler.saveCooldownOnLogout(player2, stack.getItem());
        }
    }
}

