/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.items.trinkets.BrokenAnkhBase;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class BrokenAnkhHandler {
    private static final BrokenAnkhBase.Stats config = (BrokenAnkhBase.Stats)BrokenAnkhBase.INSTANCE.getTrinketConfig();

    public static boolean tryPreventDeath(Player player, Item stack) {
        if (!BrokenAnkhHandler.config.isEnable || player.isSpectator() || player.level().isClientSide) {
            return false;
        }
        if (player.isDeadOrDying() && !player.getCooldowns().isOnCooldown(stack)) {
            ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
            level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, player.getX(), player.getY(), player.getZ(), 100, 1.0, 1.0, 1.0, 0.1);
            level.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, player.getX(), player.getY(), player.getZ(), 50, 1.0, 1.0, 1.0, 0.1);
            level.sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, player.getX(), player.getY(), player.getZ(), 100, 1.0, 1.0, 1.0, 0.1);
            player.setHealth(2.0f);
            player.removeAllEffects();
            player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            player.getCooldowns().addCooldown(stack, BrokenAnkhHandler.config.cooldown);
            return true;
        }
        return false;
    }

    public static void restoreCooldownOnLogin(ServerPlayer player, Item stack) {
        player.getCooldowns().addCooldown(stack, BrokenAnkhBase.getCooldown(stack.getDefaultInstance()));
    }

    public static void saveCooldownOnLogout(ServerPlayer player, Item stack) {
        if (!BrokenAnkhHandler.config.isEnable) {
            return;
        }
        BrokenAnkhBase.setCooldown(stack.getDefaultInstance(), (int)(player.getCooldowns().getCooldownPercent(stack, 0.0f) * (float)BrokenAnkhHandler.config.cooldown));
    }
}

