/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.items.trinkets.MinersSoulBase;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class MinersSoulHandler {
    public static void playerBreakBlock(Player player, BlockState state, BlockPos pos, Level level) {
        MinersSoulBase.Stats config = (MinersSoulBase.Stats)MinersSoulBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable || level.isClientSide || player == null || player.isSpectator()) {
            return;
        }
        ItemStack itemStack = player.getMainHandItem();
        ItemStack fakeItemStack = new ItemStack((ItemLike)itemStack.getItem());
        ItemEnchantments enchantments = (ItemEnchantments)itemStack.get(DataComponents.ENCHANTMENTS);
        RegistryAccess registries = level.registryAccess();
        HolderLookup.RegistryLookup enchantmentRegistry = registries.lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference silkTouch = enchantmentRegistry.getOrThrow(Enchantments.SILK_TOUCH);
        Holder.Reference fortune = enchantmentRegistry.getOrThrow(Enchantments.FORTUNE);
        if (enchantments != null && enchantments.getLevel((Holder)silkTouch) > 0) {
            return;
        }
        int bonusLevel = enchantments != null ? enchantments.getLevel((Holder)fortune) : 0;
        ItemEnchantments.Mutable mutableEnchantments = new ItemEnchantments.Mutable(enchantments != null ? enchantments : ItemEnchantments.EMPTY);
        mutableEnchantments.upgrade((Holder)fortune, bonusLevel + config.extraLootingLevel);
        fakeItemStack.set(DataComponents.ENCHANTMENTS, (Object)mutableEnchantments.toImmutable());
        if (!(state.getBlock() instanceof EntityBlock)) {
            ObjectArrayList drops;
            LootTable loot = level.getServer().reloadableRegistries().getLootTable(state.getBlock().getLootTable());
            LootParams.Builder contextBuilder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)fakeItemStack).withParameter(LootContextParams.BLOCK_STATE, (Object)state);
            if (player != null) {
                contextBuilder.withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player);
            }
            if (!(drops = loot.getRandomItems(contextBuilder.create(LootContextParamSets.BLOCK))).isEmpty()) {
                ((ItemStack)drops.get(0)).setCount(((ItemStack)drops.get(0)).getCount() - 1);
            }
            for (ItemStack drop : drops) {
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), drop);
                itemEntity.setDefaultPickUpDelay();
                itemEntity.setPos(Vec3.atCenterOf((Vec3i)pos));
                itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)((level.random.nextFloat() - level.random.nextFloat()) * 0.1f), (double)(level.random.nextFloat() * 0.05f), (double)((level.random.nextFloat() - level.random.nextFloat()) * 0.1f)));
                level.addFreshEntity((Entity)itemEntity);
            }
        }
    }
}

