/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.init.ModDataComponents;
import com.cozary.nameless_trinkets.items.trinkets.RageMindBase;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class RageMindHandler {
    public static void getEntity(Player player, LivingEntity livingEntity, Item stack) {
        RageMindBase.Stats config = (RageMindBase.Stats)RageMindBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        EntityType entityType = livingEntity.getType();
        String entityKey = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType).toString();
        stack.getDefaultInstance().set(ModDataComponents.RAGE_MIND_REVENGE_TARGET.get(), (Object)entityKey);
    }

    public static float dealDamage(Player player, Entity targetEntity, float originalAmount, Item stack) {
        RageMindBase.Stats config = (RageMindBase.Stats)RageMindBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return originalAmount;
        }
        if (stack.getDefaultInstance().get(ModDataComponents.RAGE_MIND_REVENGE_TARGET.get()) != null) {
            String entityString = (String)stack.getDefaultInstance().get(ModDataComponents.RAGE_MIND_REVENGE_TARGET.get());
            ResourceLocation resourceLocation = ResourceLocation.parse((String)entityString);
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation);
            Entity entity = entityType.create(player.level());
            if (entity == null) {
                return originalAmount;
            }
            Class<?> classEntity = entity.getClass();
            if (targetEntity == null) {
                return originalAmount;
            }
            if (targetEntity.getClass() == classEntity) {
                return originalAmount * (config.damageMultiplierPercentage / 100.0f);
            }
        }
        return originalAmount;
    }
}

