/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.events;

import com.cozary.nameless_trinkets.events.SigilOfBaphometHandler;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.util.TrinketUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class SigilOfBaphometEvents {
    @SubscribeEvent
    public static void handleSigilKillCount(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = TrinketUtils.getEquippedTrinket(player, ModItems.SIGIL_OF_BAPHOMET.get());
            if (stack.isEmpty()) {
                return;
            }
            SigilOfBaphometHandler.handleSigilKillCount(player, stack.getItem());
        }
    }

    @SubscribeEvent
    public static void grantSigilImmunityOnDamage(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack stack = TrinketUtils.getEquippedTrinket(player, ModItems.SIGIL_OF_BAPHOMET.get());
            if (stack.isEmpty()) {
                return;
            }
            event.setCanceled(SigilOfBaphometHandler.grantSigilImmunityOnDamage(player, stack.getItem()));
        }
    }
}

