/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.special;

import com.cozary.nameless_trinkets.init.ModTags;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysteriousTrinket
extends Item {
    public MysteriousTrinket() {
        super(new Item.Properties().rarity(Rarity.EPIC).stacksTo(64));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Random random = new Random();
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WOOL_BREAK, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            List trinketItems = BuiltInRegistries.ITEM.getOrCreateTag(ModTags.NAMELESS_TRINKETS_TAG).stream().toList();
            Item selectedTrinket = (Item)((Holder)trinketItems.get(random.nextInt(trinketItems.size()))).value();
            BlockPos playerPos = player.getOnPos();
            if (selectedTrinket != null) {
                ServerLevel serverLevel = (ServerLevel)player.getCommandSenderWorld();
                this.spawnParticles(serverLevel, player);
                this.spawnItemEntity((Level)serverLevel, selectedTrinket, playerPos);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    private void spawnParticles(ServerLevel serverLevel, Player player) {
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.WITCH, player.getX(), player.getY(), player.getZ(), 100, 1.0, 1.0, 1.0, 0.1);
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, player.getX(), player.getY(), player.getZ(), 100, 1.0, 1.0, 1.0, 0.1);
    }

    private void spawnItemEntity(Level level, Item trinketItem, BlockPos pos) {
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), trinketItem.getDefaultInstance());
        itemEntity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)itemEntity);
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.mysterious_trinket_1").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.mysterious_trinket_2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }
}

