/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.special;

import com.cozary.nameless_trinkets.init.ModDataComponents;
import com.cozary.nameless_trinkets.utils.TrinketBundleContents;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class TrinketBundle
extends BundleItem {
    private static final int BAR_COLOR = Mth.color((float)1.0f, (float)0.4f, (float)0.4f);

    public TrinketBundle() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.RARE).component(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get(), (Object)TrinketBundleContents.EMPTY));
    }

    private static boolean dropContents(ItemStack itemStack, Player player) {
        TrinketBundleContents bundlecontents = (TrinketBundleContents)((Object)itemStack.get(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get()));
        if (bundlecontents != null && !bundlecontents.isEmpty()) {
            itemStack.set(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get(), (Object)TrinketBundleContents.EMPTY);
            if (player instanceof ServerPlayer) {
                bundlecontents.itemsCopy().forEach(p_327106_ -> player.drop(p_327106_, true));
            }
            return true;
        }
        return false;
    }

    public boolean overrideStackedOnOther(ItemStack itemStack, Slot slot, ClickAction clickAction, Player player) {
        if (clickAction == ClickAction.SECONDARY) {
            int i;
            TrinketBundleContents bundlecontents = (TrinketBundleContents)((Object)itemStack.get(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get()));
            if (bundlecontents == null) {
                return false;
            }
            ItemStack itemstack = slot.getItem();
            TrinketBundleContents.Mutable bundlecontents$mutable = new TrinketBundleContents.Mutable(bundlecontents);
            if (itemstack.isEmpty()) {
                this.playRemoveOneSound((Entity)player);
                ItemStack itemstack1 = bundlecontents$mutable.removeOne();
                if (itemstack1 != null) {
                    ItemStack itemstack2 = slot.safeInsert(itemstack1);
                    bundlecontents$mutable.tryInsert(itemstack2);
                }
            } else if (itemstack.getItem().canFitInsideContainerItems() && (i = bundlecontents$mutable.tryTransfer(slot, player)) > 0) {
                this.playInsertSound((Entity)player);
            }
            itemStack.set(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get(), (Object)bundlecontents$mutable.toImmutable());
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack itemStack, ItemStack other, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (clickAction == ClickAction.SECONDARY && slot.allowModification(player)) {
            TrinketBundleContents bundlecontents = (TrinketBundleContents)((Object)itemStack.get(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get()));
            if (bundlecontents == null) {
                return false;
            }
            TrinketBundleContents.Mutable bundlecontents$mutable = new TrinketBundleContents.Mutable(bundlecontents);
            if (other.isEmpty()) {
                ItemStack itemstack = bundlecontents$mutable.removeOne();
                if (itemstack != null) {
                    this.playRemoveOneSound((Entity)player);
                    slotAccess.set(itemstack);
                }
            } else {
                int i = bundlecontents$mutable.tryInsert(other);
                if (i > 0) {
                    this.playInsertSound((Entity)player);
                }
            }
            itemStack.set(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get(), (Object)bundlecontents$mutable.toImmutable());
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        if (TrinketBundle.dropContents(itemstack, player)) {
            this.playDropContentsSound((Entity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public boolean isBarVisible(ItemStack itemStack) {
        TrinketBundleContents bundlecontents = (TrinketBundleContents)((Object)itemStack.getOrDefault(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get(), (Object)TrinketBundleContents.EMPTY));
        return bundlecontents.weight().compareTo(Fraction.ZERO) > 0;
    }

    public int getBarWidth(ItemStack itemStack) {
        TrinketBundleContents bundlecontents = (TrinketBundleContents)((Object)itemStack.getOrDefault(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get(), (Object)TrinketBundleContents.EMPTY));
        return (int)Math.min(bundlecontents.weight().doubleValue() * 64.0 * 0.203125, 13.0);
    }

    public int getBarColor(ItemStack itemStack) {
        return BAR_COLOR;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        TrinketBundleContents bundlecontents = (TrinketBundleContents)((Object)itemStack.get(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get()));
        if (bundlecontents != null) {
            int i = Mth.mulAndTruncate((Fraction)bundlecontents.weight(), (int)64);
            tooltipComponents.add((Component)Component.translatable((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{i, 64}).withStyle(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack itemStack) {
        return !itemStack.has(DataComponents.HIDE_TOOLTIP) && !itemStack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((TrinketBundleContents)((Object)itemStack.get(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get()))).map(BundleTooltip::new) : Optional.empty();
    }

    public void onDestroyed(ItemEntity itemEntity) {
        TrinketBundleContents bundlecontents = (TrinketBundleContents)((Object)itemEntity.getItem().get(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get()));
        if (bundlecontents != null) {
            itemEntity.getItem().set(ModDataComponents.TRINKET_BUNDLE_CONTENTS.get(), (Object)TrinketBundleContents.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, bundlecontents.itemsCopy());
        }
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }
}

