/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.trinkets.CrackedCrownBase;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CrackedCrown
extends CrackedCrownBase
implements ICurioItem {
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        CrackedCrownBase.Stats config = (CrackedCrownBase.Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.getCommandSenderWorld();
        if (world.isClientSide()) {
            return;
        }
        this.applyModifiers(livingEntity, config);
    }

    @Override
    protected void applyModifiers(LivingEntity livingEntity, CrackedCrownBase.Stats config) {
        for (Map.Entry entry : this.modifiers.entrySet()) {
            for (String key : (List)entry.getValue()) {
                AttributeInstance attribute = this.getAttribute(livingEntity, key);
                if (attribute == null) continue;
                ResourceLocation modifierData = ResourceLocation.fromNamespaceAndPath((String)((String)entry.getKey()), (String)key);
                AttributeModifier modifier = this.createAttributeModifier(modifierData, config, key);
                EntityUtils.applyAttributeModifier(attribute, modifier);
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        CrackedCrownBase.Stats config = (CrackedCrownBase.Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        this.removeModifiers(slotContext.entity(), config);
    }

    @Override
    protected void removeModifiers(LivingEntity wearer, CrackedCrownBase.Stats config) {
        for (Map.Entry entry : this.modifiers.entrySet()) {
            for (String key : (List)entry.getValue()) {
                AttributeInstance attribute = this.getAttribute(wearer, key);
                if (attribute == null) continue;
                ResourceLocation modifierData = ResourceLocation.fromNamespaceAndPath((String)((String)entry.getKey()), (String)key);
                AttributeModifier modifier = this.createAttributeModifier(modifierData, config, key);
                EntityUtils.removeAttributeModifier(attribute, modifier);
            }
        }
    }
}

