/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.trinkets.CreeperSenseBase;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CreeperSense
extends CreeperSenseBase
implements ICurioItem {
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        ServerPlayer player;
        CreeperSenseBase.Stats config = (CreeperSenseBase.Stats)CreeperSenseBase.INSTANCE.getTrinketConfig();
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof ServerPlayer) || (player = (ServerPlayer)livingEntity).isSpectator()) {
            return;
        }
        if (!config.isEnable) {
            return;
        }
        BlockPos posAbove = player.blockPosition().above().above();
        BlockState blockAbove = player.level().getBlockState(posAbove);
        if (player.getCooldowns().isOnCooldown(stack.getItem())) {
            return;
        }
        if (blockAbove.isAir() && player.isCrouching()) {
            player.getCooldowns().addCooldown(stack.getItem(), config.cooldownInTicks);
            player.level().explode(null, player.getX(), player.getY(), player.getZ(), config.explosionLevel, Level.ExplosionInteraction.NONE);
            player.setShiftKeyDown(false);
        }
    }
}

