/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.trinkets.DragonsEyeBase;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class DragonsEye
extends DragonsEyeBase
implements ICurioItem {
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        DragonsEyeBase.Stats config = (DragonsEyeBase.Stats)DragonsEyeBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable || !((livingEntity = slotContext.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (config.blindness) {
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 120, 1));
        }
        Level world = player.level();
        List entities = world.getEntitiesOfClass(Mob.class, player.getBoundingBox().inflate((double)config.radius));
        Scoreboard scoreboard = player.getScoreboard();
        PlayerTeam playerTeam = scoreboard.getPlayerTeam("dragonsEyeTargets");
        if (playerTeam == null) {
            playerTeam = scoreboard.addPlayerTeam("dragonsEyeTargets");
            playerTeam.setColor(ChatFormatting.LIGHT_PURPLE);
        }
        for (Mob entity : entities) {
            if (!entity.shouldDespawnInPeaceful() && entity.getSoundSource() != SoundSource.HOSTILE && !entity.isAggressive()) continue;
            entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 20, 30));
            scoreboard.addPlayerToTeam(entity.getStringUUID(), playerTeam);
        }
    }
}

