/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.trinkets.DyingStarBase;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class DyingStar
extends DyingStarBase
implements ICurioItem {
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        DyingStarBase.Stats config = (DyingStarBase.Stats)DyingStarBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.getCommandSenderWorld();
        if (world.isClientSide()) {
            return;
        }
        for (int i = 0; i < DyingStarBase.AttributeSelector.values().length; ++i) {
            DyingStarBase.AttributeSelector attributeSelector = DyingStarBase.AttributeSelector.values()[i];
            float attributeIncrement = ((Float)stack.getOrDefault(attributeSelector.getDataComponentType(), (Object)Float.valueOf(0.0f))).floatValue();
            if (!(attributeIncrement > 0.0f)) continue;
            AttributeInstance attributeDamage = livingEntity.getAttribute(attributeSelector.getAttributeHolder());
            AttributeModifier attributeModifier = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)("dying_star_" + attributeSelector.getAttributeHolder().getRegisteredName().replace(".", "_").replace(":", "_"))), (double)attributeIncrement, AttributeModifier.Operation.ADD_VALUE);
            if (attributeDamage == null || attributeModifier == null) continue;
            EntityUtils.applyAttributeModifier(attributeDamage, attributeModifier);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        for (int i = 0; i < DyingStarBase.AttributeSelector.values().length; ++i) {
            DyingStarBase.AttributeSelector attributeSelector = DyingStarBase.AttributeSelector.values()[i];
            float attributeIncrement = ((Float)stack.getOrDefault(attributeSelector.getDataComponentType(), (Object)Float.valueOf(0.0f))).floatValue();
            if (!(attributeIncrement > 0.0f)) continue;
            AttributeInstance attributeDamage = slotContext.entity().getAttribute(attributeSelector.getAttributeHolder());
            AttributeModifier attributeModifier = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)("dying_star_" + attributeSelector.getAttributeHolder().getRegisteredName().replace(".", "_").replace(":", "_"))), (double)attributeIncrement, AttributeModifier.Operation.ADD_VALUE);
            if (attributeDamage == null || attributeModifier == null) continue;
            EntityUtils.removeAttributeModifier(attributeDamage, attributeModifier);
        }
    }
}

