/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class FateEmeraldBase
extends TrinketItem<Stats> {
    public static FateEmeraldBase INSTANCE;

    public FateEmeraldBase() {
        super(new TrinketData(null, null, Stats.class));
        INSTANCE = this;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.isDisabled").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fate_emerald_lore").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fate_emerald_1").withStyle(ChatFormatting.GOLD));
                String formattedSeconds = String.format("%.2f", (double)config.timeUntilUnequip / 20.0);
                String formattedHunger = String.format("%.2f", Float.valueOf(config.hungerExhaustionRate));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fate_emerald_2", (Object[])new Object[]{formattedSeconds}).withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fate_emerald_3", (Object[])new Object[]{formattedHunger}).withStyle(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public int discountBoost = 100;
        public float timeUntilUnequip = 1200.0f;
        public float hungerExhaustionRate = 0.1f;
        public boolean isEnable = true;
        float backupTimeUntilUnequip = 0.0f;
        boolean resetTimerFlag = false;
    }
}

