/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FertilizerBase
extends TrinketItem<Stats> {
    public static FertilizerBase INSTANCE;

    public FertilizerBase() {
        super(new TrinketData(null, null, Stats.class));
        INSTANCE = this;
    }

    public static boolean growWaterPlant(Level level, BlockPos pos, @Nullable Direction clickedSide) {
        if (!level.getBlockState(pos).is(Blocks.WATER) || level.getFluidState(pos).getAmount() != 8) {
            return false;
        }
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RandomSource random = level.getRandom();
        boolean success = false;
        for (int i = 0; i < 128; ++i) {
            BlockPos currentPos = pos;
            for (int j = 0; j < i / 16 && (level.getBlockState(currentPos = currentPos.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).is(Blocks.WATER) || level.getBlockState(currentPos).is(Blocks.KELP) || level.getBlockState(currentPos).is(Blocks.KELP_PLANT)); ++j) {
            }
            BlockState state = level.getBlockState(currentPos);
            if (state.is(Blocks.KELP) || state.is(Blocks.KELP_PLANT)) {
                FertilizerBase.growKelp(level, currentPos);
                success = true;
                continue;
            }
            if (!state.is(Blocks.WATER) || level.getFluidState(currentPos).getAmount() != 8 || !FertilizerBase.applyBiomeModifiers(level, currentPos, random, clickedSide, Blocks.SEAGRASS.defaultBlockState())) continue;
            success = true;
        }
        return success;
    }

    private static boolean applyBiomeModifiers(Level level, BlockPos pos, RandomSource random, @Nullable Direction clickedSide, BlockState newState) {
        Holder biome = level.getBiome(pos);
        if (biome.is(BiomeTags.PRODUCES_CORALS_FROM_BONEMEAL) && random.nextInt(4) == 0) {
            newState = BuiltInRegistries.BLOCK.getRandomElementOf(BlockTags.UNDERWATER_BONEMEALS, random).map(block -> ((Block)block.value()).defaultBlockState()).orElse(newState);
        }
        if (newState.canSurvive((LevelReader)level, pos)) {
            level.setBlock(pos, newState, 3);
            return true;
        }
        return false;
    }

    private static void growKelp(Level level, BlockPos pos) {
        BlockPos abovePos = pos.above();
        if (level.getBlockState(abovePos).is(Blocks.WATER) && level.getFluidState(abovePos).getAmount() == 8) {
            level.setBlock(abovePos, Blocks.KELP_PLANT.defaultBlockState(), 3);
        }
    }

    static boolean applyBonemeal(Level level, BlockPos pos) {
        BonemealableBlock bonemealable;
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, pos, blockState) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (bonemealable.isBonemealSuccess(level, level.random, pos, blockState)) {
                bonemealable.performBonemeal(serverLevel, level.random, pos, blockState);
                return true;
            }
        }
        return false;
    }

    static void spawnGrowthParticles(LevelAccessor level, BlockPos pos, int count) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, count, 0.25, 0.25, 0.25, 0.05);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Stats config = (Stats)INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.isDisabled").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fertilizer_lore").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fertilizer_1").withStyle(ChatFormatting.GOLD));
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.fertilizer_2", (Object[])new Object[]{config.effectIntervalInTicks / 20}).withStyle(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public int effectIntervalInTicks = 100;
        public boolean isEnable = true;
    }
}

