/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.trinkets.FragileCloudBase;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class FragileCloud
extends FragileCloudBase
implements ICurioItem {
    private static final AttributeModifier SLOW_FALLING = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"slow_falling"), -0.07, AttributeModifier.Operation.ADD_VALUE);

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        FragileCloudBase.Stats config = (FragileCloudBase.Stats)FragileCloudBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!player.level().isClientSide && !player.isSpectator()) {
            boolean stack0 = true;
            boolean stack1 = true;
            AttributeInstance gravity = player.getAttribute(Attributes.GRAVITY);
            if (!stack0 && stack1) {
                if (!(player.isFallFlying() || player.onGround() || player.isInWater())) {
                    assert (gravity != null);
                    if (!gravity.hasModifier(SLOW_FALLING.id()) && player.getDeltaMovement().y < -0.3) {
                        gravity.addPermanentModifier(SLOW_FALLING);
                    }
                    player.resetFallDistance();
                    if (gravity.hasModifier(SLOW_FALLING.id())) {
                        double particleX = player.getX() + (double)(player.getRandom().nextBoolean() ? -1 : 1) * Math.pow(player.getRandom().nextFloat(), 1.0) * 1.0;
                        double particleY = player.getY() + (double)(player.getRandom().nextFloat() * 1.0f) - 2.0;
                        double particleZ = player.getZ() + (double)(player.getRandom().nextBoolean() ? -1 : 1) * Math.pow(player.getRandom().nextFloat(), 1.0) * 1.0;
                        ((ServerLevel)player.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, particleX, particleY, particleZ, 1, 1.0, 1.0, 1.0, 0.1);
                    }
                } else {
                    assert (gravity != null);
                    if (gravity.hasModifier(SLOW_FALLING.id())) {
                        gravity.removeModifier(SLOW_FALLING);
                    }
                }
            } else {
                assert (gravity != null);
                if (gravity.hasModifier(SLOW_FALLING.id())) {
                    gravity.removeModifier(SLOW_FALLING);
                }
            }
        }
    }
}

