/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.trinkets.IceCubeBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class IceCube
extends IceCubeBase
implements ICurioItem {
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        IceCubeBase.Stats config = (IceCubeBase.Stats)IceCubeBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        if (!(player instanceof ServerPlayer) || player.isSpectator() || player.level().isClientSide) {
            return;
        }
        Level world = player.level();
        BlockPos pos = player.blockPosition();
        if (player.onGround()) {
            BlockState blockstate = Blocks.FROSTED_ICE.defaultBlockState();
            float radius = Math.min(16, 2 + config.frostWalkerLevel);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset((int)(-radius), -1, (int)(-radius)), (BlockPos)pos.offset((int)radius, -1, (int)radius))) {
                boolean isFullWaterBlock;
                if (!blockPos.closerToCenterThan((Position)player.position(), (double)radius)) continue;
                mutablePos.set(blockPos.getX(), blockPos.getY() + 1, blockPos.getZ());
                BlockState aboveBlockState = world.getBlockState((BlockPos)mutablePos);
                if (!aboveBlockState.isAir()) continue;
                BlockState belowBlockState = world.getBlockState(blockPos);
                boolean bl = isFullWaterBlock = belowBlockState.getBlock() == Blocks.WATER && (Integer)belowBlockState.getValue((Property)LiquidBlock.LEVEL) == 0;
                if (belowBlockState != FrostedIceBlock.meltsInto() || !isFullWaterBlock || !blockstate.canSurvive((LevelReader)world, blockPos) || !world.isUnobstructed(blockstate, blockPos, CollisionContext.empty())) continue;
                world.setBlockAndUpdate(blockPos, blockstate);
                world.scheduleTick(blockPos, Blocks.FROSTED_ICE, Mth.nextInt((RandomSource)player.getRandom(), (int)60, (int)120));
            }
            BlockState iceBlock = Blocks.ICE.defaultBlockState();
            ((ServerLevel)world).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, iceBlock), player.getX(), player.getY(), player.getZ(), 1, 0.5, 1.0, 0.5, 0.1);
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }
}

