/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModDataComponents;
import com.cozary.nameless_trinkets.items.trinkets.RageMindBase;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class RageMind
extends RageMindBase
implements ICurioItem {
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        RageMindBase.Stats config = (RageMindBase.Stats)RageMindBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide) {
            return;
        }
        if (stack.get(ModDataComponents.RAGE_MIND_REVENGE_TARGET.get()) != null) {
            String entityString = (String)stack.get(ModDataComponents.RAGE_MIND_REVENGE_TARGET.get());
            ResourceLocation resourceLocation = ResourceLocation.parse((String)entityString);
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(resourceLocation);
            Entity entity = entityType.create(player.level());
            if (entity == null) {
                return;
            }
            Class<?> classEntity = entity.getClass();
            AABB targetBox = new AABB(player.position(), player.position()).inflate((double)config.range);
            List foundTarget = player.level().getEntitiesOfClass(classEntity, targetBox);
            Scoreboard scoreboard = player.getScoreboard();
            PlayerTeam playerTeam = scoreboard.getPlayerTeam("rageMindRevengeTargets");
            if (playerTeam == null) {
                playerTeam = scoreboard.addPlayerTeam("rageMindRevengeTargets");
                playerTeam.setColor(ChatFormatting.DARK_RED);
            }
            if (!foundTarget.isEmpty()) {
                for (Entity revengeTarget : foundTarget) {
                    if (!(revengeTarget instanceof LivingEntity)) continue;
                    LivingEntity livingRevengeTarget = (LivingEntity)revengeTarget;
                    MobEffectInstance effectinstance = new MobEffectInstance(MobEffects.GLOWING, 20, 20);
                    scoreboard.addPlayerToTeam(entity.getStringUUID(), playerTeam);
                    livingRevengeTarget.addEffect(effectinstance);
                }
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }
}

