/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.trinkets.ScarabAmuletBase;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ScarabAmulet
extends ScarabAmuletBase
implements ICurioItem {
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        ScarabAmuletBase.Stats config = (ScarabAmuletBase.Stats)ScarabAmuletBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.getCommandSenderWorld();
        if (world.isClientSide()) {
            return;
        }
        AttributeInstance attribSpeed = livingEntity.getAttribute(Attributes.MOVEMENT_SPEED);
        AttributeModifier speedModifier = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"scarab_amulet_movement_speed"), (double)(config.speedMultiplierPercentage / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        assert (attribSpeed != null);
        if (livingEntity.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement(livingEntity)).is(BlockTags.SAND)) {
            EntityUtils.applyAttributeModifier(attribSpeed, speedModifier);
        } else {
            EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.entity().getAttribute(Attributes.MOVEMENT_SPEED)), new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"scarab_amulet_movement_speed"), (double)(config.speedMultiplierPercentage / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack pstack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.entity().getAttribute(Attributes.MOVEMENT_SPEED)), new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"scarab_amulet_movement_speed"), (double)(((ScarabAmuletBase.Stats)this.trinketConfig).speedMultiplierPercentage / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    }
}

