/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.trinkets.ShrinkingVeilBase;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ShrinkingVeil
extends ShrinkingVeilBase
implements ICurioItem {
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void onEquip(SlotContext slotContext, ItemStack pstack, ItemStack stack) {
        ShrinkingVeilBase.Stats config = (ShrinkingVeilBase.Stats)ShrinkingVeilBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.getCommandSenderWorld();
        if (world.isClientSide()) {
            return;
        }
        AttributeInstance attribScale = livingEntity.getAttribute(Attributes.SCALE);
        AttributeModifier scaleModifier = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"shrinking_veil_scale"), (double)(-config.shrinkScalePercentage / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        assert (attribScale != null);
        EntityUtils.applyAttributeModifier(attribScale, scaleModifier);
        AttributeInstance attribSpeed = livingEntity.getAttribute(Attributes.MOVEMENT_SPEED);
        AttributeModifier speedModifier = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"shrinking_veil_speed"), (double)(((ShrinkingVeilBase.Stats)this.trinketConfig).speedPercentage / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        assert (attribSpeed != null);
        EntityUtils.applyAttributeModifier(attribSpeed, speedModifier);
    }

    public void onUnequip(SlotContext slotContext, ItemStack pstack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(livingEntity.getAttribute(Attributes.SCALE)), new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"shrinking_veil_scale"), (double)(-((ShrinkingVeilBase.Stats)this.trinketConfig).shrinkScalePercentage / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)), new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"shrinking_veil_speed"), (double)(((ShrinkingVeilBase.Stats)this.trinketConfig).speedPercentage / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    }
}

