/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.trinkets.SleepingPillsBase;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class SleepingPills
extends SleepingPillsBase
implements ICurioItem {
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        SleepingPillsBase.Stats config = (SleepingPillsBase.Stats)SleepingPillsBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (!livingEntity.isSpectator() && !stack.isEmpty()) {
            List list;
            if (!livingEntity.hasEffect(MobEffects.NIGHT_VISION) || Objects.requireNonNull(livingEntity.getEffect(MobEffects.NIGHT_VISION)).getDuration() < 600) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, config.nightVisionTime, 0, false, false));
            }
            if (!livingEntity.hasEffect(MobEffects.WEAKNESS) || Objects.requireNonNull(livingEntity.getEffect(MobEffects.WEAKNESS)).getDuration() < 600) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, config.weaknessTime, 0, false, false));
            }
            if (!(list = livingEntity.level().getEntitiesOfClass(Phantom.class, livingEntity.getBoundingBox().inflate(config.phantomRange), EntitySelector.ENTITY_STILL_ALIVE)).isEmpty()) {
                for (Phantom phantomEntity : list) {
                    if (!phantomEntity.level().isClientSide) {
                        Vec3 vector3d = phantomEntity.getDeltaMovement();
                        ((ServerLevel)phantomEntity.getCommandSenderWorld()).sendParticles((ParticleOptions)ParticleTypes.ASH, phantomEntity.getX(), phantomEntity.getY(), phantomEntity.getZ(), 250, vector3d.x, 0.3, vector3d.z, 5.0);
                    }
                    phantomEntity.discard();
                }
            }
        }
    }
}

