/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.trinkets.TickBase;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class Tick
extends TickBase
implements ICurioItem {
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        Player player = (Player)livingEntity;
        return livingEntity.isOnFire() || player.getAbilities().instabuild;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        ServerPlayer player;
        TickBase.Stats config = (TickBase.Stats)TickBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof ServerPlayer) || (player = (ServerPlayer)livingEntity).isSpectator()) {
            return;
        }
        if (!stack.isEmpty()) {
            AABB targetBox = new AABB(player.position(), player.position()).inflate((double)config.rangeToActivate);
            List foundTarget = player.level().getEntitiesOfClass(LivingEntity.class, targetBox, TickBase::isValidTarget);
            if (!foundTarget.isEmpty()) {
                for (LivingEntity livingEntity2 : foundTarget) {
                    if (livingEntity2.getMaxHealth() > 50.0f && livingEntity2.getHealth() > livingEntity2.getMaxHealth() / 2.0f && player.getHealth() >= 5.0f) {
                        livingEntity2.hurt(livingEntity2.damageSources().generic(), livingEntity2.getMaxHealth() * (config.entityDamagePercentage / 100.0f));
                        player.hurt(livingEntity2.damageSources().generic(), player.getMaxHealth() * (config.playerDamagePercentage / 100.0f));
                        continue;
                    }
                    if (!(livingEntity2.getMaxHealth() > 50.0f) || !(livingEntity2.getHealth() > livingEntity2.getMaxHealth() / 2.0f) || player.getFoodData().getFoodLevel() < 5) continue;
                    livingEntity2.hurt(livingEntity2.damageSources().generic(), livingEntity2.getMaxHealth() * (config.entityDamagePercentage / 100.0f));
                    player.causeFoodExhaustion((float)player.getFoodData().getFoodLevel() * (config.playerHungerPercentage / 100.0f));
                }
            }
        }
    }
}

