/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.items.trinkets.TitansMarkBase;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class TitansMark
extends TitansMarkBase
implements ICurioItem {
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void onEquip(SlotContext slotContext, ItemStack pstack, ItemStack stack) {
        TitansMarkBase.Stats config = (TitansMarkBase.Stats)TitansMarkBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.getCommandSenderWorld();
        if (world.isClientSide()) {
            return;
        }
        AttributeInstance attribScale = livingEntity.getAttribute(Attributes.SCALE);
        AttributeModifier scaleModifier = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"titans_mark_scale"), (double)(config.extraScalePercentage / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        assert (attribScale != null);
        EntityUtils.applyAttributeModifier(attribScale, scaleModifier);
        AttributeInstance attribAttackDamage = livingEntity.getAttribute(Attributes.ATTACK_DAMAGE);
        AttributeModifier attackDamageModifier = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"titans_mark_attack_damage"), (double)(config.attackDamagePercentage / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        assert (attribAttackDamage != null);
        EntityUtils.applyAttributeModifier(attribAttackDamage, attackDamageModifier);
    }

    public void onUnequip(SlotContext slotContext, ItemStack pstack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(livingEntity.getAttribute(Attributes.SCALE)), new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"titans_mark_scale"), (double)(((TitansMarkBase.Stats)this.trinketConfig).extraScalePercentage / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)), new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"titans_mark_attack_damage"), (double)(((TitansMarkBase.Stats)this.trinketConfig).attackDamagePercentage / 100.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    }
}

