/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModDataComponents;
import com.cozary.nameless_trinkets.items.trinkets.WoundbearerBase;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class Woundbearer
extends WoundbearerBase
implements ICurioItem {
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_ELYTRA.value(), 1.0f, 1.0f);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        WoundbearerBase.Stats config = (WoundbearerBase.Stats)WoundbearerBase.INSTANCE.getTrinketConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.getCommandSenderWorld();
        if (world.isClientSide()) {
            return;
        }
        float damageIncrement = ((Number)stack.getOrDefault(ModDataComponents.WOUNDBEARER_DAMAGE.get(), (Object)0)).floatValue();
        if (damageIncrement > 0.0f) {
            AttributeInstance attributeDamage = livingEntity.getAttribute(Attributes.ATTACK_DAMAGE);
            AttributeModifier damageModifier = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"woundbearer_attack_damage"), (double)damageIncrement, AttributeModifier.Operation.ADD_VALUE);
            assert (attributeDamage != null);
            EntityUtils.applyAttributeModifier(attributeDamage, damageModifier);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack pstack, ItemStack stack) {
        float damageIncrement = ((Number)stack.getOrDefault(ModDataComponents.WOUNDBEARER_DAMAGE.get(), (Object)0)).floatValue();
        if (damageIncrement > 0.0f) {
            EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.entity().getAttribute(Attributes.ATTACK_DAMAGE)), new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"nameless_trinkets", (String)"woundbearer_attack_damage"), (double)damageIncrement, AttributeModifier.Operation.ADD_VALUE));
        }
    }
}

