/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.lootTables;

import com.cozary.nameless_trinkets.config.TrinketConfigs;
import com.cozary.nameless_trinkets.config.looTables.TrinketDataProvider;
import com.cozary.nameless_trinkets.config.looTables.TrinketLootConfig;
import com.cozary.nameless_trinkets.config.looTables.TrinketLootConfigsManager;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.init.RegistryObject;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.LootTableLoadEvent;

@EventBusSubscriber(modid="nameless_trinkets")
public class LootTableHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation tableId = event.getName();
        for (ResourceKey<LootTable> lootTableKey : TrinketDataProvider.LOOT_TABLES) {
            if (lootTableKey.location().equals((Object)tableId)) {
                return;
            }
            for (TrinketLootConfig config : TrinketLootConfigsManager.getConfigs()) {
                if (!config.getLootTables().contains(tableId)) {
                    return;
                }
                Optional<RegistryObject> optionalItem = ModItems.CREATIVE_TAB_ITEMS.stream().filter(item -> TrinketConfigs.getItemName((TrinketItem)((Object)((Object)item.get()))).equals(config.getItemId())).findFirst();
                if (optionalItem.isEmpty()) {
                    return;
                }
                Item item2 = (Item)optionalItem.get().get();
                float chance = (float)config.getChance();
                String poolName = "nameless_trinkets_pool_" + BuiltInRegistries.ITEM.getKey((Object)item2).getPath();
                if (event.getTable().getPool(poolName) != null) {
                    return;
                }
                LootPool pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)chance)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item2)).name(poolName).build();
                event.getTable().addPool(pool);
            }
        }
    }
}

