/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.utils;

import com.cozary.nameless_trinkets.init.ModTags;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import org.apache.commons.lang3.math.Fraction;

public class TrinketBundleContents
extends BundleContents {
    public static final TrinketBundleContents EMPTY = new TrinketBundleContents(List.of());
    public static final Codec<TrinketBundleContents> CODEC = ItemStack.CODEC.listOf().xmap(TrinketBundleContents::new, trinketBundleContents -> trinketBundleContents.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, TrinketBundleContents> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(TrinketBundleContents::new, trinketBundleContents -> trinketBundleContents.items);
    private static final Fraction BUNDLE_IN_BUNDLE_WEIGHT = Fraction.getFraction((int)1, (int)16);
    public final List<ItemStack> items;
    final Fraction weight;

    TrinketBundleContents(List<ItemStack> itemStacks, Fraction fraction) {
        super(itemStacks);
        this.items = itemStacks;
        this.weight = fraction;
    }

    public TrinketBundleContents(List<ItemStack> list) {
        this(list, TrinketBundleContents.computeContentWeight(list));
    }

    private static Fraction computeContentWeight(List<ItemStack> p_336274_) {
        Fraction fraction = Fraction.ZERO;
        for (ItemStack itemstack : p_336274_) {
            fraction = fraction.add(TrinketBundleContents.getWeight(itemstack).multiplyBy(Fraction.getFraction((int)itemstack.getCount(), (int)1)));
        }
        return fraction;
    }

    static Fraction getWeight(ItemStack itemStack) {
        return Fraction.getFraction((int)1, (int)64);
    }

    public ItemStack getItemUnsafe(int index) {
        return this.items.get(index);
    }

    public Stream<ItemStack> itemCopyStream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Iterable<ItemStack> items() {
        return this.items;
    }

    public List<ItemStack> itemList() {
        return this.items;
    }

    public Iterable<ItemStack> itemsCopy() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public int size() {
        return this.items.size();
    }

    public Fraction weight() {
        return this.weight;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean equals(Object other) {
        boolean var10000;
        if (this == other) {
            return true;
        }
        if (other instanceof TrinketBundleContents) {
            TrinketBundleContents TrinketBundleContents2 = (TrinketBundleContents)((Object)other);
            var10000 = this.weight.equals((Object)TrinketBundleContents2.weight) && ItemStack.listMatches(this.items, TrinketBundleContents2.items);
        } else {
            var10000 = false;
        }
        return var10000;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "TrinketBundleContents" + String.valueOf(this.items);
    }

    public static class Mutable {
        public final List<ItemStack> items;
        private Fraction weight;

        public Mutable(TrinketBundleContents trinketBundleContents) {
            this.items = new ArrayList<ItemStack>(trinketBundleContents.items);
            this.weight = trinketBundleContents.weight;
        }

        public Mutable clearItems() {
            this.items.clear();
            this.weight = Fraction.ZERO;
            return this;
        }

        private int findStackIndex(ItemStack itemStack) {
            if (!itemStack.isStackable()) {
                return -1;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)this.items.get(i), (ItemStack)itemStack)) continue;
                return i;
            }
            return -1;
        }

        private int getMaxAmountToAdd(ItemStack itemStack) {
            return itemStack.is(ModTags.NAMELESS_TRINKETS_TAG) ? (int)(64.0f - this.weight.floatValue() * 64.0f) : 0;
        }

        public int tryInsert(ItemStack itemStack) {
            if (!itemStack.isEmpty() && itemStack.getItem().canFitInsideContainerItems()) {
                int i = Math.min(itemStack.getCount(), this.getMaxAmountToAdd(itemStack));
                if (i == 0) {
                    return 0;
                }
                this.weight = this.weight.add(TrinketBundleContents.getWeight(itemStack).multiplyBy(Fraction.getFraction((int)i, (int)1)));
                int j = this.findStackIndex(itemStack);
                if (j != -1) {
                    ItemStack itemstack = this.items.remove(j);
                    ItemStack itemstack1 = itemstack.copyWithCount(itemstack.getCount() + i);
                    itemStack.shrink(i);
                    this.items.add(0, itemstack1);
                } else {
                    this.items.add(0, itemStack.split(i));
                }
                return i;
            }
            return 0;
        }

        public int tryTransfer(Slot slot, Player player) {
            ItemStack itemstack = slot.getItem();
            int i = this.getMaxAmountToAdd(itemstack);
            return this.tryInsert(slot.safeTake(itemstack.getCount(), i, player));
        }

        public ItemStack removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            ItemStack itemstack = this.items.remove(0).copy();
            this.weight = this.weight.subtract(TrinketBundleContents.getWeight(itemstack).multiplyBy(Fraction.getFraction((int)itemstack.getCount(), (int)1)));
            return itemstack;
        }

        public Fraction weight() {
            return this.weight;
        }

        public TrinketBundleContents toImmutable() {
            return new TrinketBundleContents(List.copyOf(this.items), this.weight);
        }
    }
}

