/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.durabilitynotifier;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.ItemStack;

public class CooldownUtil {
    public static final Map<ItemStack, Long> cooldownMap = Collections.synchronizedMap(new HashMap());

    public static void putOnCooldown(ItemStack stack) {
        cooldownMap.put(stack, System.currentTimeMillis());
    }

    public static boolean isNotOnCooldown(ItemStack stack, long time) {
        if (CooldownUtil.isAvailable(stack, time)) {
            CooldownUtil.putOnCooldown(stack);
            return true;
        }
        return false;
    }

    public static boolean isAvailable(ItemStack stack, Long time) {
        if (cooldownMap.containsKey(stack)) {
            long lastUsed = cooldownMap.get(stack);
            return System.currentTimeMillis() >= lastUsed + time;
        }
        return true;
    }
}

