/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.durabilitynotifier;

import com.mrbysco.durabilitynotifier.EventHandler;
import com.mrbysco.durabilitynotifier.config.DurabilityConfig;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@Mod(value="durabilitynotifier")
public class DurabilityNotifier {
    public DurabilityNotifier(IEventBus eventBus, Dist dist, ModContainer container) {
        if (dist.isClient()) {
            container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DurabilityConfig.clientSpec);
            eventBus.register(DurabilityConfig.class);
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            NeoForge.EVENT_BUS.addListener(this::onLeftClickBlock);
            NeoForge.EVENT_BUS.addListener(this::onLeftClickEmpty);
            NeoForge.EVENT_BUS.addListener(this::onRightClickBlock);
            NeoForge.EVENT_BUS.addListener(this::onRightClickEmpty);
            NeoForge.EVENT_BUS.addListener(this::onAttackEntity);
            NeoForge.EVENT_BUS.addListener(this::onInventoryTick);
        }
    }

    private void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        EventHandler.checkDurability(event.getItemStack(), event.getEntity());
    }

    private void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        EventHandler.checkDurability(event.getItemStack(), event.getEntity());
    }

    private void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EventHandler.checkDurability(event.getItemStack(), event.getEntity());
    }

    private void onRightClickEmpty(PlayerInteractEvent.RightClickItem event) {
        EventHandler.checkDurability(event.getItemStack(), event.getEntity());
    }

    private void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        EventHandler.checkDurability(player.getMainHandItem(), player);
    }

    private void onInventoryTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().getGameTime() % 80L == 0L && ((Boolean)DurabilityConfig.CLIENT.CheckArmor.get()).booleanValue()) {
            List armorFilter = (List)DurabilityConfig.CLIENT.ArmorFilter.get();
            for (EquipmentSlot equipmentslot : EquipmentSlotGroup.ARMOR) {
                ItemStack itemStack = player.getItemBySlot(equipmentslot);
                if (!armorFilter.isEmpty() && !armorFilter.contains(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString())) continue;
                EventHandler.checkDurability(itemStack, player);
            }
        }
    }
}

