/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.durabilitynotifier;

import com.mrbysco.durabilitynotifier.CooldownUtil;
import com.mrbysco.durabilitynotifier.Reference;
import com.mrbysco.durabilitynotifier.platform.Services;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventHandler {
    public static void checkDurability(@NotNull ItemStack stack, @NotNull Player player) {
        double DurabilityChecking = 1.0 - (double)Services.PLATFORM.getPercentage() / 100.0;
        if (!stack.isEmpty()) {
            EventHandler.checkDurability(stack, player, DurabilityChecking);
        }
    }

    public static void checkDurability(@NotNull ItemStack stack, @NotNull Player player, double checkNumber) {
        if (!stack.isEmpty() && stack.isDamageableItem() && stack.getMaxDamage() != 0 && (double)stack.getDamageValue() / (double)stack.getMaxDamage() > checkNumber) {
            if (Services.PLATFORM.getSendMessage()) {
                EventHandler.sendMessage(player, stack);
            }
            if (Services.PLATFORM.getPlaySound() && CooldownUtil.isNotOnCooldown(stack, 500L)) {
                if (player.getGameProfile().id().equals(UUID.fromString("86121150-39f2-4063-831a-3715f2e7f397"))) {
                    player.level().playLocalSound(player.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
                EventHandler.playSound(player);
            }
        }
    }

    public static void sendMessage(@NotNull Player player, @NotNull ItemStack stack) {
        ChatFormatting messageColor = Services.PLATFORM.getMessageColor();
        if (messageColor == null) {
            messageColor = ChatFormatting.YELLOW;
            Reference.LOGGER.warn("Invalid chat color found in config, please check the config");
        }
        String warningString = Component.translatable((String)"durabilitynotifier.warning").getString();
        warningString = warningString.replace("%item%", stack.getDisplayName().getString()).replace("%percent%", Services.PLATFORM.getPercentage() + "\u00a7c%\u00a7r");
        MutableComponent warning = Component.literal((String)warningString).withStyle(messageColor);
        player.displayClientMessage((Component)warning, true);
    }

    public static void playSound(@NotNull Player player) {
        SoundEvent chosenSound = EventHandler.getChosenSound();
        if (chosenSound != null) {
            player.level().playLocalSound(player.blockPosition(), chosenSound, SoundSource.PLAYERS, Services.PLATFORM.getSoundVolume(), 1.0f, false);
        } else {
            Reference.LOGGER.warn("Could not locate the following sound: {}. Perhaps you misspelled it.", (Object)Services.PLATFORM.getSoundLocation());
        }
    }

    @Nullable
    private static SoundEvent getChosenSound() {
        ResourceLocation soundLocation = ResourceLocation.tryParse((String)Services.PLATFORM.getSoundLocation());
        if (soundLocation != null) {
            SoundEvent sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(soundLocation);
            if (sound != null) {
                return sound;
            }
            Reference.LOGGER.warn("Could not locate the following sound: {}. Perhaps you misspelled it. Falling back to default!", (Object)soundLocation);
            return (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value();
        }
        return null;
    }
}

