/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.durabilitynotifier.config;

import com.mrbysco.durabilitynotifier.Reference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DurabilityConfig {
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Reference.LOGGER.debug("Loaded Durability Notifier's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Reference.LOGGER.warn("Durability Notifier's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.IntValue Percentage;
        public final ModConfigSpec.BooleanValue SendMessage;
        public final ModConfigSpec.BooleanValue CheckArmor;
        public final ModConfigSpec.ConfigValue<List<? extends String>> ArmorFilter;
        public final ModConfigSpec.EnumValue<ChatFormatting> SentMessageColor;
        public final ModConfigSpec.BooleanValue PlaySound;
        public final ModConfigSpec.ConfigValue<String> soundlocation;
        public final ModConfigSpec.DoubleValue volume;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("general");
            this.Percentage = builder.comment("Sets the percentage the mod checks for [default: 10] (1 to 100)").defineInRange("Percentage", 10, 1, 100);
            this.CheckArmor = builder.comment("Dictates if it should also actively check armor [default: false]").define("CheckArmor", false);
            this.ArmorFilter = builder.comment("If CheckArmor is enabled, any armor that is not in this list will be ignored (Empty list = all armor will be checked) [default: []]").defineListAllowEmpty("ArmorFilter", List.of(), String::new, object -> object instanceof String);
            builder.pop();
            builder.comment("Message settings").push("message");
            this.SendMessage = builder.comment("Change this option to let it not display a chat message (if you have sound enabled) [default: true]").define("SendMessage", true);
            this.SentMessageColor = builder.comment("Change this option to change the color / formatting of the message (if you have messages enabled) [default: YELLOW]").defineEnum("SentMessageColor", (Enum)ChatFormatting.YELLOW);
            builder.pop();
            builder.comment("Sound settings").push("sound");
            this.PlaySound = builder.comment("Change this option to let it play a sound (configurable in the sound tab) [default: false]").define("PlaySound", true);
            this.soundlocation = builder.comment("The id of the sound that is played (if you have sound enabled) [default: minecraft:block.note_block.pling]").define("soundlocation", (Object)"minecraft:block.note_block.pling", o -> {
                String loc;
                return o instanceof String && ResourceLocation.tryParse((String)(loc = (String)o)) != null;
            });
            this.volume = builder.comment("Sets the sound volume [default: 0.6] (0 to 1.0)").defineInRange("volume", 0.6, 0.0, 1.0);
            builder.pop();
        }
    }
}

