/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.durabilitynotifier;

import com.mrbysco.durabilitynotifier.EventHandler;
import com.mrbysco.durabilitynotifier.Reference;
import com.mrbysco.durabilitynotifier.callback.ClickAirCallback;
import com.mrbysco.durabilitynotifier.callback.PlayerTickCallback;
import com.mrbysco.durabilitynotifier.config.DurabilityConfig;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_7923;
import net.minecraft.class_9274;

public class DurabilityNotifier
implements ClientModInitializer {
    public static DurabilityConfig config;

    public void onInitializeClient() {
        ConfigHolder holder = AutoConfig.register(DurabilityConfig.class, Toml4jConfigSerializer::new);
        config = (DurabilityConfig)holder.getConfig();
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            Paths.get("config", new String[0]).register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            Thread watchThread = new Thread(() -> {
                try {
                    WatchKey key;
                    while ((key = watchService.take()) != null) {
                        if (Thread.currentThread().isInterrupted()) {
                            watchService.close();
                            break;
                        }
                        for (WatchEvent<?> event : key.pollEvents()) {
                            if (event.kind() == StandardWatchEventKinds.OVERFLOW || !((Path)event.context()).endsWith("durabilitynotifier.toml")) continue;
                            Reference.LOGGER.info("Reloading DurabilityNotifier config");
                            if (!holder.load()) continue;
                            config = (DurabilityConfig)holder.getConfig();
                        }
                        key.reset();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException e) {
                    Reference.LOGGER.error("Failed to close filesystem watcher", (Throwable)e);
                }
            }, "Durability Notifier Config Watcher");
            watchThread.start();
        }
        catch (IOException e) {
            Reference.LOGGER.error("Failed to create filesystem watcher for configs", (Throwable)e);
        }
        AttackBlockCallback.EVENT.register((player, world, hand, pos, face) -> {
            EventHandler.checkDurability(player.method_5998(hand), player);
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            EventHandler.checkDurability(player.method_5998(hand), player);
            return class_1269.field_5811;
        });
        ClickAirCallback.LEFT_CLICK_EVENT.register((player, hand) -> {
            EventHandler.checkDurability(player.method_5998(hand), player);
            return class_1269.field_5811;
        });
        ClickAirCallback.RIGHT_CLICK_EVENT.register((player, hand) -> {
            System.out.println("Right click air " + String.valueOf(hand));
            EventHandler.checkDurability(player.method_5998(hand), player);
            return class_1269.field_5811;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            EventHandler.checkDurability(player.method_5998(hand), player);
            return class_1269.field_5811;
        });
        PlayerTickCallback.EVENT.register(player -> {
            class_1937 level = player.method_73183();
            if (level.method_8608() && level.method_8510() % 80L == 0L) {
                if (config == null) {
                    config = (DurabilityConfig)AutoConfig.getConfigHolder(DurabilityConfig.class).getConfig();
                }
                if (DurabilityNotifier.config.general.checkArmor) {
                    List<String> armorFilter = DurabilityNotifier.config.general.armorFilter;
                    for (class_1304 equipmentslot : class_9274.field_49224) {
                        class_1799 itemStack = player.method_6118(equipmentslot);
                        if (!armorFilter.isEmpty() && !armorFilter.contains(class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString())) continue;
                        EventHandler.checkDurability(itemStack, player);
                    }
                }
            }
            return class_1269.field_5811;
        });
    }
}

