/*
 * Decompiled with CFR 0.152.
 */
package org.nyt.radio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.nyt.radio.Radio;

public class DataManager {
    private final File file;
    private final Radio plugin = Radio.plugin;
    private final Map<String, RadioData> dataMap = new HashMap<String, RadioData>();

    public DataManager() {
        this.file = new File(this.plugin.getDataFolder(), "radio-blocks.dat");
        this.load();
    }

    private String serializeLocation(Location loc) {
        return loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }

    public void setBlock(Location loc, int frequency, String state, List<ItemDisplay> textures, TextDisplay frequencyDisplay) {
        List<UUID> texturesUUID = textures.stream().map(Entity::getUniqueId).collect(Collectors.toList());
        UUID freqDisplayUUID = frequencyDisplay.getUniqueId();
        String key = this.serializeLocation(loc);
        this.dataMap.put(key, new RadioData(frequency, state, texturesUUID, freqDisplayUUID));
        this.save();
    }

    public RadioData getBlock(Location loc) {
        return this.dataMap.get(this.serializeLocation(loc));
    }

    public void removeBlock(Location loc) {
        String key = this.serializeLocation(loc);
        this.dataMap.remove(key);
        this.save();
    }

    public Map<Location, RadioData> getAllBlocks() {
        HashMap<Location, RadioData> result = new HashMap<Location, RadioData>();
        for (Map.Entry<String, RadioData> entry : this.dataMap.entrySet()) {
            String[] parts = entry.getKey().split(",");
            World world = Bukkit.getWorld((String)parts[0]);
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            result.put(new Location(world, (double)x, (double)y, (double)z), entry.getValue());
        }
        return result;
    }

    private void save() {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.file));){
            out.writeObject(this.dataMap);
        }
        catch (IOException e) {
            Radio.LOGGER.error("Failed to write data-file " + e.getMessage());
        }
    }

    private void load() {
        if (!this.file.exists()) {
            return;
        }
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.file));){
            Object obj = in.readObject();
            if (obj instanceof Map) {
                this.dataMap.clear();
                this.dataMap.putAll((Map)obj);
            }
        }
        catch (Exception e) {
            Radio.LOGGER.error("Failed to read data-file " + e.getMessage());
        }
    }

    public static class RadioData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int frequency;
        private String state;
        private List<UUID> texturesUUID;
        private UUID frequencyDisplayUUID;

        public RadioData(int frequency, String state, List<UUID> texturesUUID, UUID frequencyDisplayUUID) {
            this.frequency = frequency;
            this.state = state;
            this.texturesUUID = texturesUUID;
            this.frequencyDisplayUUID = frequencyDisplayUUID;
        }

        public int getFrequency() {
            return this.frequency;
        }

        public void setFrequency(int frequency) {
            this.frequency = frequency;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public List<ItemDisplay> getTextures() {
            return this.texturesUUID.stream().map(Bukkit::getEntity).filter(e -> e instanceof ItemDisplay).map(e -> (ItemDisplay)e).collect(Collectors.toList());
        }

        public TextDisplay getFrequencyDisplay() {
            if (this.frequencyDisplayUUID == null) {
                return null;
            }
            Entity e = Bukkit.getEntity((UUID)this.frequencyDisplayUUID);
            return e instanceof TextDisplay ? (TextDisplay)e : null;
        }
    }
}

