/*
 * Decompiled with CFR 0.152.
 */
package org.nyt.radio;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.nyt.radio.DataManager;
import org.nyt.radio.DisplayEntityManager;
import org.nyt.radio.Item;
import org.nyt.radio.Radio;
import org.nyt.radio.SimpleVoiceAddon;

public class EventListener
implements Listener {
    private final DataManager manager;
    private final Radio plugin = Radio.plugin;
    private final SimpleVoiceAddon addon;
    private final DisplayEntityManager displayManager = new DisplayEntityManager();

    public EventListener(SimpleVoiceAddon addon, DataManager dataManager) {
        this.addon = addon;
        this.manager = dataManager;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.getItemInHand().getPersistentDataContainer().get(NamespacedKey.fromString((String)"radio"), PersistentDataType.BOOLEAN) == null) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            float yaw = (float)Math.round(event.getPlayer().getYaw() / 90.0f) * 90.0f;
            Location center = event.getBlock().getLocation().add(0.5, 0.5, 0.5);
            center.getBlock().setBlockData(Bukkit.createBlockData((Material)Material.WAXED_COPPER_GRATE), true);
            center.setPitch(0.0f);
            center.setYaw(yaw + 90.0f);
            List<ItemDisplay> itemDisplays = this.displayManager.createItemDisplays(center);
            int freq = this.plugin.getConfig().getInt("radio-block.default_frequency", 1);
            TextDisplay textDisplay = this.displayManager.createTextDisplay(center, freq);
            this.manager.setBlock(event.getBlock().getLocation(), freq, "output", itemDisplays, textDisplay);
            if (this.addon != null) {
                this.addon.recreateOutputChannels();
            }
        }, 1L);
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        Player player = event.getPlayer();
        if (this.manager.getBlock(event.getBlock().getLocation()) != null && event.getBlock().getBlockData().getMaterial().equals((Object)Material.WAXED_COPPER_GRATE)) {
            DataManager.RadioData blockData = this.manager.getBlock(event.getBlock().getLocation());
            if (player.getGameMode() != GameMode.CREATIVE) {
                event.setDropItems(false);
                block.getWorld().dropItemNaturally(block.getLocation(), new Item().getItem());
            }
            blockData.getTextures().forEach(Entity::remove);
            blockData.getFrequencyDisplay().remove();
            this.manager.removeBlock(event.getBlock().getLocation());
            if (this.addon != null) {
                this.addon.recreateOutputChannels();
            }
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (this.manager.getBlock(block.getLocation()) == null || !block.getBlockData().getMaterial().equals((Object)Material.WAXED_COPPER_GRATE)) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            if (this.manager.getBlock(block.getLocation()) == null || !block.getBlockData().getMaterial().equals((Object)Material.WAXED_COPPER_GRATE)) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler
    public void onExplosion(BlockExplodeEvent event) {
        event.blockList().removeIf(block -> this.manager.getBlock(block.getLocation()) != null && block.getBlockData().getMaterial().equals((Object)Material.WAXED_COPPER_GRATE));
    }

    @EventHandler
    public void onEntityExplosion(EntityExplodeEvent event) {
        event.blockList().removeIf(block -> this.manager.getBlock(block.getLocation()) != null && block.getBlockData().getMaterial().equals((Object)Material.WAXED_COPPER_GRATE));
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && event.getHand().equals((Object)EquipmentSlot.HAND) && this.manager.getBlock(event.getClickedBlock().getLocation()) != null) {
            boolean isRadio;
            ItemStack item = event.getItem() == null ? new ItemStack(Material.AIR) : event.getItem();
            boolean bl = isRadio = item.getItemMeta() != null && item.getItemMeta().getPersistentDataContainer().has(NamespacedKey.fromString((String)"radio"), PersistentDataType.BOOLEAN);
            if (isRadio) {
                return;
            }
            event.setCancelled(true);
            DataManager.RadioData blockData = this.manager.getBlock(event.getClickedBlock().getLocation());
            Player player = event.getPlayer();
            if (player.isSneaking()) {
                player.getWorld().playSound(event.getClickedBlock().getLocation(), Sound.BLOCK_COPPER_BULB_TURN_ON, SoundCategory.MASTER, 3.0f, 0.0f);
                if (blockData.getState().equals("input")) {
                    this.displayManager.setStateSkin(blockData.getTextures().get(1), "output");
                    blockData.setState("output");
                } else if (blockData.getState().equals("output")) {
                    this.displayManager.setStateSkin(blockData.getTextures().get(1), "input");
                    blockData.setState("input");
                }
                if (this.addon != null) {
                    this.addon.recreateOutputChannels();
                }
            } else {
                player.getWorld().playSound(event.getClickedBlock().getLocation(), Sound.BLOCK_NOTE_BLOCK_BIT, SoundCategory.MASTER, 3.0f, 2.0f);
                int frequency = blockData.getFrequency();
                frequency = frequency >= this.plugin.getConfig().getInt("radio-block.max_frequency", 1) ? 1 : ++frequency;
                blockData.setFrequency(frequency);
                blockData.getFrequencyDisplay().text((Component)Component.text((String)String.valueOf(blockData.getFrequency()), (TextColor)NamedTextColor.DARK_RED));
            }
        }
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (this.manager.getBlock(event.getBlock().getLocation()) != null && !event.getBlock().getBlockData().getMaterial().equals((Object)Material.WAXED_COPPER_GRATE)) {
            DataManager.RadioData blockData = this.manager.getBlock(event.getBlock().getLocation());
            blockData.getTextures().forEach(Entity::remove);
            blockData.getFrequencyDisplay().remove();
            this.manager.removeBlock(event.getBlock().getLocation());
            if (this.addon != null) {
                this.addon.recreateOutputChannels();
            }
        }
    }
}

