/*
 * Decompiled with CFR 0.152.
 */
package org.nyt.radio;

import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.MicrophonePacketEvent;
import de.maxhenkel.voicechat.api.events.VoicechatServerStartedEvent;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.nyt.radio.DataManager;
import org.nyt.radio.Radio;

public class SimpleVoiceAddon
implements VoicechatPlugin {
    public static VoicechatServerApi api = null;
    private final DataManager dataManager;
    private final Map<String, LocationalAudioChannel> outputChannels = new HashMap<String, LocationalAudioChannel>();

    public SimpleVoiceAddon(DataManager dataManager) {
        this.dataManager = dataManager;
    }

    public String getPluginId() {
        return "Radio";
    }

    public void initialize(VoicechatApi api) {
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(VoicechatServerStartedEvent.class, this::onServerStart);
        registration.registerEvent(MicrophonePacketEvent.class, this::onMicrophone);
    }

    private void onServerStart(VoicechatServerStartedEvent event) {
        api = event.getVoicechat();
        this.createOutputChannels();
    }

    private void onMicrophone(MicrophonePacketEvent event) {
        try {
            VoicechatConnection connection = event.getSenderConnection();
            Position position = connection.getPlayer().getPosition();
            ServerLevel serverLevel = connection.getPlayer().getServerLevel();
            World playerWorld = (World)serverLevel.getServerLevel();
            this.sendPacket(position, playerWorld, ((MicrophonePacket)event.getPacket()).getOpusEncodedData());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendPacket(Position position, World playerWorld, byte[] audioData) {
        double px = position.getX();
        double py = position.getY();
        double pz = position.getZ();
        double inputRadius = Radio.plugin.getConfig().getDouble("radio-block.input_search_radius", 16.0);
        Optional<Map.Entry> inputOpt = this.dataManager.getAllBlocks().entrySet().stream().filter(e -> ((DataManager.RadioData)e.getValue()).getState().equalsIgnoreCase("input")).filter(e -> {
            Location loc = (Location)e.getKey();
            World world = loc.getWorld();
            if (world == null) {
                return false;
            }
            if (!world.equals((Object)playerWorld)) {
                return false;
            }
            double distance = Math.sqrt(Math.pow(loc.getX() + 0.5 - px, 2.0) + Math.pow(loc.getY() + 0.5 - py, 2.0) + Math.pow(loc.getZ() + 0.5 - pz, 2.0));
            return distance <= inputRadius;
        }).findFirst();
        if (inputOpt.isEmpty()) {
            return;
        }
        int frequency = ((DataManager.RadioData)inputOpt.get().getValue()).getFrequency();
        for (Map.Entry<Location, DataManager.RadioData> entry : this.dataManager.getAllBlocks().entrySet()) {
            boolean hasNearbyPlayer;
            ServerLevel level;
            Location loc;
            World world;
            DataManager.RadioData radioData = entry.getValue();
            if (!radioData.getState().equalsIgnoreCase("output") || radioData.getFrequency() != frequency || (world = (loc = entry.getKey()).getWorld()) == null || !world.isChunkLoaded(loc.getBlockX() >> 4, loc.getBlockZ() >> 4) || (level = api.fromServerLevel((Object)world)) == null) continue;
            String key = this.serializeLocation(loc);
            LocationalAudioChannel channel = this.outputChannels.get(key);
            if (channel == null) {
                channel = this.createChannel(loc, level);
                if (channel == null) continue;
                this.outputChannels.put(key, channel);
            }
            double maxRange = channel.getDistance();
            boolean bl = hasNearbyPlayer = !api.getPlayersInRange(level, api.createPosition(loc.getX() + 0.5, loc.getY() + 0.5, loc.getZ() + 0.5), maxRange, p -> true).isEmpty();
            if (!hasNearbyPlayer) continue;
            channel.send(audioData);
            if (System.currentTimeMillis() % 500L >= 20L) continue;
            world.spawnParticle(Particle.NOTE, loc.getX() + 0.5, loc.getY() + 1.0, loc.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0, null, true);
        }
    }

    private LocationalAudioChannel createChannel(Location loc, ServerLevel level) {
        LocationalAudioChannel channel = api.createLocationalAudioChannel(UUID.randomUUID(), level, api.createPosition(loc.getX() + 0.5, loc.getY() + 0.5, loc.getZ() + 0.5));
        if (channel != null) {
            float distance = (float)Radio.plugin.getConfig().getDouble("radio-block.output_radius", 16.0);
            channel.setDistance(distance);
        }
        return channel;
    }

    public void recreateOutputChannels() {
        this.outputChannels.clear();
        this.createOutputChannels();
    }

    private void createOutputChannels() {
        if (api == null) {
            return;
        }
        this.outputChannels.clear();
        for (Map.Entry<Location, DataManager.RadioData> entry : this.dataManager.getAllBlocks().entrySet()) {
            LocationalAudioChannel channel;
            ServerLevel level;
            Location loc;
            World world;
            if (!entry.getValue().getState().equalsIgnoreCase("output") || (world = (loc = entry.getKey()).getWorld()) == null || (level = api.fromServerLevel((Object)world)) == null || (channel = this.createChannel(loc, level)) == null) continue;
            this.outputChannels.put(this.serializeLocation(loc), channel);
        }
    }

    private String serializeLocation(Location loc) {
        return loc.getWorld().getName() + "," + loc.getBlockX() + "," + loc.getBlockY() + "," + loc.getBlockZ();
    }
}

