/*
 * Decompiled with CFR 0.152.
 */
package org.nyt.radio;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.nyt.radio.Radio;

public class DisplayEntityManager {
    private final Radio plugin = Radio.plugin;

    public List<ItemDisplay> createItemDisplays(Location loc) {
        ArrayList<ItemDisplay> list = new ArrayList<ItemDisplay>();
        for (int i = 1; i <= 8; ++i) {
            ItemDisplay display = (ItemDisplay)loc.getWorld().spawn(loc, ItemDisplay.class);
            ItemStack item = ItemStack.of((Material)Material.PLAYER_HEAD);
            String skull_skin = this.plugin.getConfig().getString("item_displays." + i + ".skull_skin");
            this.getSkullByValue(skull_skin, item);
            display.setItemStack(item);
            display.setViewRange(512.0f);
            Vector3f translation = this.parseVector(this.plugin.getConfig().getString("item_displays." + i + ".translation"), new Vector3f(0.0f, 0.0f, 0.0f));
            Vector3f scale = this.parseVector(this.plugin.getConfig().getString("item_displays." + i + ".scale"), new Vector3f(1.003f, 1.003f, 1.003f));
            this.updateTransformation((Display)display, translation, null, scale, null);
            list.add(display);
        }
        return list;
    }

    public void setStateSkin(ItemDisplay display, String state) {
        String displaySkullSkin = state.equalsIgnoreCase("input") ? this.plugin.getConfig().getString("item_displays.1.input_state") : this.plugin.getConfig().getString("item_displays.1.skull_skin");
        ItemStack displayItem = display.getItemStack();
        this.getSkullByValue(displaySkullSkin, displayItem);
        display.setItemStack(displayItem);
    }

    public TextDisplay createTextDisplay(Location loc, int frequency) {
        TextDisplay display = (TextDisplay)loc.getWorld().spawn(loc, TextDisplay.class);
        display.text((Component)Component.text((String)String.valueOf(frequency), (TextColor)NamedTextColor.DARK_RED));
        display.setBackgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0));
        display.setViewRange(512.0f);
        Vector3f scale = new Vector3f(1.5f, 1.435f, 0.0f);
        Vector3f translation = new Vector3f(-0.501f, -0.01f, -0.0185f);
        Quaternionf leftRot = new Quaternionf().rotateY((float)Math.toRadians(270.0));
        this.updateTransformation((Display)display, translation, leftRot, scale, null);
        return display;
    }

    public void getSkullByValue(String base64, ItemStack item) {
        if (base64 == null || base64.isEmpty()) {
            Radio.LOGGER.warn("Skull skin is null or empty");
            return;
        }
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null) {
            try {
                UUID uuid = new UUID(base64.hashCode(), base64.hashCode());
                PlayerProfile profile = Bukkit.createProfile((UUID)uuid);
                ProfileProperty property = new ProfileProperty("textures", base64);
                profile.getProperties().clear();
                profile.getProperties().add(property);
                meta.setPlayerProfile(profile);
                item.setItemMeta((ItemMeta)meta);
            }
            catch (Exception e) {
                Radio.LOGGER.error("Failed to parse skull skin: " + e.getMessage());
            }
        }
    }

    public void updateTransformation(Display display, Vector3f translation, Quaternionf leftRotation, Vector3f scale, Quaternionf rightRotation) {
        if (display == null) {
            return;
        }
        Transformation oldTrans = display.getTransformation();
        Transformation newTrans = new Transformation(translation != null ? translation : oldTrans.getTranslation(), leftRotation != null ? leftRotation : oldTrans.getLeftRotation(), scale != null ? scale : oldTrans.getScale(), rightRotation != null ? rightRotation : oldTrans.getRightRotation());
        display.setTransformation(newTrans);
    }

    private Vector3f parseVector(String s, Vector3f defaultVec) {
        if (s == null || s.isEmpty()) {
            return defaultVec;
        }
        try {
            String[] parts = s.split(",");
            if (parts.length != 3) {
                return defaultVec;
            }
            float x = Float.parseFloat(parts[0]);
            float y = Float.parseFloat(parts[1]);
            float z = Float.parseFloat(parts[2]);
            return new Vector3f(x, y, z);
        }
        catch (Exception e) {
            return defaultVec;
        }
    }
}

