/*
 * Decompiled with CFR 0.152.
 */
package org.nyt.radio;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.nyt.radio.DataManager;
import org.nyt.radio.DisplayEntityManager;
import org.nyt.radio.Item;
import org.nyt.radio.Radio;
import org.nyt.radio.SimpleVoiceAddon;

public class EventListener
implements Listener {
    private final DataManager manager;
    private final Radio plugin = Radio.plugin;
    private final SimpleVoiceAddon addon;
    private final DisplayEntityManager displayManager = new DisplayEntityManager();
    private final Material material = Material.WAXED_COPPER_GRATE;

    public EventListener(SimpleVoiceAddon addon, DataManager dataManager) {
        this.addon = addon;
        this.manager = dataManager;
    }

    private void updateRadioData(DataManager.RadioData blockData, int power) {
        blockData.setFrequency(power);
        if (power > 0) {
            blockData.getFrequencyDisplay().text((Component)Component.text((String)String.valueOf(blockData.getFrequency()), (TextColor)NamedTextColor.DARK_RED));
        } else {
            blockData.getFrequencyDisplay().text((Component)Component.empty());
            if (this.plugin.getConfig().getBoolean("radio-block.redstone_frequency", false)) {
                blockData.setState("output");
            }
        }
        this.displayManager.setStateSkin(blockData.getTextures().get(1), blockData.getState());
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.getItemInHand().getPersistentDataContainer().get(NamespacedKey.fromString((String)"radio"), PersistentDataType.BOOLEAN) == null) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            float yaw = (float)Math.round(event.getPlayer().getYaw() / 90.0f) * 90.0f;
            Location center = event.getBlock().getLocation().add(0.5, 0.5, 0.5);
            center.getBlock().setBlockData(Bukkit.createBlockData((Material)this.material), true);
            center.setPitch(0.0f);
            center.setYaw(yaw + 90.0f);
            List<ItemDisplay> itemDisplays = this.displayManager.createItemDisplays(center);
            int freq = this.plugin.getConfig().getBoolean("radio-block.redstone_frequency", false) ? event.getBlock().getBlockPower() : 1;
            TextDisplay textDisplay = this.displayManager.createTextDisplay(center, freq);
            this.manager.setBlock(event.getBlock().getLocation(), freq, "output", itemDisplays, textDisplay);
            this.updateRadioData(this.manager.getBlock(event.getBlock().getLocation()), freq);
            if (this.addon != null) {
                this.addon.recreateOutputChannels();
            }
        }, 1L);
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        DataManager.RadioData blockData = this.manager.getBlock(block.getLocation());
        if (blockData == null) {
            return;
        }
        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
            event.setDropItems(false);
            block.getWorld().dropItemNaturally(block.getLocation(), new Item().getItem());
        }
        blockData.getTextures().forEach(Entity::remove);
        blockData.getFrequencyDisplay().remove();
        this.manager.removeBlock(block.getLocation());
        if (this.addon != null) {
            this.addon.recreateOutputChannels();
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (this.manager.getBlock(block.getLocation()) == null) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            if (this.manager.getBlock(block.getLocation()) == null) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler
    public void onExplosion(BlockExplodeEvent event) {
        event.blockList().removeIf(block -> this.manager.getBlock(block.getLocation()) != null);
    }

    @EventHandler
    public void onEntityExplosion(EntityExplodeEvent event) {
        event.blockList().removeIf(block -> this.manager.getBlock(block.getLocation()) != null);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean isRadio;
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || !event.getHand().equals((Object)EquipmentSlot.HAND) || event.getClickedBlock() == null) {
            return;
        }
        DataManager.RadioData blockData = this.manager.getBlock(event.getClickedBlock().getLocation());
        if (blockData == null) {
            return;
        }
        ItemStack item = event.getItem() == null ? new ItemStack(Material.AIR) : event.getItem();
        boolean bl = isRadio = item.getItemMeta() != null && item.getItemMeta().getPersistentDataContainer().has(NamespacedKey.fromString((String)"radio"), PersistentDataType.BOOLEAN);
        if (isRadio) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        boolean redstoneMode = this.plugin.getConfig().getBoolean("radio-block.redstone_frequency", false);
        int currentPower = event.getClickedBlock().getBlockPower();
        int freq = blockData.getFrequency();
        if (player.isSneaking() && !redstoneMode) {
            freq = blockData.getFrequency() + 1;
            if (freq > this.plugin.getConfig().getInt("radio-block.max_frequency", 15)) {
                freq = 1;
            }
            player.getWorld().playSound(event.getClickedBlock().getLocation(), Sound.BLOCK_NOTE_BLOCK_BIT, SoundCategory.MASTER, 3.0f, 2.0f);
        } else {
            if (redstoneMode && currentPower <= 0) {
                return;
            }
            player.getWorld().playSound(event.getClickedBlock().getLocation(), Sound.BLOCK_COPPER_BULB_TURN_ON, SoundCategory.MASTER, 3.0f, 0.0f);
            if (blockData.getState().equals("input")) {
                blockData.setState("output");
            } else if (blockData.getState().equals("output")) {
                blockData.setState("input");
            }
            if (redstoneMode) {
                freq = currentPower;
            }
        }
        this.updateRadioData(blockData, freq);
        if (this.addon != null) {
            this.addon.recreateOutputChannels();
        }
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        try {
            DataManager.RadioData blockData = this.manager.getBlock(event.getBlock().getLocation());
            if (blockData == null) {
                return;
            }
            if (!event.getBlock().getBlockData().getMaterial().equals((Object)this.material)) {
                blockData.getTextures().forEach(Entity::remove);
                blockData.getFrequencyDisplay().remove();
                this.manager.removeBlock(event.getBlock().getLocation());
            } else if (this.plugin.getConfig().getBoolean("radio-block.redstone_frequency", false)) {
                this.updateRadioData(blockData, event.getBlock().getBlockPower());
            }
            if (this.addon != null) {
                this.addon.recreateOutputChannels();
            }
        }
        catch (Exception e) {
            Radio.LOGGER.error((Object)e);
        }
    }
}

